<?php

use App\Http\Controllers\SaaSApiController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'saas'], function () {
    Route::get('/get-food-items', [SaaSApiController::class, 'get_food_items']); // get_food_items
    Route::get('/get-food-groups', [SaaSApiController::class, 'get_food_groups']); // get_food_groups
    Route::get('/get-food-group-wise', [SaaSApiController::class, 'get_food_group_wise']); // get_food_group_wise
    Route::get('/get-food-is-special', [SaaSApiController::class, 'get_food_is_special']); // get_food_is_special
    Route::get('/get-food-variations/{food_id}', [SaaSApiController::class, 'get_food_variations']); // get_food_variations
    Route::get('/get-food-properties', [SaaSApiController::class, 'get_properties_items']); // get_properties_items
    Route::get('/only-food-items', [SaaSApiController::class, 'only_food_items']); // only_food_items
    Route::post('/get-working-period', [SaaSApiController::class, 'check_word_period']); // check_word_period

    // place order
    Route::post('/place-order', [SaaSApiController::class, 'place_order']); // place_order
});