<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReservationInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reservation_infos', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->unsignedBigInteger('time_to_wait')->nullable();
            $table->string('email')->unique()->nullable();
            $table->string('phone')->nullable();
            $table->string('total_guest')->nullable();
            $table->string('branch_id')->nullable();
            $table->string('table_group_id')->nullable();
            $table->string('seat_plan')->nullable();
            $table->string('note')->nullable();
            $table->date('date')->nullable();
            $table->longText('seating_time');
            $table->string('startTime')->nullable();
            $table->string('endTime')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reservation_infos');
    }
}