<?php

use App\Http\Helpers\Helper;
use App\Models\IngredientStockBranch;
use App\Models\Setting;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\DB;

//override or add env file or key
function overWriteEnvFile($type, $val)
{
    $path = base_path('.env'); // get file ENV path
    if (file_exists($path)) {
        $val = '"' . trim($val) . '"';
        if (is_numeric(strpos(file_get_contents($path), $type)) && strpos(file_get_contents($path), $type) >= 0) {
            file_put_contents($path, str_replace($type . '="' . env($type) . '"', $type . '=' . $val, file_get_contents($path)));
        } else {
            file_put_contents($path, file_get_contents($path) . "\r\n" . $type . '=' . $val);
        }
    }
}

//get system settings
function getSystemSettings($type)
{
    $setting = Setting::where('name', $type)->first();
    if (!is_null($setting)) {
        return $setting->value;
    } else {
        return null;
    }
}


//custom pagination
function customPaginate($data)
{
    $currentPage = LengthAwarePaginator::resolveCurrentPage();
    $perPageData = array_slice($data, perPagePaginate() * ($currentPage - 1), perPagePaginate());
    return (new LengthAwarePaginator($perPageData, count($data), perPagePaginate(), $currentPage));
}

//pagination per page data count
function perPagePaginate()
{
    return 100;
}

// get millisecsBetween
function millisecsBetween($dateOne, $dateTwo, $abs = true)
{
    $func = $abs ? 'abs' : 'intval';
    return $func(strtotime($dateOne) - strtotime($dateTwo)) * 1000;
}


/**
 * Checks the stock status of ingredients for a recipe builder at a specific branch.
 * 
 * @param int $recipeBuilderId The ID of the recipe builder.
 * @param int $branch_id The ID of the branch.
 * @return array The stock status object with the title and status.
 */
function checkIngredientsStockStatus($recipeBuilderId, $branch_id)
{
    // Get the recipe ingredients with their required amounts
    $recipeIngredients = DB::table('recipe_ingredients')
        ->where('recipe_builder_id', $recipeBuilderId)
        ->get();

    // Initialize a flag to track if any ingredient is out of stock
    $stockOut = false;

    // Loop through each ingredient in the recipe
    foreach ($recipeIngredients as $ingredient) {
        // Get the quantity required for this ingredient in the recipe
        $requiredQty = $ingredient->amount_of_ingredient;

        // Get the quantity available in stock for this ingredient at the branch
        $availableQty = DB::table('ingredient_stock_branches')
            ->where('branch_id', $branch_id)
            ->where('ingredient_id', $ingredient->ingredient_id)
            ->value('qty');

        // If the available quantity is less than the required quantity, set stockOut flag to true
        if ($availableQty < $requiredQty) {
            $stockOut = true;
            // No need to check further, break the loop
            break;
        }
    }

    // Prepare the stock status based on the stockOut flag
    $stockStatus = [
        'title' => $stockOut ? 'Stock Out' : 'In Stock',
        'status' => $stockOut,
    ];

    return $stockStatus;
}
