<?php

namespace App\Http\Controllers\Api\Stock;

use App\Http\Controllers\Controller;
use App\Models\Unit;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class UnitController extends Controller
{
    public function indexItem()
    {
        $units = Unit::all()->toArray();
        return [customPaginate($units), $units];
    }

    //save new $unit
    public function storeItem(Request $request)
    {
        $unit = new Unit;
        $unit->name = $request->name;
        $unit->slug =  Str::random(3) . '-' . time() . '-' . Str::slug($request->name);

        $unit->save();
        return $this->indexItem();
    }

    //update $unit
    public function updateItem(Request $request)
    {
        $unit = Unit::where('slug', $request->editSlug)->first();
        $unit->name = $request->name;

        $unit->save();
        return $this->indexItem();
    }

    //delete $unit
    public function destroyItem($slug, Request $request)
    {   //check something
        $unit = Unit::where('slug', $slug)->first();
        $unit->delete();
        return $this->indexItem();
    }

    // get all ingredients 
    public function getAllUnits()
    {
        $units = Unit::all();
        return $units;
    }
}
