<?php

namespace App\Http\Controllers\Api\RestaurantDetails;

use App\Http\Controllers\Controller;
use App\Models\Tip;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class TipController extends Controller
{
    //get all tips
    public function index()
    {
        $tips = Tip::all()->toArray();
        return [customPaginate($tips), $tips];
    }

    //save new tip
    public function store(Request $request)
    {
        $checkTipExist = Tip::where('tip_amount', Str::slug($request->tip_amount))->first();
        if (is_null($checkTipExist)) {
            $tip = new Tip;
            $tip->tip_amount = $request->tip_amount;
            $tip->slug =  Str::random(3) . '-' . time() . '-' . Str::slug($request->tip_amount);
            $tip->save();

            //get all tip
            return $this->index();
        } else {
            return "A tip already exists with this key";
        }
    }

    //update tip
    public function update(Request $request)
    {
        $checkTipExist = Tip::where('tip_amount', Str::slug($request->tip_amount))->first();
        if (is_null($checkTipExist)) {
            $tip = Tip::where('slug', $request->editSlug)->first();
            $tip->tip_amount = $request->tip_amount;
            $tip->slug =  Str::random(3) . '-' . time() . '-' . Str::slug($request->tip_amount);
            $tip->save();
            //get all branch
            return $this->index();
        } else {
            return "A tip already exists with this key";
        }
    }

    //delete tip
    public function destroy($slug)
    {
        $tip = Tip::where('slug', $slug)->first();
        $tip->delete();
        //get all branch
        return $this->index();
    }
}
