<?php

namespace App\Http\Controllers\Api\Reservation;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use  App\Models\ReservationInfo;
use App\Models\ReservationSection;
use  App\Models\ReserveSchedule;
use App\Models\Table;
use App\Models\User;
use App\Models\Waiter;
use  App\Notifications\ReservationNotification;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Api\RestaurantDetails\TableController;
use Carbon\Carbon;
use Illuminate\Support\Arr;
use Auth;
use DB;
use DateTime;

class ReservationInfoController extends Controller
{
    //client reservation req
    public function addParty(Request $req)
    {
        // $check
        $checkDate = ReservationInfo::where('date', $req->date)->where('startTime', $req->startTime)->first();
        // check table is available or not with table id
        if (!$checkDate) {
            // try {
            $rsvInfo = new ReservationInfo;
            $rsvInfo->name = $req->name;
            $rsvInfo->time_to_wait = null;
            $rsvInfo->email = $req->email; //unique
            $rsvInfo->phone = $req->phone; //unique
            $rsvInfo->total_guest = $req->total_guest;
            $rsvInfo->branch_id = $req->branch_id;
            $rsvInfo->table_group_id = $req->table_group_id;
            $rsvInfo->seat_plan = $req->seat_plan;
            $rsvInfo->note = $req->note;
            $rsvInfo->date = $req->date; //check for avaibility
            $rsvInfo->startTime = $req->startTime; //check for avaibility
            $rsvInfo->endTime = $req->endTime;
            $rsvInfo->save();

            return response()->json([
                'message' => 'Resrvation request submitted successfully, We will notify you shortly',
                'status' => 200
            ]);


            // } catch (Exception $e) {
            //     return $e;
            // }
        } else {
            return response()->json([
                'message' => 'Sorry!! Can not place reservation right now'
            ], 200);
        }
    }

    // book table from client side 
    public function partyRequest(Request $req)
    {
        // return $req;
        $validator = Validator::make($req->all(), [
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'phone' => 'required',
            'total_guest' => 'required',
            'branch_id' => 'required',
            'date' => 'required|date',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 422,
                'errors' => $validator->messages(),
            ]);
        } else {

            // format date
            // return  $formated_date = Carbon::parse($req->date)->addDays(1)->format('Y-m-d');

            // check date & time both
            // $checkDate = ReservationInfo::where('date', $formated_date)->where('startTime', $req->startTime)->first();
            $checkDate = ReservationInfo::where('date', $req->date)->where('startTime', $req->startTime)->first();

            // if date->time available then take rsv else reject
            if ($checkDate) {
                return response()->json([
                    'message' => 'The reservation time is already booked',
                    'status' => 202
                ]);
            } else {
                $rsvInfo = new ReservationInfo;
                $rsvInfo->name = $req->name;
                $rsvInfo->email = $req->email; //unique
                $rsvInfo->phone = $req->phone; //unique
                $rsvInfo->total_guest = $req->total_guest;
                $rsvInfo->branch_id = $req->branch_id;
                $rsvInfo->note = $req->note;
                // $rsvInfo->date = $formated_date; //check for avaibility
                $rsvInfo->date = Carbon::parse($req->date)->format('Y-m-d'); //test check for availabilty
                $rsvInfo->startTime = $req->startTime; //check for avaibility
                $rsvInfo->save();

                return response()->json([
                    'message' => 'Resrvation request submitted successfully, We will notify you shortly',
                    'status' => 200
                ]);
            }
        }
    }

    // assignTable to the customer
    public function assignCustomerTable(Request $req, $rsvId)
    {
        // $startTime =  Carbon::now();

        // return $startTime;
        // return $today = Carbon::now();
        // return      $today->minute . ':' . $today->second;
        $newTable = $req->table_group_id;
        $rsvInfo = ReservationInfo::where('id', $rsvId)->first();
        $oldTable = json_decode($rsvInfo->table_group_id);
        if ($oldTable) {
            foreach ($oldTable as $id) {
                $table = Table::where('id', $id)->first();
                $table->status = "open";
                $table->rsv_id = null; //newly id
                $table->save();
            }
        }

        // book table
        if ($newTable != []) {
            foreach ($newTable as $id) {
                $table = Table::where('id', $id)->first();
                $table->status = "booked";
                $table->rsv_id = $rsvId; //newly id
                $table->save();

                $rsvInfo->table_group_id =  $newTable;
                $rsvInfo->accepted = 'yes';
                $rsvInfo->save();
            }
        } else {
            $rsvInfo->table_group_id =  null;
            // $rsvInfo->accepted = 'yes';
            $rsvInfo->save();
        }
        return response()->json([
            'message' => 'Table assigned successfully',
            'status' => 200
        ]);
    }

    // get today all reservation list
    public function getWaitlist()
    {
        $today = date(Carbon::now()->format('Y-m-d'));
        // return $today = Carbon::now()->format('Y-m-d');
        $nextDay = date(Carbon::now()->addDays(1)->format('Y-m-d'));
        $nextTenDay = date(Carbon::now()->addDays(10)->format('Y-m-d'));

        // $dlt_it = ReservationInfo::where('id', '76')->first();

        // return gettype($dlt_it->date);
        // return  gettype($nextDay);

        $today_rsv = ReservationInfo::where('canceled', 'no')->where('date', $today)->where('accepted', 'no')->where('check_out', 'no')->with('branches')->get();

        $upcomming_rsv = ReservationInfo::where('canceled', 'no')->whereBetween('date', [$nextDay, $nextTenDay])->where('check_out', 'no')->where('accepted', 'no')->with('branches')->get();

        // return  $upcomming_rsv = ReservationInfo::whereDay('date', [$nextDay, $nextTenDay])->where('accepted', 'no')->with('branches')->get();

        return $data = [
            'today' => $today_rsv,
            'upcomming' => $upcomming_rsv,
        ];
    }


    // get accepted reservation list
    public function getAcceptedReservation()
    {
        $today = Carbon::now()->format('Y-m-d');
        $nextDay = Carbon::now()->addDays(1)->format('Y-m-d');
        $nextTenDay = Carbon::now()->addDays(10)->format('Y-m-d');

        $today_rsv = ReservationInfo::where('accepted', 'yes')->where('date', $today)->with('branches')->get();
        $upcomming_rsv = ReservationInfo::whereBetween('date', [$nextDay, $nextTenDay])->where('accepted', 'yes')->with('branches')->where('table_group_id', null)->get();

        return $data = [
            'today' => $today_rsv,
            'upcomming' => $upcomming_rsv,
        ];
    }

    // remove waitlist reservation
    public function removeWaitlist(Request $req)
    {
        $rsvInfo = ReservationInfo::where('id', $req->id)->first();
        $rsvInfo->canceled = 'yes';
        $rsvInfo->save();
        return $this->getWaitlist();
    }

    // check party available time (it is not working)
    // public  function  checkPartyAvailable(Request $req)
    // {
    //     $time = ReserveSchedule::with('ordered_time')
    //         ->whereDoesntHave('ordered_time', function ($query) {
    //             $query->where('date', '09/01/2022');
    //         })
    //         ->get();

    //     // return count($time);
    //     return $data = [
    //         'left_booked' => ReserveSchedule::with('ordered_time')->whereDoesntHave('ordered_time')->get(),
    //         'left_booked_count' => $time->count(),
    //         'total_booked_count' => ReserveSchedule::count(),
    //         'already_booked' => ReserveSchedule::with('ordered_time')->whereHas('ordered_time')->get()
    //     ];
    // }

    // notify customer
    public function notifyCustomer(Request $req)
    {
        $customer_id = $req->customer_id;
        $message = $req->message;//your 
        $customer = ReservationInfo::where('id', $customer_id)->first();

        try {
            $customer->notify(new ReservationNotification($message));
            return 'message sent successfully';
        } catch (\Exception $e) {
            return $e;
        }
    }

    // checked in customer
    public function checkedinCustomer(Request $req, $customer_id)
    {
        //update table status to seated
        $tables_id = json_decode($req->table_group_id);
        foreach ($tables_id as $id) {
            $table = Table::where('id', $id)->first();
            $table->status = "seated";
            $table->save();
        }

        // update reservation info
        $rsvInfo = ReservationInfo::where('id', $customer_id)->first();
        $rsvInfo->accepted = 'yes';
        $rsvInfo->check_in = 'yes';
        $rsvInfo->save();
        return $this->getWaitlist();
    }

    // checkeout customer
    public function checkoutCustomer(Request $req)
    {
        $tables_id = json_decode($req->table_group_id);
        foreach ($tables_id as $id) {
            $table = Table::where('id', $id)->first();
            $table->status = "dirty";
            $table->rsv_id = null;
            $table->save();
        }

        
        // update reservation info
        $rsvInfo = ReservationInfo::where('id', $req->rsv_id)->first();
        $rsvInfo->check_out = 'yes';
        $rsvInfo->save();
        // return $this->getWaitlist();

        return response()->json([
            'message' => 'Table check out successfully',
            'status' => 200,
            'waitlist'=> $this->getWaitlist()
        ]);
    }

    // show previous assign table on waitlist
    public function showPrevTable(Request $req, $customerId)
    {
        $tableGroup = ReservationInfo::select('table_group_id')->where('id', $customerId)->first();
        $rsvTables = json_decode($tableGroup->table_group_id);
        foreach ($rsvTables as $id) {
            $tables[] = Table::where('id', $id)->with('reservation_infos')->first();
        }
        return $tables;
    }

    // get all canceled reservation
    public function getCanceledReservation()
    {
        $today = Carbon::now()->format('Y-m-d');
        $nextDay = Carbon::now()->addDays(1)->format('Y-m-d');
        $nextTenDay = Carbon::now()->addDays(10)->format('Y-m-d');

        $today_rsv = ReservationInfo::where('canceled', 'yes')->where('date', $today)->with('branches')->get();
        $upcomming_rsv = ReservationInfo::whereBetween('date', [$nextDay, $nextTenDay])->where('canceled', 'yes')->with('branches')->where('table_group_id', null)->get();
        $old_rsv = ReservationInfo::where('date', '<', $today)->with('branches')->paginate(4);

        return $data = [
            'today' => $today_rsv,
            'upcomming' => $upcomming_rsv,
            'old_rsv' => $old_rsv,
        ];
    }

    // get expired reservation
    public function expiredHistoryList()
    {
        $today = Carbon::now()->format('Y-m-d');
        $expired_rsv = ReservationInfo::where('date', '<', $today)->with('branches')->orderBy('date', 'desc')->paginate(4);
        return $expired_rsv;
    }


    // restore canceled reservation
    public function restoreCanceledReservation(Request $req)
    {
        $rsvInfo = ReservationInfo::where('id', $req->customer_id)->first();
        $rsvInfo->canceled = 'no';
        $rsvInfo->save();
        return $this->getCanceledReservation();
    }

    // delete canceled reservation
    public function deleteCanceledReservation(Request $req)
    {
        $rsvInfo = ReservationInfo::where('id', $req->customer_id)->first();
        $rsvInfo->delete();
        return $this->getCanceledReservation();
    }

    // get all reserved table info
    public function getReservationList()
    {
        $today = Carbon::now()->format('Y-m-d');
        $nextDay = Carbon::now()->addDays(1)->format('Y-m-d');
        $nextTenDay = Carbon::now()->addDays(10)->format('Y-m-d');

        $today_rsv = ReservationInfo::where('accepted', 'yes')->where('date', $today)->where('check_out', 'no')->with('branches')->get();

        $upcomming_rsv = ReservationInfo::where('accepted', 'yes')->whereBetween('date', [$nextDay, $nextTenDay])->where('check_out', 'no')->with('branches')->get();

        return $data = [
            'today' => $today_rsv,
            'upcomming' => $upcomming_rsv,
        ];
    }
    // get Reserved history
    public function getReservedhistory()
    {
        $reserved_history = ReservationInfo::where('accepted', 'yes')->where('check_out', 'yes')->with('branches')->get();
        return $reserved_history;
    }

    // get single table info
    public function singleRsvInfo($id)
    {
        $user = ReservationInfo::where('id', $id)->first();
        return $user;
    }

    // delete reservation
    public function deleteReservation(Request $req)
    {
        $rsvInfo = ReservationInfo::where('id', $req->customer_id)->first();
        $rsvTables = json_decode($rsvInfo->table_group_id);

        foreach ($rsvTables as $id) {
            $table = Table::where('id', $id)->first();
            $table->status = "open";
            $table->save();
        }

        $rsvInfo->delete();
        return $this->getReservationList();
    }

    // handle Instant Table Status 
    public function handleInstantTableStatus(Request $req)
    {
        $table_id = $req->table_id;
        $status = $req->status;
        $table = Table::where('id', $table_id)->first();
        $table->status = $status;
        if ($status === 'open') {
            $table->rsv_id = null;
        }
        $table->save();

        // accessing table controller object
        $tableController = new TableController;
        return $tableController->index();
    }
    // handle  group Table Status 
    public function handleGroupTableStatus(Request $req)
    {
        $tablles_to_reset  = json_decode($req->table_group_id);

        foreach ($tablles_to_reset as $id) {
            $reset_table = Table::where('id', $id)->first();
            $reset_table->rsv_id = null;
            $reset_table->status =  $req->status;
            $reset_table->save();
        }
        // accessing other table controller object
        $tableController = new TableController;
        return $tableController->index();
    }

    // get all booked table
    public function bookedTable()
    {
        $table = Table::where('status', 'booked')->get();
        return $table;
    }

    // get table waiters info
    public function getTableWaitersInfo(Request $req, $table_id)
    {
        // return $waiters;
        return  $tables = ReservationSection::select('table_group_id')->get();
        // foreach ($tables as $table->table_group_id) {
        //     $newTable[] = json_decode($table->waiters);
        //     foreach ($table_waiters as $id) {
        //         $waiters[] = User::where('id', $id)->first();
        //     }
        // }
    }

    // reset old table
    public function resetOldTable()
    {
        $tables_groups = [];
        $today = Carbon::now()->format('Y-m-d');

        $expired_rsv = ReservationInfo::where('date', '<', $today)->whereNotNull('table_group_id')->get();

        // set rsv info to null and get all rsvd table
        foreach ($expired_rsv as $expired) {
            $tables_groups[] = json_decode($expired->table_group_id);
            $expired->table_group_id = null;
            $expired->save();
        }



        // single unique array
        $table_unique_group = array_unique(Arr::collapse($tables_groups));

        foreach ($table_unique_group as $id) {
            $change_table = Table::where('id', $id)->where('status', 'booked')->first();
            $change_table->status = 'open';
            $change_table->rsv_id = null;
            $change_table->save();
        }

        // accessing other table controller object
        $tableController = new TableController;
        return $tableController->index();
    }

    // send to waitlist
    public function sendToWaitlist(Request $req)
    {
        $rsvInfo = ReservationInfo::where('id', $req->rsv_id)->first();
        $rsvInfo->accepted = 'no';
        $reset_table_info = json_decode($rsvInfo->table_group_id);

        foreach ($reset_table_info as $id) {
            $table = Table::where('id', $id)->first();
            $table->status = 'open';
            $table->rsv_id = null;
            $table->save();
        }
        $rsvInfo->table_group_id = null;
        $rsvInfo->save();

        // accessing table controller object
        $tableController = new TableController;
        // return $tableController->index();

        return $data = [
            'table' => $tableController->index(),
            'waitlist' =>  $this->getWaitlist(),
        ];
    }

    // delete it
    public function deleteit()
    {
        $seating_time = "2022-08-16T10:53:03.373734Z";
        $distance_time = Carbon::now();

        return millisecsBetween($distance_time, $seating_time, false);
    }
}
