<?php

namespace App\Http\Controllers\Api\Food;

use App\Http\Controllers\Controller;
use App\Models\RecipeBuilder;
use App\Models\RecipeIngredient;
use Illuminate\Http\Request;
use SebastianBergmann\CodeUnit\FunctionUnit;

class RecipeBuilderController extends Controller
{
    public function makeRecipe(Request $request)
    {

        // get value from request
        $des = json_decode($request->input('des'));
        $recipeList = json_decode($request->input('recipeList'));

        // save recipe details
        $RB = new RecipeBuilder;
        $RB->name =  $des->name;
        $RB->instructions =  $des->instructions;
        $RB->save();

        // store each variations details
        foreach ($recipeList as $rl) {
            $RI = new RecipeIngredient;
            $RI->recipe_builder_id = $RB->id;
            $RI->ingredient_id = $rl->id;
            $RI->amount_of_ingredient = $rl->amount_of_ingredient;
            $RI->save();
        }

        return "data saved successfully";
    }

    public function getAllRecipes()
    {
        $allrecipies = RecipeBuilder::paginate(50);
        return $allrecipies;
    }
    public function getAllRecipeswithoutPaginate()
    {
        $allrecipies = RecipeBuilder::get();
        return $allrecipies;
    }

    public function getSingleRecipe($recipeId)
    {
        $allrecipies = RecipeBuilder::with('recipeIngredients.ingredientItem')->find($recipeId);
        if ($allrecipies) {

            return $allrecipies;
        } else {
            return "No data found!";
        }
    }

    public function deleteRecipe($recipeId)
    {
        $recipe = RecipeBuilder::find($recipeId);

        if (!$recipe) {
            return response()->json(['message' => 'Recipe not found'], 404);
        }

        $recipe->recipeIngredients()->delete();
        $recipe->delete();

        return response()->json(['data' => $this->getAllRecipes(), 'message' => 'Recipe and related data deleted successfully'], 200);
    }
}
