<?php

namespace App\Http\Controllers\Api\DebitBook;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DebtorBook;

class DebtorBookController extends Controller
{

    // index
    public function index($customer_id)
    {
        // check new customer with latest transection
        $check_customer_exiest = DebtorBook::where('customer_id', $customer_id)->latest('created_at')->get();
        if ($check_customer_exiest->isNotEmpty()) {
            return  [
                'due' => $check_customer_exiest[0],
                'history' => $check_customer_exiest,

            ];
        } else {

            return  [
                'due' => [],
                'history' => [],

            ];
        }
    }

    // update debtor balance 
    public function updateBalance(Request $req, $customer_id)
    {

        // check new customer with latest transection
        $check_customer_exiest = DebtorBook::where('customer_id', $customer_id)->latest('created_at')->get();
        $old_balance = json_decode($check_customer_exiest[0]->balance);
        $deducted_amount = json_decode($req->balance);
        $new_balance = $old_balance - $deducted_amount;

        $debtor = new DebtorBook();
        $debtor->name = $check_customer_exiest[0]->name;
        $debtor->customer_id = $customer_id;
        $debtor->debit = $req->balance;
        $debtor->balance = $new_balance;
        $debtor->save();

        return $this->index($customer_id);
    }
}