<?php

use App\Http\Controllers\Api\ApiAuthController;
use App\Http\Controllers\Api\OnlineCustomer\OnlineCustomerController;
use App\Http\Controllers\Api\Dashboard\KitchenController;
use App\Http\Controllers\Api\Dashboard\OrderHistoryController;
use App\Http\Controllers\Api\Dashboard\DeliveryUserOrderController;
use App\Http\Controllers\Api\Dashboard\WorkPeriodController;
use App\Http\Controllers\Api\DebitBook\DebtorBookController;
use App\Http\Controllers\Api\Food\FoodGroupController;
use App\Http\Controllers\Api\Food\FoodItemController;
use App\Http\Controllers\Api\Food\FoodUnitController;
use App\Http\Controllers\Api\Food\PropertyGroupController;
use App\Http\Controllers\Api\Food\PropertyItemController;
use App\Http\Controllers\Api\Food\RecipeBuilderController;
use App\Http\Controllers\Api\Food\VariationController;
use App\Http\Controllers\Api\InstallerController;
use App\Http\Controllers\Api\Pos\OrderController;
use App\Http\Controllers\Api\Report\BranchWiseController;
use App\Http\Controllers\Api\Report\DailyController;
use App\Http\Controllers\Api\Report\DashboardController;
use App\Http\Controllers\Api\Report\DepartmentWiseController;
use App\Http\Controllers\Api\Report\DiscountWiseController;
use App\Http\Controllers\Api\Report\GroupWiseController;
use App\Http\Controllers\Api\Report\ItemWiseController;
use App\Http\Controllers\Api\Report\MonthlyController;
use App\Http\Controllers\Api\Report\ServiceChargeWiseController;
use App\Http\Controllers\Api\Report\UserWiseController;
use App\Http\Controllers\Api\RestaurantDetails\BranchController;
use App\Http\Controllers\Api\RestaurantDetails\DeptTagController;
use App\Http\Controllers\Api\RestaurantDetails\TipController;
use App\Http\Controllers\Api\RestaurantDetails\PaymentTypeController;
use App\Http\Controllers\Api\RestaurantDetails\TableController;
use App\Http\Controllers\Api\Settings\CurrencyController;
use App\Http\Controllers\Api\Settings\LanguageController;
use App\Http\Controllers\Api\Settings\PermissionController;
use App\Http\Controllers\Api\Settings\SettingsController;
use App\Http\Controllers\Api\Settings\DeliveryMenCheckController;
use App\Http\Controllers\ShowManageStockController;
use App\Http\Controllers\Api\Users\AdminStaffController;
use App\Http\Controllers\Api\Users\CustomerController;
use App\Http\Controllers\Api\Users\DeliveryController;
use App\Http\Controllers\Api\Users\WaiterController;
use App\Http\Controllers\Api\Website\WebsiteController;
use App\Http\Controllers\Api\Stock\SupplierController;
use App\Http\Controllers\Api\Stock\FoodStockController;
use App\Http\Controllers\Api\Stock\IngredientController;
use App\Http\Controllers\Api\template\TemplateOneController;
use App\Http\Controllers\Api\payment\StripeController;
use App\Http\Controllers\Api\payment\paypalController;
use App\Http\Controllers\Api\Report\XandYController;
use App\Http\Controllers\Api\Reservation\ReservationInfoController;
use App\Http\Controllers\Api\Reservation\ReservationSectionController;
use App\Http\Controllers\Api\Reservation\ReservationScheduleController;
use App\Http\Controllers\Api\sms\SmsController;
use App\Http\Controllers\Api\Stock\UnitController;
use App\Mail\SendHomePageContactFormData;
use App\Models\OnlineOrderGroup;
use App\Models\OnlineOrderItem;
use App\Models\OrderGroup;
use App\Models\OrderItem;
use App\Models\User;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

// test route
Route::get('test-route', function () {
    // return [
    //     'base path' => '../' . base_path(),
    //     'public path' => public_path(),
    //     'root path' => dirname(base_path(), "1"),
    // ];
});

/* installation routes*/

Route::group(['middleware' => 'checkInstall'], function () {
    // Route::get('check-permission', function(){
    //     return 'hello';
    // })->name('permission');
    Route::get('check-permission', [InstallerController::class, 'permission'])->name('permission');
    Route::post('setup/database', [InstallerController::class, 'dbStore'])->name('db.setup');
    Route::get('check-database-connection', [InstallerController::class, 'checkDbConnection'])->name('check.db');
    Route::get('import-fresh-sql', [InstallerController::class, 'sqlUpload'])->name('org.create');
    Route::get('import-demo-sql', [InstallerController::class, 'sqlUploadDemo'])->name('org.create.demo');
    Route::post('setup/admin/store', [InstallerController::class, 'adminStore'])->name('admin.store');
    Route::get('setup/check_ip_domain', [InstallerController::class, 'getServerIpAddress'])->name('check.getServerIpAddress');
});

//passport auth routes
Route::group(['prefix' => 'auth'], function () {
    Route::post('/login', [ApiAuthController::class, 'login']); //login route
    Route::post('/register', [OnlineCustomerController::class, 'store']); //online registration route
    Route::post('/check-register-otp', [OnlineCustomerController::class, 'checkOtp']); //online register check otp
    Route::post('/be-delivery-man', [DeliveryController::class, 'storeDeliveryMan']); //online registration route
    Route::group(['middleware' => 'auth:api'], function () {
        Route::get('/logout', [ApiAuthController::class, 'logout']); //logout route
        Route::get('/user', [ApiAuthController::class, 'user']); //get auth user
    });
    Route::post('/resetPassword', [ApiAuthController::class, 'sendEmailToken']);
    Route::post('/setNewPassword', [ApiAuthController::class, 'setNewPassword']);
});

//website Routes
Route::group(['prefix' => 'website'], function () {
    Route::get('/home', [OnlineCustomerController::class, 'index']); //foods route
    //branch
    Route::get('/get-branch-web', [BranchController::class, 'indexWeb']); //get all branch
    Route::group(['middleware' => 'auth:api'], function () {
        //customers
        Route::post('/order', [OnlineCustomerController::class, 'storeOrder']); //online order route
        Route::get('/pending-order', [OnlineCustomerController::class, 'pending']); //online order route
        Route::get('/online-orders', [OnlineCustomerController::class, 'onlineOrders']); //online order route
        Route::get('/online-orders/customer', [OnlineCustomerController::class, 'onlineOrdersCustomer']); //online order route
        Route::post('/update-user-profile', [OnlineCustomerController::class, 'updateProfile']); //online order route
        //admins
        Route::post('/accept-order', [OnlineCustomerController::class, 'acceptOnlineOrders']); //online order route
        Route::post('/cancel-order', [OnlineCustomerController::class, 'cancelOnlineOrders']); //online order route
    });
});

//check install
Route::get('/check-install', function () {
    try {
        $value = \Config::get('app.install');
        if ($value == "7469a286259799e5b37e5db9296f00b3") {
            return "YES";
        } else {
            return "NO";
        }
    } catch (\Exception $e) {
        return "NO";
    }
});

//check saas active
Route::get('/check-saas-active-and-demo', function () {

    $collect = collect([
        env('YOUR_DOMAIN'),
        env('SAAS_ACTIVE'),
        env('DEMO'),
    ]);

    return $collect;
});

//Manage routes
//unauthenticated
Route::group(['prefix' => 'settings'], function () {
    //languages
    Route::get('/get-lang', [LanguageController::class, 'index']); //get all languages
    Route::post('/save-to-en', [LanguageController::class, 'store']); //save new key to en

    //currencies
    Route::get('/get-currency', [CurrencyController::class, 'index']); //get all currencies

    //general-settings
    Route::get('/general-settings', [SettingsController::class, 'index']); //get general-settings configuration

    Route::post('/deliverymen-settings', [DeliveryMenCheckController::class, 'index']); //set delivery men info

    Route::get('/deliverymen-menu-info', [DeliveryMenCheckController::class, 'getCheckData']); //get delivery updated info

    Route::post('/show-manage-stock-settings', [ShowManageStockController::class, 'index']); //set managestock info

    Route::get('/show-manage-stock-menu-info', [ShowManageStockController::class, 'getCheckData']); //get managestock info

    //get template one items
    Route::get('/get-template-one-items', [TemplateOneController::class, 'templateAllItem']); //get template one items 

    Route::get('/get-templateone-gallery-item', [TemplateOneController::class, 'getGallery']);
    //get value
    Route::get('/get-template-value', function () {
        return env('ACTIVE_TEMPLATE');
    });
    Route::get('/get-template-value-sidebar', function () {
        return env('ACTIVE_TEMPLATE', '1');
    });
    // show twilio button
    Route::get('/show-twilio-btn', function () {
        return env('TWILIO_SHOW');
        // return 'twilio ashe na ken';
    });

    // show stripe button on frontend panel
    Route::get('/show-stripe-btn', function () {
        return env('STRIPE_SHOW');
    });

    // paypal client id
    // Route::post('/paypal-client-id',function(Request $request){
    //     // return $request->paypal_id;
    //     overWriteEnvFile('PAYPAL_CLIENT_ID', $request->paypal_id);
    //     Artisan::call('cache:clear');
    //     return 'okk';
    // });
    // Route::get('/get-paypal-client-id',function(){
    //     // return "'".env('PAYPAL_CLIENT_ID')."'";
    //     return env('PAYPAL_CLIENT_ID');
    // });
    Route::post('/set-payment-client-id', [paypalController::class, 'store']);
    Route::get('/get-payment-client-id', [paypalController::class, 'showPaypal']);

    // google recapture
    Route::get('/get-google-recpature', function () {
        $data = [
            "siteKey" => env('RECAPTCHA_SITE_KEY'),
            "show" => env('RECAPTCHA_SHOW'),
        ];

        return $data;
    });
    // show website show options
    Route::get('/get-show-website', function () {
        return env('WEBSITE_SHOW');
    });

    // hero slider sections
    Route::get('/get-hero-sliders', [WebsiteController::class, 'getallSliders']); //get all hero sliders

    // hmc_ templace edit content
    Route::get('/get-hmc-template-data', [TemplateOneController::class, 'getHmcTemplateData']);
});

//authenticated
Route::group(['prefix' => 'settings', 'middleware' => ['auth:api']], function () {

    // send email 
    Route::post('/send-contact-form', function (Request $req) {

        $admin_user_email = User::where("user_type", "superAdmin")->pluck("email");
        Mail::to(
            $admin_user_email[0]
        )->send(new SendHomePageContactFormData($req->data));

        return "ok";
    });

    Route::post('/save-template-settings', [TemplateOneController::class, 'saveTemplateHomeContent']);

    // debitbook routes
    Route::get('/get-debtor-info/{customer_id}', [DebtorBookController::class, 'index']);
    // update balance
    Route::post('/update-debtor-balance/{customer_id}', [DebtorBookController::class, 'updateBalance']);


    //without permission middleware
    //auth user profile
    Route::post('/update-profile', [AdminStaffController::class, 'updateProfile']); // update auth user profile

    //permission group
    Route::get('/permission-group-list', [PermissionController::class, 'index']); //get all permissions group

    //branch
    Route::get('/get-branch', [BranchController::class, 'index']); //get all branch

    //assign permission middleware
    //Manage Middleware
    Route::group(['middleware' => ['manage']], function () {
        //Settings
        //currencies
        Route::post('/new-currency', [CurrencyController::class, 'store']); //store new currency
        Route::post('/update-currency', [CurrencyController::class, 'update']); //update currency
        Route::post('/update-default-currency', [CurrencyController::class, 'setDefault']); //default currency
        Route::get('/delete-currency/{code?}', [CurrencyController::class, 'destroy']); //delete currency

        //languages
        Route::post('/new-lang', [LanguageController::class, 'langStore']); //store new language
        Route::post('/update-lang', [LanguageController::class, 'langUpdate']); //update language
        Route::post('/update-default', [LanguageController::class, 'setDefault']); //default language
        Route::get('/delete-lang/{code}', [LanguageController::class, 'destroy']); //delete language

        //translation
        Route::get('/get-lang/{code}', [LanguageController::class, 'getTranslations']); //get items to translate
        Route::post('/save-translation', [LanguageController::class, 'saveTranslation']); //save translation

        //email-smtp
        Route::get('/get-smtp', [SettingsController::class, 'smtp']); //get smtp configuration
        Route::post('/set-smtp', [SettingsController::class, 'smtpStore']); //store smtp configuration

        //general-settings
        Route::post('/general-settings', [SettingsController::class, 'store']); //store general-settings configuration
        Route::post('/pos-screen', [SettingsController::class, 'posScreen']); //posScreen settings configuration

        //website configuration
        Route::post('/hero-section', [WebsiteController::class, 'store']); //store hero section configuration
        Route::post('/promotion-section', [WebsiteController::class, 'promotionStore']); //store hero section configuration

        Route::post('/add-new-hero-slider', [WebsiteController::class, 'addNewSlider']); //add new slider

        Route::get('/delete-hero-slider/{sliderId}', [WebsiteController::class, 'deleteHeroSlider']); //delete slider

        Route::post('/edit-new-hero-slider', [WebsiteController::class, 'editHeroSlider']); //edit slider

        //update system
        Route::post('/update-system', [SettingsController::class, 'updateSystem']); //store general-settings configuration
        Route::get('/refresh-system', [SettingsController::class, 'refreshSystem']); //refresh configuration

        //user management
        //permission group
        Route::post('/new-permission-group', [PermissionController::class, 'store']); //store new permission group
        Route::post('/update-permission-group', [PermissionController::class, 'update']); //update permission group
        Route::get('/delete-permission-group/{slug}', [PermissionController::class, 'destroy']); //delete permission group

        //waiter
        Route::post('/new-waiter', [WaiterController::class, 'store']); //store new waiter
        Route::post('/update-waiter', [WaiterController::class, 'update']); //update waiter
        Route::get('/delete-waiter/{slug}', [WaiterController::class, 'destroy']); //delete waiter

        //admin-staff
        Route::post('/new-admin-staff', [AdminStaffController::class, 'store']); //store new admin-staff
        Route::post('/update-admin-staff', [AdminStaffController::class, 'update']); //update admin-staff
        Route::get('/delete-admin-staff/{slug}', [AdminStaffController::class, 'destroy']); //disable-active admin-staff

        //delivery man
        Route::post('/new-delivery-man', [DeliveryController::class, 'store']); //store new delivery man
        Route::post('/update-delivery-man', [DeliveryController::class, 'update']); //update delivery man
        Route::post('/approve-delivery-man', [DeliveryController::class, 'approveDeliveryMan']); //approveDeliveryMan
        Route::get('/delete-delivery-man/{slug}', [DeliveryController::class, 'destroy']); //disable-active delivery man

        //supplier
        Route::get('/get-supplier', [SupplierController::class, 'index']); //get all supplier
        Route::post('/new-supplier', [SupplierController::class, 'store']); //store new supplier
        Route::post('/update-supplier', [SupplierController::class, 'update']); //update supplier
        Route::get('/delete-supplier/{slug}', [SupplierController::class, 'destroy']); //delete supplier
        Route::post('/get-supplier-report', [SupplierController::class, 'supplierLeadger']); //supplierLeadger


        //ingredient_group
        Route::get('/get-ingredient_group', [IngredientController::class, 'indexGroup']); //get all ingredient_group
        Route::post('/new-ingredient_group', [IngredientController::class, 'storeGroup']); //store new ingredient_group
        Route::post('/update-ingredient_group', [IngredientController::class, 'updateGroup']); //update ingredient_group
        Route::get('/delete-ingredient_group/{slug}', [IngredientController::class, 'destroyGroup']); //delete ingredient_group
        //ingredient item
        Route::get('/get-ingredient_item', [IngredientController::class, 'indexItem']); //get all ingredient_item
        Route::get('/get-all-ingredient_item', [IngredientController::class, 'getAllIngredients']); //get all ingredient_item without pagination
        Route::post('/new-ingredient_item', [IngredientController::class, 'storeItem']); //store new ingredient_item
        Route::post('/update-ingredient_item', [IngredientController::class, 'updateItem']); //update ingredient_item
        Route::get('/delete-ingredient_item/{slug}', [IngredientController::class, 'destroyItem']); //delete ingredient_item

        //ingredient purchase
        Route::get('/get-ingredient_purchase', [IngredientController::class, 'indexPurchase']); //get all Purchase
        Route::get('/get-ingredient_purchase_items/{id}', [IngredientController::class, 'indexPurchaseItems']); //get all Purchase
        Route::post('/new-ingredient_purchase', [IngredientController::class, 'storePurchase']); //store new Purchase
        Route::post('/update-ingredient_purchase', [IngredientController::class, 'updatePurchase']); //update Purchase
        Route::get('/delete-ingredient_purchase/{slug}', [IngredientController::class, 'destroyPurchase']); //delete Purchase

        //units
        Route::get('/get-unit', [UnitController::class, 'indexItem']); //get all unit
        Route::get('/get-all-unit', [UnitController::class, 'getAllUnits']); //get all unit without pagination
        Route::post('/new-unit', [UnitController::class, 'storeItem']); //store new unit
        Route::post('/update-unit', [UnitController::class, 'updateItem']); //update unit
        Route::get('/delete-unit/{slug}', [UnitController::class, 'destroyItem']); //delete unit

        // recipe builder
        Route::post('/make-recipe', [RecipeBuilderController::class, 'makeRecipe']); //make recipe
        Route::get('/get-all-recipes', [RecipeBuilderController::class, 'getAllRecipes']); //get all recipes
        Route::get('/get-all-recipes-without-paginate', [RecipeBuilderController::class, 'getAllRecipeswithoutPaginate']); //get all recipes
        Route::get('/get-all-single-recipe/{recipeId}', [RecipeBuilderController::class, 'getSingleRecipe']); //get all recipes
        Route::get('/delete-recipe/{recipeId}', [RecipeBuilderController::class, 'deleteRecipe']); //get all recipes

        //food purchase
        Route::get('/get-food_purchase', [FoodStockController::class, 'indexPurchase']); //get all Purchase
        Route::get('/get-food_purchase_items/{id}', [FoodStockController::class, 'indexPurchaseItems']); //get all Purchase
        Route::post('/new-food_purchase', [FoodStockController::class, 'storePurchase']); //store new Purchase
        Route::post('/update-food_purchase', [FoodStockController::class, 'updatePurchase']); //update Purchase
        Route::get('/delete-food_purchase/{slug}', [FoodStockController::class, 'destroyPurchase']); //delete Purchase

        //restaurant
        //branch
        Route::post('/new-branch', [BranchController::class, 'store']); //store new branch
        Route::post('/update-branch', [BranchController::class, 'update']); //update branch
        Route::get('/delete-branch/{slug}', [BranchController::class, 'destroy']); //delete branch

        //table
        Route::get('/all-table', [TableController::class, 'index']); //get all tables
        Route::post('/new-table', [TableController::class, 'store']); //store new table
        Route::post('/update-table', [TableController::class, 'update']); //update table
        Route::get('/delete-table/{slug}', [TableController::class, 'destroy']); //delete table
        Route::get('/get-sections-table-groups/{groupTable}', [TableController::class, 'sectionsTable']); //get data
        // Route::get('/get-sections-table-groups', [TableController::class, 'sectionsTable']); //get data

        //dept-tag
        Route::post('/new-dept-tag', [DeptTagController::class, 'store']); //store new dept-tag
        Route::post('/update-dept-tag', [DeptTagController::class, 'update']); //update dept-tag
        Route::get('/delete-dept-tag/{slug}', [DeptTagController::class, 'destroy']); //delete dept-tag

        //tips
        Route::post('/new-tip', [TipController::class, 'store']); //store new tip
        Route::post('/update-tip', [TipController::class, 'update']); //update tip
        Route::get('/delete-tip/{slug}', [TipController::class, 'destroy']); //delete tip

        //payment type
        Route::post('/new-payment-type', [PaymentTypeController::class, 'store']); //store new payment-type
        Route::post('/update-payment-type', [PaymentTypeController::class, 'update']); //update payment-type
        Route::get('/delete-payment-type/{slug}', [PaymentTypeController::class, 'destroy']); //delete payment-type

        //food
        //food item
        Route::post('/new-food-item', [FooditemController::class, 'store']); //store new food-item
        Route::post('/update-food-item', [FooditemController::class, 'update']); //update food-item
        Route::post('/update-food-item-variation', [FooditemController::class, 'updateVariation']); //update food-item-variation
        Route::post('/new-food-item-variation', [FooditemController::class, 'storeVariation']); //store new food-item-variation
        Route::get('/delete-food-item/{slug}', [FooditemController::class, 'destroy']); //delete food-item

        //food group
        Route::post('/new-food-group', [FoodGroupController::class, 'store']); //store new food-group
        Route::post('/update-food-group', [FoodGroupController::class, 'update']); //update food-group
        Route::get('/delete-food-group/{slug}', [FoodGroupController::class, 'destroy']); //delete food-group

        //food unit
        Route::get('/get-food-unit', [FoodUnitController::class, 'index']); //get all food-unit
        Route::post('/new-food-unit', [FoodUnitController::class, 'store']); //store new food-unit
        Route::post('/update-food-unit', [FoodUnitController::class, 'update']); //update food-unit
        Route::get('/delete-food-unit/{slug}', [FoodUnitController::class, 'destroy']); //delete food-unit

        //variation
        Route::post('/new-variation', [VariationController::class, 'store']); //store new variation
        Route::post('/update-variation', [VariationController::class, 'update']); //update variation
        Route::get('/delete-variation/{slug}', [VariationController::class, 'destroy']); //delete variation

        //property-group
        Route::post('/new-property-group', [PropertyGroupController::class, 'store']); //store new property-group
        Route::post('/update-property-group', [PropertyGroupController::class, 'update']); //update property-group
        Route::get('/delete-property-group/{slug}', [PropertyGroupController::class, 'destroy']); //delete property-group

        //property-item
        Route::post('/new-property-item', [PropertyItemController::class, 'store']); //store new property-item
        Route::post('/update-property-item', [PropertyItemController::class, 'update']); //update property-item
        Route::get('/delete-property-item/{slug}', [PropertyItemController::class, 'destroy']); //delete property-item

        // google recaptcha
        Route::post('/setup-google-recapture', function (Request $req) {
            // return $req;
            overWriteEnvFile('RECAPTCHA_SITE_KEY', $req->siteKey);
            overWriteEnvFile('RECAPTCHA_SECRET_KEY', $req->secretKey);
            if ($req->show == 1) {
                overWriteEnvFile('RECAPTCHA_SHOW', "YES");
            } else {
                overWriteEnvFile('RECAPTCHA_SHOW', "NO");
            }
            Artisan::call('optimize:clear');
            return response()->json([
                'status' => 200,
                'message' => 'succesfull'
            ]);
        });
        Route::get('/get-google-recapture-values', function (Request $req) {
            $data = [
                "siteKey" => env('RECAPTCHA_SITE_KEY'),
                "secretKey" => env('RECAPTCHA_SECRET_KEY'),
                "show" => env('RECAPTCHA_SHOW'),
            ];

            return $data;
        });

        // website show hide
        Route::post('/show-website', function (Request $req) {

            // return $req;
            if ($req->show === true) {
                overWriteEnvFile('WEBSITE_SHOW', "YES");
            }
            if ($req->show === false) {
                overWriteEnvFile('WEBSITE_SHOW', "NO");
            }


            // Artisan::call('optimize:clear');
            // return env('WEBSITE_SHOW');
            // return $req;
        });
    });

    //Work period middleware
    Route::group(['middleware' => ['workPeriod']], function () {
        //work period
        Route::post('/new-work-period', [WorkPeriodController::class, 'store']); //store new work-period
        Route::post('/update-work-period', [WorkPeriodController::class, 'update']); //update work-period
        Route::get('/get-closing-items/{id}', [WorkPeriodController::class, 'getStockItems']); //getStockItems
        Route::get('/get-closing-items-food/{id}', [WorkPeriodController::class, 'getStockItemsFood']); //getStockItems
        Route::post('/update-closing-items', [WorkPeriodController::class, 'updateStockItems']); //getStockItems
    });

    //customer middleware, for customer list, pos
    Route::group(['middleware' => ['customer']], function () {
        //admin-staff
        Route::get('/get-admin-staff', [AdminStaffController::class, 'index']); //get all admin-staff
        //delivery man
        Route::get('/get-delivery-man', [DeliveryController::class, 'index']); //get all delivery man

        //work period
        Route::get('/get-work-period', [WorkPeriodController::class, 'index']); //get all work-period

        //customer
        Route::get('/get-customer', [CustomerController::class, 'index']); //get all customer
        Route::post('/new-customer', [CustomerController::class, 'store']); //store new customer
        Route::post('/update-customer', [CustomerController::class, 'update']); //update customer
        Route::get('/delete-customer/{slug}', [CustomerController::class, 'destroy']); //delete customer

        //customer online
        Route::get('/get-website-customer', [CustomerController::class, 'indexOnline']); //get all customer

        //table
        Route::get('/get-table', [TableController::class, 'index']); //get all table

        //waiter
        Route::get('/get-waiter', [WaiterController::class, 'index']); //get all waiter

        //dept-tag
        Route::get('/get-dept-tag', [DeptTagController::class, 'index']); //get all dept-tag

        //tip
        Route::get('/get-tip', [TipController::class, 'index']); //get all dept-tag

        //payment type
        Route::get('/get-payment-type', [PaymentTypeController::class, 'index']); //get all payment-type

        //food item
        Route::get('/get-food-item', [FooditemController::class, 'index']); //get all food-item

        //food group
        Route::get('/get-food-group', [FoodGroupController::class, 'index']); //get all food-group

        //variation
        Route::get('/get-variation', [VariationController::class, 'index']); //get all variation

        //property-group
        Route::get('/get-property-group', [PropertyGroupController::class, 'index']); //get all property-group

        //property-item
        Route::get('/get-property-item/{slug}', [PropertyItemController::class, 'index']); //get all property-item

        //orders from pos page
        Route::post('/new-order', [OrderController::class, 'submit']); //add items as new order
        Route::post('/settle-order', [OrderController::class, 'settle']); //add items as new settled order
        Route::get('/get-submitted-orders', [OrderController::class, 'getSubmitted']);
        Route::get('/get-settled-orders', [OrderController::class, 'getSettled']);
        Route::post('/settle-submitted-order', [OrderController::class, 'submitToSettle']); //submit to settle
        Route::post('/cancel-submitted-order', [OrderController::class, 'cancelSubmitted']); //cancel submitted
        Route::get('/settle-order-ready/{id}', [OrderController::class, 'settleOrderReady']); //submit to settle
        Route::post('/set-old-order', [OrderController::class, 'update']); //set old order
        Route::get('/edit-submit-order/{id}', [OrderController::class, 'EditSubmitOrder']); //set old order
        Route::get('/get-editted-order', [OrderController::class, 'getEdiitedOrder']); //get editted order

        //report routes goes here in customer middleware, coz to generate reports thget-discount-reportata from above routes are needed
        Route::get('/report-dashboard', [DashboardController::class, 'index']); //dashboard
        Route::get('/get-daily-report', [DailyController::class, 'index']); //daily
        Route::get('/get-online-daily-report', [DailyController::class, 'OnlineIndex']); //daily
        Route::get('/get-monthly-report', [MonthlyController::class, 'index']); //monthly
        Route::post('/get-monthly-report', [MonthlyController::class, 'filter']); //selected month
        Route::get('/get-online-monthly-report', [MonthlyController::class, 'onlineIndex']); //monthly
        Route::post('/get-online-monthly-report', [MonthlyController::class, 'onlineFilter']); //selected month
        Route::post('/get-food-item-report', [ItemWiseController::class, 'filter']); //food-group wise
        Route::post('/get-online-food-item-report', [ItemWiseController::class, 'onlineFilter']); //food-group wise
        Route::post('/get-food-group-report', [GroupWiseController::class, 'filter']); //food-group wise
        Route::post('/get-online-food-group-report', [GroupWiseController::class, 'onlineFilter']); //food-group wise
        Route::post('/get-branch-report', [BranchWiseController::class, 'filter']); //branch wise
        Route::post('/get-online-branch-report', [BranchWiseController::class, 'onlineFilter']); //branch wise
        Route::post('/get-user-report', [UserWiseController::class, 'filter']); //user wise
        Route::post('/get-online-user-report', [UserWiseController::class, 'onlineFilter']); //user wise
        Route::post('/get-department-report', [DepartmentWiseController::class, 'filter']); //department wise
        Route::post('/get-service-report', [ServiceChargeWiseController::class, 'filter']); //service charge wise
        Route::post('/get-discount-report', [DiscountWiseController::class, 'filter']); //discount charge wise
        Route::get('/get-discount-type', [DiscountWiseController::class, 'discountType']); //discount type
        //stock report
        Route::post('/get-food-stock-report', [FoodStockController::class, 'filter']); //food stock wise

    });

    //kitchen middleware
    Route::group(['middleware' => ['kitchen']], function () {
        //kitchen dashboard
        Route::get('/get-new-orders', [KitchenController::class, 'index']); //get all new order, is_ready == 0; is_cancelled == 0;
        Route::get('/get-new-orders-online', [KitchenController::class, 'indexOnline']); //get all new order, is_ready == 0; is_cancelled == 0;
        Route::post('/accept-new-order', [KitchenController::class, 'accept']); //accept new order
        Route::post('/mark-order-item-ready', [KitchenController::class, 'itemReady']); //order-item-ready
        Route::post('/mark-all-items-ready', [KitchenController::class, 'orderReady']); //all order-items-ready and order ready

        Route::post('/accept-new-order-online', [KitchenController::class, 'acceptOnline']); //accept new order
        Route::post('/mark-order-item-ready-online', [KitchenController::class, 'itemReadyOnline']); //order-item-ready
        Route::post('/mark-all-items-ready-online', [KitchenController::class, 'orderReadyOnline']); //all order-items-ready and order ready
    });

    //orderHistory middleware
    Route::group(['middleware' => ['orderHistory']], function () {
        //order history
        Route::get('/get-order-history', [orderHistoryController::class, 'index']); //get all new order
        Route::get('/get-order-history-all', [orderHistoryController::class, 'indexAll']); //get all new order
        Route::post('/delete-order-from-history', [orderHistoryController::class, 'destroy']); //delete an order
        //online orders
        Route::get('/get-online-order-history', [orderHistoryController::class, 'indexOnline']); //get all new order
        Route::get('/get-online-order-history-all', [orderHistoryController::class, 'indexAllOnline']); //get all new order
        Route::post('/delete-online-order-from-history', [orderHistoryController::class, 'destroyOnline']); //delete an order
    });

    // DeliveryMan User Routes middleware
    Route::group(['middleware' => ['delivery']], function () {
        //work period
        Route::get('/get-assigned-counters', [DeliveryUserOrderController::class, 'alarm']); //get pending count
        Route::get('/get-assigned-orders', [DeliveryUserOrderController::class, 'index']); //get non delivered orders
        Route::post('/change-status', [DeliveryUserOrderController::class, 'changeStatus']); //change status

        Route::get('/get-delivered-orders', [DeliveryUserOrderController::class, 'indexDelivered']); //get delivered orders
    });

    // Template settings
    Route::group(['middleware' => ['template']], function () {
        Route::post('/store-hero-section', [TemplateOneController::class, 'hero']); //store and update hero section
        Route::post('/store-about-section', [TemplateOneController::class, 'about']); //store and update about section
        Route::post('/store-feature-section', [TemplateOneController::class, 'feature']); //store and update feature section
        Route::post('/store-delivery-section', [TemplateOneController::class, 'delivery']); //store and update feature section
        Route::post('/store-gallery-section', [TemplateOneController::class, 'gallery']); //store and update feature section
        Route::get('/get-gallery-item', [TemplateOneController::class, 'getGallery']); //get value
        Route::delete('/delete-gallery-item/{name}', [TemplateOneController::class, 'deleteItem']); //delete value
        Route::post('/enable-gallery-section', [TemplateOneController::class, 'enableGallary']); //set enable/disable gallery

        //set template
        Route::post('/set-template-value', function (Request $request) {
            // return $request->value;
            overWriteEnvFile('ACTIVE_TEMPLATE', $request->value);
            Artisan::call('optimize:clear');
            return response()->json([
                'status' => 200,
                'message' => 'succesfull'
            ]);
        });
    });

    // paypal payment
    Route::post('/setup-paypal', [paypalController::class, 'setupPaypal']);

    // show paypal btn
    Route::post('/show-paypal-btn', [paypalController::class, 'showPaypalBtn']);

    Route::get('/get-paypal-data', [paypalController::class, 'getPaypalDetails']);

    // stripe payment
    Route::post('/get-stripe-data', [StripeController::class, 'handleStripe']);

    // set up payment from dashboard panel
    Route::post('/setup-stripe', [StripeController::class, 'setStripe']);

    // show stripe info to dashboard settings
    Route::get('/get-stripe-info', [StripeController::class, 'showStripeInfo']);

    // stripe card connect
    Route::post('/connect-stripe-card-reader', [StripeController::class, 'connectCardReader']);

    // stripe card reader
    Route::post('/get-stripe-card-reader', [StripeController::class, 'makeCardPayment']);

    // list all connected readers
    Route::get('/list-all-connected-readers', [StripeController::class, 'listAllCardReader']);

    //show stripe card button
    Route::get('/show-stripe-card-reader-button', function () {
        return env('STRIPE_CARD_SHOW');
    });

    // flutterwave setup
    Route::post('/setup-flutterwave', function (Request $req) {
        overWriteEnvFile('FLUTTERWAVE_PUBLIC_KEY', $req->publicKey);
        overWriteEnvFile('FLUTTERWAVE_SECRET_KEY', $req->secretKey);
        overWriteEnvFile('FLUTTERWAVE_CURRENCY_CODE', $req->currency_code);

        if ($req->show == "true") {
            overWriteEnvFile('FLUTTERWAVE_SHOW', "YES");
        } else if ($req->show == "false") {
            overWriteEnvFile('FLUTTERWAVE_SHOW', "NO");
        }
        // Artisan::call('optimize:clear');
        return 'Okk';
    });
    // get flutterwave info
    Route::get('/get-flutterwave-info', function () {
        $allInfo = [];
        $allInfo = array(
            "FLUTTERWAVE_PUBLIC_KEY" => env('FLUTTERWAVE_PUBLIC_KEY'),
            "FLUTTERWAVE_SECRET_KEY" => env('FLUTTERWAVE_SECRET_KEY'),
            "FLUTTERWAVE_CURRENCY_CODE" => env('FLUTTERWAVE_CURRENCY_CODE'),
            "FLUTTERWAVE_SHOW" => env('FLUTTERWAVE_SHOW'),
        );

        return $allInfo;
    });

    // twilio
    Route::post('/setup-twilio', [SmsController::class, 'handleTwilio']);
    Route::get('/get-twilio-info', [SmsController::class, 'getTwilioInfo']);

    // add party reservation
    Route::post('/add-party', [ReservationInfoController::class, 'addParty']); //add party
    Route::post('/client-party-request', [ReservationInfoController::class, 'partyRequest']); //client party request
    Route::post('/check-party-available-time', [ReservationInfoController::class, 'checkPartyAvailable']); //check-party-available-time

    //reservation waitlist
    Route::post('/assign-tables-to-customer/{rsvId}', [ReservationInfoController::class, 'assignCustomerTable']); //assign table to customer rsvId== reservationInfo id
    Route::get('/show-assign-tables-to-customer/{customerId}', [ReservationInfoController::class, 'showPrevTable']); //show assign table to customer
    Route::post('/notify-customer', [ReservationInfoController::class, 'notifyCustomer']); //notify customer 
    Route::post('/checkedin-customer/{customer_id}', [ReservationInfoController::class, 'checkedinCustomer']); //customer checked in
    Route::post('/checkout-customer', [ReservationInfoController::class, 'checkoutCustomer']); //customer checked in
    Route::post('/remove-waitlist-reservation', [ReservationInfoController::class, 'removeWaitlist']); //customer checked in
    Route::get('/get-waitlist-reservations', [ReservationInfoController::class, 'getWaitlist']); //get-all-today-reservations
    Route::get('/get-accepted-reservations-list', [ReservationInfoController::class, 'getAcceptedReservation']); //get accepted reservation info
    Route::post('/rsv-send-to-waitlist', [ReservationInfoController::class, 'sendToWaitlist']); //send to waitlist

    // report routes fox X and Y
    Route::get('/get-x-report/{workPeriod_start}', [XandYController::class, "generateXReport"]);
    Route::get('/get-x-report-online/{workPeriod_start}', [XandYController::class, "generateXReportOnline"]);
    Route::get('/get-x-department/{workPeriod_start}', [XandYController::class, "getDepartmentPosOrder"]);
    Route::get('/get-all-pos-order', [XandYController::class, "todayPosOrder"]);
    // main one start 

    // get full report
    Route::get('/get-full-report/{workPeriod_start}', [XandYController::class, "getReportInfo"]);

    // main one start 





    // add reserve time
    Route::get('/get-all-schedule', [ReservationScheduleController::class, 'index']); //get schedule
    Route::post('/add-schedule', [ReservationScheduleController::class, 'store']); //add schedule
    Route::post('/delete-schedule/{id}', [ReservationScheduleController::class, 'delete']); //delete schedule

    // reservation section
    Route::get('/get-section-details', [ReservationSectionController::class, 'index']); //all section details
    Route::post('/add-rsv-section', [ReservationSectionController::class, 'saveSection']); //save section name
    Route::post('/edit-rsv-section/{id}', [ReservationSectionController::class, 'editSection']); //edit section name id==section_id
    Route::get('/delete-rsv-section/{id}', [ReservationSectionController::class, 'deleteSection']); //delete section and change table status id==section_id
    Route::post('/assign-tables-to-section/{id}', [ReservationSectionController::class, 'assignTable']); //assign table to section id==section_id
    Route::post('/assign-waiter-to-table', [ReservationSectionController::class, 'assignWaiter']); //assign waiter to section id==section_id
    Route::get('/assigned-tables-to-section/{id}', [ReservationSectionController::class, 'sectionAssignedTable']); //get all assign tables of specific section

    // reservation history
    Route::get('/get-all-canceled-rsv', [ReservationInfoController::class, 'getCanceledReservation']);  //get all cancel rsv
    Route::post('/restore-customer', [ReservationInfoController::class, 'restoreCanceledReservation']);  //restore canceled rsv
    Route::post('/delete-customer', [ReservationInfoController::class, 'deleteCanceledReservation']);  //delete canceled rsv
    Route::get('/expired-history-list', [ReservationInfoController::class, 'expiredHistoryList']);  //get expired rsv list

    // reservation list
    Route::get('/get-all-reservation-list', [ReservationInfoController::class, 'getReservationList']); //get all reservation list
    Route::post('/delete-reservation', [ReservationInfoController::class, 'deleteReservation']); //get all reservation list
    Route::get('/get-single-rsv-info/{id}', [ReservationInfoController::class, 'singleRsvInfo']); //get  single reservation info by id
    Route::get('/get-reserved-history', [ReservationInfoController::class, 'getReservedhistory']); //get  Reserved history

    // Instant AssignTable 
    Route::post('/instant-table-status', [ReservationInfoController::class, 'handleInstantTableStatus']); //handle instant table status

    // group-table-status-remove
    Route::post('/group-table-status-remove', [ReservationInfoController::class, 'handleGroupTableStatus']); //group-table-status-remove

    // reaservation seated/booked
    Route::get('/get-booked-tables', [ReservationInfoController::class, 'bookedTable']);  //handle instant table status

    // tables waiters info 
    Route::post('/get-tables-waiters-info/{table_id}', [ReservationInfoController::class, 'getTableWaitersInfo']);  //get all tables waiters

    // reservation table management
    Route::post('/reset-old-table', [ReservationInfoController::class, 'resetOldTable']); //reset old table

    // delete it
    Route::post('/delete-it', [ReservationInfoController::class, 'deleteit']); //reset old table

});

// paypal 
Route::get('/get-payment-client-id', [paypalController::class, 'showPaypal']);
