<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ReservationNotification extends Notification
{
    use Queueable;
    public $data;

    public function __construct($message)
    {
        $this->message = $message;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject("Table booking")
            ->line('Your table is ' . $this->message . '.')
            ->line('To get the updates please visit the below link ')
            ->action('visit ', env('APP_URL'));
    }

    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}