<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PasswordReset extends Notification
{
    use Queueable;
    protected $token;


    public function __construct($token)
    {
        $this->token = $token;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject("Reset Password")
            ->line('Click the button below to reset your password.')
            ->action('Reset Password', env('APP_URL') . '/set-new-password/' . $this->token)
            ->line('Ignore this email if you haven\'t requested to reset your password.');
    }

    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}