<?php
    $setting = App\Models\Setting::first();
    $announcementModal = App\Models\AnnouncementModal::first();
    $productCategories = App\Models\Category::where(['status' => 1])->get();
    $megaMenuCategories = App\Models\MegaMenuCategory::orderBy('serial','asc')->where('status',1)->get();
    $megaMenuBanner = App\Models\BannerImage::find(1);
    $modalProducts = App\Models\Product::all();
    $currencySetting = App\Models\Setting::first();
    $menus = App\Models\MenuVisibility::select('status','id')->get();
    $customPages = App\Models\CustomPage::where('status',1)->get();
    $googleAnalytic = App\Models\GoogleAnalytic::first();
    $facebookPixel = App\Models\FacebookPixel::first();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=no, target-densityDpi=device-dpi" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap"
        rel="stylesheet">
    <?php echo $__env->yieldContent('title'); ?>
    <?php echo $__env->yieldContent('meta'); ?>

    <link rel="icon" type="image/png" href="<?php echo e(asset($setting->favicon)); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/jquery.nice-number.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/jquery.calendar.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/add_row_custon.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/mobile_menu.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/jquery.exzoom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/multiple-image-video.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/ranger_style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/jquery.classycountdown.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/venobox.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('toastr/toastr.min.css')); ?>">

    <?php if($setting->text_direction == 'rtl'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('user/css/rtl.css')); ?>">
    <?php endif; ?>

    <link rel="stylesheet" href="<?php echo e(asset('user/css/style.css')); ?>">


    <link rel="stylesheet" href="<?php echo e(asset('user/css/responsive.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('user/css/dev.css')); ?>">

    <!--jquery library js-->
    <script src="<?php echo e(asset('user/js/jquery-3.6.0.min.js')); ?>"></script>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>


    <?php if($googleAnalytic->status == 1): ?>
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($googleAnalytic->analytic_id); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', '<?php echo e($googleAnalytic->analytic_id); ?>');
    </script>
    <?php endif; ?>

    <?php if($facebookPixel->status == 1): ?>
        <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '<?php echo e($facebookPixel->app_id); ?>');
        fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id=<?php echo e($facebookPixel->app_id); ?>&ev=PageView&noscript=1"
    /></noscript>
    <?php endif; ?>

    <script>
        var end_year = '';
        var end_month = '';
        var end_date = '';
        var capmaign_time = '';
        var campaign_end_year = ''
        var campaign_end_month = ''
        var campaign_end_date = ''
        var campaign_hour = ''
        var campaign_min = ''
        var campaign_sec = ''
        var productIds = [];
        var productYears = [];
        var productMonths = [];
        var productDays = [];
    </script>

    <?php echo $__env->make('theme_style_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>

    <!--============================
        TOP BAR START
    ==============================-->
    <section id="wsus__topbar">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-sm-5 col-md-6 col-lg-6 d-none d-lg-block">
                    <ul class="wsus__topbar_left">
                        <?php if($menus->where('id',22)->first()->status == 1): ?>
                        <li><a href="callto:<?php echo e($setting->topbar_phone); ?>"><i class="fal fa-phone-square-alt"></i> <?php echo e($setting->topbar_phone); ?></a></li>
                        <?php endif; ?>
                        <li><a href="mailto:<?php echo e($setting->topbar_email); ?>"><i class="fal fa-envelope"></i> <?php echo e($setting->topbar_email); ?></a></li>
                    </ul>
                </div>
                <div class="col-xl-6 col-sm-12 col-md-8 col-lg-6">
                    <ul class="wsus__topbar_right">
                        <?php if($menus->where('id',9)->first()->status == 1): ?>
                            <li><a href="<?php echo e(route('contact-us')); ?>"><i class="fal fa-address-card"></i> <?php echo e(__('user.Contact Us')); ?></a></li>
                        <?php endif; ?>
                        <?php if($menus->where('id',17)->first()->status == 1): ?>
                            <li><a href="<?php echo e(route('user.dashboard')); ?>"><i class="fal fa-user-circle"></i> <?php echo e(__('user.My Account')); ?></a></li>
                        <?php endif; ?>
                        <?php if($menus->where('id',18)->first()->status == 1): ?>
                            <?php if(auth()->guard()->guest()): ?>
                            <li><a href="<?php echo e(route('login')); ?>"><i class="fal fa-user-alt"></i> <?php echo e(__('user.Login / Register')); ?></a></li>
                            <?php else: ?>
                            <li><a href="<?php echo e(route('user.logout')); ?>"><i class="far fa-sign-out-alt"></i> <?php echo e(__('user.Logout')); ?></a></li>
                            <?php endif; ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        TOP BAR END
    ==============================-->


    <!--============================
        HEADER START
    ==============================-->
    <header>
        <div class="container">
            <div class="row">
                <div class="col-2 d-lg-none">
                    <div class="wsus__mobile_menu_area">
                        <span class="wsus__mobile_menu_icon"><i class="fal fa-bars"></i></span>
                    </div>
                </div>
                <div class="col-xl-2 col-7 col-lg-2">
                    <div class="wsus_logo_area">
                        <a class="wsus__header_logo" href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(asset($setting->logo)); ?>" alt="logo" class="img-fluid w-100">
                        </a>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-5 d-none d-lg-block">
                    <?php if($menus->where('id',25)->first()->status == 1): ?>
                    <div class="wsus__search">
                        <form action="<?php echo e(route('product')); ?>">
                            <div class="wsus__category_search">
                                <select class="select_2" name="category">
                                    <option value=""><?php echo e(__('user.All Category')); ?></option>
                                    <?php if(request()->has('category')): ?>
                                        <?php $__currentLoopData = $productCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(request()->get('category') == $productCategory->slug ? 'selected' : ''); ?> value="<?php echo e($productCategory->slug); ?>"><?php echo e($productCategory->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <?php $__currentLoopData = $productCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($productCategory->slug); ?>"><?php echo e($productCategory->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>

                                </select>
                            </div>
                            <input type="text" placeholder="<?php echo e(__('user.Search...')); ?>" name="search" value="<?php echo e(request()->has('search') ? request()->get('search') : ''); ?>">
                            <button type="submit"><i class="far fa-search"></i></button>
                        </form>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="col-xl-4 col-3 col-lg-5">
                    <div class="wsus__call_icon_area">
                        <?php if($menus->where('id',23)->first()->status == 1): ?>
                        <div class="wsus__call_area">
                            <div class="wsus__call">
                                <i class="far fa-phone-alt"></i>
                            </div>
                            <div class="wsus__call_text">
                                <p><?php echo e(__('user.Call Us Now')); ?> :</p>
                                <a href="callto:+<?php echo e($setting->menu_phone); ?>"><?php echo e($setting->menu_phone); ?></a>
                            </div>
                        </div>
                        <?php endif; ?>
                        <ul class="wsus__icon_area">
                            <?php if($menus->where('id',21)->first()->status == 1): ?>
                            <li><a href="<?php echo e(route('user.wishlist')); ?>"><i class="far fa-heart"></i>
                                <?php if(auth()->guard()->check()): ?>
                                    <?php
                                        $user = Auth::guard('web')->user();
                                        $wishlist = App\Models\Wishlist::where('user_id',$user->id)->count();
                                    ?>
                                    <span id="wishlistQty"><?php echo e($wishlist); ?></span>
                                <?php endif; ?>

                            </a></li>
                            <?php endif; ?>
                            <?php if($menus->where('id',20)->first()->status == 1): ?>
                            <li><a href="<?php echo e(route('compare')); ?>"><i class="far fa-random"></i>
                                <span id="compareQty"><?php echo e(Cart::instance('compare')->count()); ?></span>

                            </a></li>
                            <?php endif; ?>

                            <?php if($menus->where('id',19)->first()->status == 1): ?>
                            <li><a class="wsus__cart_icon" href="javascript:;"><i
                                        class="fal fa-shopping-bag"></i><span id="cartQty"><?php echo e(Cart::instance('default')->count()); ?></span></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="wsus__mini_cart" >
            <h4><?php echo e(__('user.SHOPPING CART')); ?> <span class="wsus_close_mini_cart"><i class="far fa-times"></i></span></h4>
            <div id="load_sidebar_cart">
                <?php if(Cart::instance('default')->count() == 0): ?>
                    <h5 class="text-danger text-center"><?php echo e(('Your Cart is empty')); ?></h5>
                <?php else: ?>
                <ul >
                    <?php
                        $sidebarCartSubTotal = 0;
                        $sidebar_cart_contents = Cart::instance('default')->content();
                    ?>
                    <?php $__currentLoopData = $sidebar_cart_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sidebar_cart_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <div class="wsus__cart_img">
                            <a href="#"><img src="<?php echo e(asset($sidebar_cart_content->options->image)); ?>" alt="product" class="img-fluid w-100"></a>
                            <a class="wsis__del_icon" onclick="sidebarCartItemRemove('<?php echo e($sidebar_cart_content->rowId); ?>')" href="javascript:;"><i class="fas fa-minus-circle"></i></a>
                        </div>
                        <div class="wsus__cart_text">
                            <a class="wsus__cart_title" href="<?php echo e(route('product-detail', $sidebar_cart_content->options->slug)); ?>"><?php echo e($sidebar_cart_content->name); ?></a>
                            <p><span><?php echo e($sidebar_cart_content->qty); ?> x</span> <?php echo e($currencySetting->currency_icon); ?><?php echo e($sidebar_cart_content->price); ?></p>
                        </div>
                    </li>

                    <?php
                        $productPrice = $sidebar_cart_content->price;
                        $total = $productPrice * $sidebar_cart_content->qty ;
                        $sidebarCartSubTotal += $total;
                    ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                </ul>
                <h5><?php echo e(__('user.Sub Total')); ?> <span><?php echo e($currencySetting->currency_icon); ?><?php echo e($sidebarCartSubTotal); ?></span></h5>
                <div class="wsus__minicart_btn_area">
                    <a class="common_btn" href="<?php echo e(route('cart')); ?>"><?php echo e(__('user.View Cart')); ?></a>
                    <a class="common_btn" href="<?php echo e(route('user.checkout.billing-address')); ?>"><?php echo e(__('user.Checkout')); ?></a>
                </div>
            <?php endif; ?>
            </div>
        </div>

    </header>
    <!--============================
        HEADER END
    ==============================-->


    <!--============================
        MAIN MENU START
    ==============================-->
    <nav class="wsus__main_menu d-none d-lg-block">
        <div class="container">
            <div class="row">
                <div class="col-xl-3 col-lg-3">
                    <?php if($menus->where('id',24)->first()->status == 1): ?>
                    <div class="wsus_menu_category_bar">
                        <p> <i class="far fa-bars"></i> <?php echo e(__('user.Browse Categories')); ?> </p>
                        <span><i class="fas fa-caret-down"></i></span>
                    </div>

                    <?php endif; ?>

                    <ul class="wsus_menu_cat_item show_home toggle_menu">
                        <?php $__currentLoopData = $productCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($productCategory->subCategories->count() == 0): ?>
                                <li><a href="<?php echo e(route('product',['category' => $productCategory->slug])); ?>"><i class="<?php echo e($productCategory->icon); ?>"></i> <?php echo e($productCategory->name); ?></a></li>
                            <?php else: ?>
                                <li><a class="wsus__droap_arrow" href="<?php echo e(route('product',['category' => $productCategory->slug])); ?>"><i class="<?php echo e($productCategory->icon); ?>"></i> <?php echo e($productCategory->name); ?> </a>
                                    <ul class="wsus_menu_cat_droapdown">
                                        <?php $__currentLoopData = $productCategory->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($subCategory->childCategories->count() == 0): ?>
                                                <li><a href="<?php echo e(route('product',['sub_category' => $subCategory->slug])); ?>"><?php echo e($subCategory->name); ?></a></li>
                                            <?php else: ?>
                                                <li><a href="<?php echo e(route('product',['sub_category' => $subCategory->slug])); ?>"><?php echo e($subCategory->name); ?> <i class="fas fa-angle-right"></i></a>
                                                    <ul class="wsus__sub_category">
                                                        <?php $__currentLoopData = $subCategory->childCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li><a href="<?php echo e(route('product',['child_category' => $childCategory->slug])); ?>"><?php echo e($childCategory->name); ?></a> </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </li>
                                            <?php endif; ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>

                </div>
                <div class="col-xl-9 col-lg-9">
                    <ul class="wsus__menu_item">
                        <?php if($menus->where('id',1)->first()->status == 1): ?>
                        <li><a  href="<?php echo e(route('home')); ?>"><?php echo e(__('user.Home')); ?></a></li>
                        <?php endif; ?>

                        <?php if($menus->where('id',2)->first()->status == 1): ?>
                        <li><a href="<?php echo e(route('product')); ?>"><?php echo e(__('user.Shop')); ?>

                            <?php if($menus->where('id',3)->first()->status == 1): ?>
                             <i class="fas fa-caret-down"></i>
                            <?php endif; ?>
                            </a>
                            <?php if($menus->where('id',3)->first()->status == 1): ?>
                            <div class="wsus__mega_menu">
                                <div class="row">
                                    <?php $__currentLoopData = $megaMenuCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $megaMenuCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-xl-3 col-lg-4">
                                            <div class="wsus__mega_menu_colum">
                                                <h4><a class="text-dark" href="<?php echo e(route('product',['category' => $megaMenuCategory->category->slug])); ?>"><?php echo e($megaMenuCategory->category->name); ?></a></h4>
                                                <ul class="wsis__mega_menu_item">
                                                    <?php $__currentLoopData = $megaMenuCategory->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><a href="<?php echo e(route('product',['sub_category' => $subCategory->subCategory->slug])); ?>"><?php echo e($subCategory->subCategory->name); ?> </a></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php if($megaMenuBanner->status == 1): ?>
                                    <div class="col-xl-3 d-lg-none d-xl-block">
                                        <div class="wsus__mega_menu_colum">
                                            <img src="<?php echo e(asset($megaMenuBanner->image)); ?>" alt="images" class="img-fluid w-100">
                                            <div class="wsus__mega_menu_colum_text">
                                                <h5><?php echo e($megaMenuBanner->title); ?></h5>
                                                <h3><?php echo e($megaMenuBanner->description); ?></h3>
                                                <a class="common_btn" href="<?php echo e($megaMenuBanner->link); ?>"><?php echo e(__('user.Shop Now')); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </li>
                        <?php endif; ?>
                        <?php if($menus->where('id',4)->first()->status == 1): ?>
                            <?php if($setting->enable_multivendor == 1): ?>
                                <li><a href="<?php echo e(route('sellers')); ?>"><?php echo e(__('user.Sellers')); ?></a></li>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if($menus->where('id',5)->first()->status == 1): ?>
                        <li><a href="<?php echo e(route('blog')); ?>"><?php echo e(__('user.Blog')); ?></a></li>
                        <?php endif; ?>
                        <?php if($menus->where('id',6)->first()->status == 1): ?>
                        <li><a href="<?php echo e(route('campaign')); ?>"><?php echo e(__('user.Campaign')); ?></a></li>
                        <?php endif; ?>
                        <?php if($menus->where('id',7)->first()->status == 1): ?>
                        <li class="wsus__relative_li"><a href="javascript:;"><?php echo e(__('user.Pages')); ?> <i class="fas fa-caret-down"></i></a>
                            <ul class="wsus__menu_droapdown">
                                <?php if($menus->where('id',8)->first()->status == 1): ?>
                                <li><a href="<?php echo e(route('about-us')); ?>"><?php echo e(__('user.About Us')); ?></a></li>
                                <?php endif; ?>
                                <?php if($menus->where('id',9)->first()->status == 1): ?>
                                <li><a href="<?php echo e(route('contact-us')); ?>"><?php echo e(__('user.Contact Us')); ?></a></li>
                                <?php endif; ?>
                                <?php if($menus->where('id',10)->first()->status == 1): ?>
                                <li><a href="<?php echo e(route('user.checkout.billing-address')); ?>"><?php echo e(__('user.Check Out')); ?></a></li>
                                <?php endif; ?>
                                <?php if($menus->where('id',11)->first()->status == 1): ?>
                                <li><a href="<?php echo e(route('brand')); ?>"><?php echo e(__('user.Brand')); ?></a></li>
                                <?php endif; ?>
                                <?php if($menus->where('id',12)->first()->status == 1): ?>
                                <li><a href="<?php echo e(route('faq')); ?>"><?php echo e(__('user.FAQ')); ?></a></li>
                                <?php endif; ?>
                                <?php if($menus->where('id',13)->first()->status == 1): ?>
                                <li><a href="<?php echo e(route('privacy-policy')); ?>"><?php echo e(__('user.Privacy Policy')); ?></a></li>
                                <?php endif; ?>
                                <?php if($menus->where('id',14)->first()->status == 1): ?>
                                <li><a href="<?php echo e(route('terms-and-conditions')); ?>"><?php echo e(__('user.Terms and Conditions')); ?></a></li>
                                <?php endif; ?>

                                <?php $__currentLoopData = $customPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customPage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(route('page', $customPage->slug)); ?>"><?php echo e($customPage->page_name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </li>
                        <?php endif; ?>
                    </ul>
                    <ul class="wsus__menu_item wsus__menu_item_right ms-auto">
                        <?php if($menus->where('id',15)->first()->status == 1): ?>
                        <li><a href="<?php echo e(route('track-order')); ?>"><?php echo e(__('user.Track Order')); ?></a></li>
                        <?php endif; ?>
                        <?php if($menus->where('id',16)->first()->status == 1): ?>
                        <li><a href="<?php echo e(route('flash-deal')); ?>"><?php echo e(__('user.Flash Deal')); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <!--============================
        MAIN MENU END
    ==============================-->


    <!--============================
        MOBILE MENU START
    ==============================-->
    <section id="wsus__mobile_menu">
        <span class="wsus__mobile_menu_close"><i class="fal fa-times"></i></span>
        <ul class="wsus__mobile_menu_header_icon d-inline-flex">
            <?php if($menus->where('id',21)->first()->status == 1): ?>
            <li><a href="<?php echo e(route('user.wishlist')); ?>"><i class="far fa-heart"></i>
                <?php if(auth()->guard()->check()): ?>
                    <?php
                        $user = Auth::guard('web')->user();
                        $wishlist = App\Models\Wishlist::where('user_id',$user->id)->count();
                    ?>
                    <span id="mobileMenuwishlistQty"><?php echo e($wishlist); ?></span>
                <?php endif; ?>
            </a></li>
            <?php endif; ?>

            <?php if($menus->where('id',20)->first()->status == 1): ?>
            <li><a href="<?php echo e(route('compare')); ?>"><i class="far fa-random"></i><span id="mobileMenuCompareQty"><?php echo e(Cart::instance('compare')->count()); ?></span></a></li>
            <?php endif; ?>
        </ul>
        <?php if($menus->where('id',25)->first()->status == 1): ?>
        <form action="<?php echo e(route('product')); ?>">
            <input type="text" placeholder="<?php echo e(__('user.Search')); ?>" name="search">
            <button type="submit"><i class="far fa-search"></i></button>
        </form>
        <?php endif; ?>

        <?php
            $categoryFalse = $menus->where('id',24)->first()->status == 1 ? false : true;
        ?>
        <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
            <?php if($menus->where('id',24)->first()->status == 1): ?>
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home"
                    role="tab" aria-controls="pills-home" aria-selected="true"><?php echo e(__('user.Categories')); ?></button>
            </li>
            <?php endif; ?>
            <li class="nav-item" role="presentation">
                <button class="nav-link <?php echo e($categoryFalse ? 'active' : ''); ?>" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile"
                    role="tab" aria-controls="pills-profile" aria-selected="false"><?php echo e(__('user.Main Menu')); ?></button>
            </li>
        </ul>
        <div class="tab-content" id="pills-tabContent">
            <?php if($menus->where('id',24)->first()->status == 1): ?>
            <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                <div class="wsus__mobile_menu_main_menu">
                    <div class="accordion accordion-flush" id="accordionFlushExample">
                        <ul class="wsus_mobile_menu_category">
                            <?php $__currentLoopData = $productCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($productCategory->subCategories->count() == 0): ?>
                                <li><a href="<?php echo e(route('product',['category' => $productCategory->slug])); ?>"><i class="<?php echo e($productCategory->icon); ?>"></i> <?php echo e($productCategory->name); ?></a></li>
                                <?php else: ?>
                                    <li><a href="<?php echo e(route('product',['category' => $productCategory->slug])); ?>" class="accordion-button collapsed" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseThreew-<?php echo e($productCategory->id); ?>" aria-expanded="false"
                                        aria-controls="flush-collapseThreew-<?php echo e($productCategory->id); ?>"><i class="<?php echo e($productCategory->icon); ?>"></i> <?php echo e($productCategory->name); ?></a>
                                        <div id="flush-collapseThreew-<?php echo e($productCategory->id); ?>" class="accordion-collapse collapse"
                                            data-bs-parent="#accordionFlushExample">
                                            <div class="accordion-body">
                                                <ul>
                                                    <?php $__currentLoopData = $productCategory->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><a href="<?php echo e(route('product',['sub_category' => $subCategory->slug])); ?>"><?php echo e($subCategory->name); ?></a></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <div class="tab-pane fade  <?php echo e($categoryFalse ? 'show active' : ''); ?>" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                <div class="wsus__mobile_menu_main_menu">
                    <div class="accordion accordion-flush" id="accordionFlushExample2">
                        <ul>
                            <?php if($menus->where('id',1)->first()->status == 1): ?>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.Home')); ?></a></li>
                            <?php endif; ?>
                            <?php if($menus->where('id',2)->first()->status == 1): ?>
                                <?php if($menus->where('id',3)->first()->status == 1): ?>
                                <li><a href="<?php echo e(route('product')); ?>" class="accordion-button collapsed" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseThree" aria-expanded="false"
                                        aria-controls="flush-collapseThree"><?php echo e(__('user.Shop')); ?></a>
                                    <div id="flush-collapseThree" class="accordion-collapse collapse"
                                        data-bs-parent="#accordionFlushExample2">
                                        <div class="accordion-body">
                                            <ul>
                                                <?php $__currentLoopData = $megaMenuCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $megaMenuCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><a href="<?php echo e(route('product',['category' => $megaMenuCategory->category->slug])); ?>"><?php echo e($megaMenuCategory->category->name); ?></a></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    </div>
                                </li>
                                <?php else: ?>
                                <li><a href="<?php echo e(route('product')); ?>"><?php echo e(__('user.Shop')); ?></a></li>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if($menus->where('id',4)->first()->status == 1): ?>
                                <?php if($setting->enable_multivendor == 1): ?>
                                <li><a href="<?php echo e(route('sellers')); ?>"><?php echo e(__('user.Sellers')); ?></a></li>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if($menus->where('id',5)->first()->status == 1): ?>
                            <li><a href="<?php echo e(route('blog')); ?>"><?php echo e(__('user.Blog')); ?></a></li>
                            <?php endif; ?>
                            <?php if($menus->where('id',6)->first()->status == 1): ?>
                            <li><a href="<?php echo e(route('campaign')); ?>"><?php echo e(__('user.Campain')); ?></a></li>
                            <?php endif; ?>
                            <?php if($menus->where('id',7)->first()->status == 1): ?>
                            <li><a href="#" class="accordion-button collapsed" data-bs-toggle="collapse"
                                    data-bs-target="#flush-collapseThree101" aria-expanded="false"
                                    aria-controls="flush-collapseThree101"><?php echo e(__('user.Pages')); ?></a>
                                <div id="flush-collapseThree101" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionFlushExample2">
                                    <div class="accordion-body">
                                        <ul>
                                            <?php if($menus->where('id',8)->first()->status == 1): ?>
                                            <li><a href="<?php echo e(route('about-us')); ?>"><?php echo e(__('user.About Us')); ?></a></li>
                                            <?php endif; ?>
                                            <?php if($menus->where('id',9)->first()->status == 1): ?>
                                            <li><a href="<?php echo e(route('contact-us')); ?>"><?php echo e(__('user.Contact Us')); ?></a></li>
                                            <?php endif; ?>
                                            <?php if($menus->where('id',10)->first()->status == 1): ?>
                                            <li><a href="<?php echo e(route('user.checkout.billing-address')); ?>"><?php echo e(__('user.Check Out')); ?></a></li>
                                            <?php endif; ?>
                                            <?php if($menus->where('id',11)->first()->status == 1): ?>
                                            <li><a href="<?php echo e(route('brand')); ?>"><?php echo e(__('user.Brand')); ?></a></li>
                                            <?php endif; ?>
                                            <?php if($menus->where('id',12)->first()->status == 1): ?>
                                            <li><a href="<?php echo e(route('faq')); ?>"><?php echo e(__('user.FAQ')); ?></a></li>
                                            <?php endif; ?>
                                            <?php if($menus->where('id',13)->first()->status == 1): ?>
                                            <li><a href="<?php echo e(route('privacy-policy')); ?>"><?php echo e(__('user.Privacy Policy')); ?></a></li>
                                            <?php endif; ?>
                                            <?php if($menus->where('id',14)->first()->status == 1): ?>
                                            <li><a href="<?php echo e(route('terms-and-conditions')); ?>"><?php echo e(__('user.Terms and Conditions')); ?></a></li>
                                            <?php endif; ?>

                                            <?php $__currentLoopData = $customPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customPage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><a href="<?php echo e(route('page', $customPage->slug)); ?>"><?php echo e($customPage->page_name); ?></a></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </ul>
                                    </div>
                                </div>
                            </li>
                            <?php endif; ?>
                            <?php if($menus->where('id',15)->first()->status == 1): ?>
                            <li><a href="<?php echo e(route('track-order')); ?>"><?php echo e(__('user.Track Order')); ?></a></li>
                            <?php endif; ?>
                            <?php if($menus->where('id',16)->first()->status == 1): ?>
                            <li><a href="<?php echo e(route('flash-deal')); ?>"><?php echo e(__('user.Flash Deal')); ?></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        MOBILE MENU END
    ==============================-->


    <!--==========================
           POP UP START
    ===========================-->

    <?php if($announcementModal->status): ?>
    <section id="wsus__pop_up">
        <div class="wsus__pop_up_center" style="background-image:url(<?php echo e(asset($announcementModal->image)); ?>)">
            <div class="wsus__pop_up_text">
                <span id="cross"><i class="fas fa-times"></i></span>
                <h5><?php echo e($announcementModal->title); ?></h5>
                <p><?php echo e($announcementModal->description); ?></p>
                <form id="modalSubscribeForm">
                    <?php echo csrf_field(); ?>
                    <input type="email" name="email" placeholder="<?php echo e(__('user.Your Email')); ?>" class="news_input">
                    <button type="submit" class="common_btn" id="modalSubscribeBtn"><i id="modal-subscribe-spinner" class="loading-icon fa fa-spin fa-spinner mr-3 d-none"></i> <?php echo e(__('user.Subscribe')); ?></button>
                    <div class="wsus__pop_up_check_box"></div>
                    </div>
                </form>
                <div class="form-check">
                    <input type="hidden" id="announcement_expired_date" value="<?php echo e($announcementModal->expired_date); ?>">
                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault11">
                    <label class="form-check-label" for="flexCheckDefault11">
                        <?php echo e($announcementModal->footer_text); ?>

                    </label>
                </div>
            </div>
        </div>
    </section>

    <script>
        let isannouncementModal = sessionStorage.getItem("announcementModal");
        let expirationDate = sessionStorage.getItem("announcementModalExpiration");
        if(isannouncementModal && expirationDate){
            let today = new Date();
            today = today.toISOString().slice(0,10)
            if(today < expirationDate){
                $("#wsus__pop_up").addClass("d-none");
            }
        }
    </script>

    <?php endif; ?>
    <!--==========================
           POP UP END
    ===========================-->


    <!--==========================
      PRODUCT MODAL VIEW START
    ===========================-->
    
    <!--==========================
      PRODUCT MODAL VIEW END
    ===========================-->

    <?php echo $__env->yieldContent('public-content'); ?>

    <?php
        $setting = App\Models\Setting::first();
        $footer = App\Models\Footer::first();
        $links = App\Models\FooterSocialLink::all();
        $footerLinks = App\Models\FooterLink::all();
    ?>
    <!--============================
        SUBSCRIBE PART START
    ==============================-->
    <section id="wsus__subscribe">
        <div class="container">
            <div class="wsus__subs_form">
                <div class="row">
                    <div class="col-xl-5 col-lg-5">
                        <div class="wsus__subd_text">
                            <h4><?php echo e(__('user.Subscribe To Our Newsletter')); ?></h4>
                            <p><?php echo e(__('user.Get all the latest information on Events, Sales and Offers.')); ?></p>
                        </div>
                    </div>
                    <div class="col-xl-7 col-lg-7">
                        <div class="wsus__subs_form">
                            <form id="subscriberForm">
                                <?php echo csrf_field(); ?>
                                <input type="email" placeholder="<?php echo e(__('user.Your Email')); ?>" name="email">
                                <button type="submit" class="common_btn" id="SubscribeBtn"><i id="subscribe-spinner" class="loading-icon fa fa-spin fa-spinner mr-3 d-none"></i><?php echo e(__('user.Subscribe')); ?></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        SUBSCRIBE PART END
    ==============================-->


    <!--============================
        FOOTER PART START
    ==============================-->
    <footer>
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-xl-3 col-sm-7 col-md-6 col-lg-3">
                    <div class="wsus__footer_content">
                        <img src="<?php echo e(asset($setting->logo)); ?>" alt="logo">
                        <a class="action" href="callto:<?php echo e($footer->phone); ?>"><i class="fas fa-phone-alt"></i>
                            <?php echo e($footer->phone); ?></a>
                        <a class="action" href="mailto:<?php echo e($footer->email); ?>"><i class="far fa-envelope"></i>
                            <?php echo e($footer->email); ?></a>
                        <p><i class="fal fa-map-marker-alt"></i> <?php echo e($footer->address); ?></p>
                        <ul class="wsus__footer_social">
                            <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a class="facebook" href="<?php echo e($link->link); ?>"><i class="<?php echo e($link->icon); ?>"></i></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-2 col-sm-5 col-md-6 col-lg-2">
                    <div class="wsus__footer_content">

                        <h5><?php echo e($footer->first_column); ?></h5>
                        <ul class="wsus__footer_menu">
                            <?php $__currentLoopData = $footerLinks->where('column',1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footerLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e($footerLink->link); ?>"><i class="fas fa-caret-right"></i> <?php echo e($footerLink->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-2 col-sm-7 col-md-6 col-lg-2">
                    <div class="wsus__footer_content">
                        <h5><?php echo e($footer->second_column); ?></h5>
                        <ul class="wsus__footer_menu">
                            <?php $__currentLoopData = $footerLinks->where('column',2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footerLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e($footerLink->link); ?>"><i class="fas fa-caret-right"></i> <?php echo e($footerLink->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-2 col-sm-5 col-md-6 col-lg-3">
                    <div class="wsus__footer_content">
                        <h5><?php echo e($footer->third_column); ?></h5>
                        <ul class="wsus__footer_menu">
                            <?php $__currentLoopData = $footerLinks->where('column',3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footerLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e($footerLink->link); ?>"><i class="fas fa-caret-right"></i> <?php echo e($footerLink->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="wsus__footer_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="wsus__copyright">
                            <p><?php echo e($footer->copyright); ?></p>
                            <p><?php echo e($footer->image_title); ?> :
                                <img src="<?php echo e(asset($footer->payment_image)); ?>" alt="card" class="img-fluid">
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!--============================
        FOOTER PART END
    ==============================-->


    <!--============================
        SCROLL BUTTON START
    ==============================-->
    <div class="wsus__scroll_btn">
        <i class="fas fa-chevron-up"></i>
    </div>
    <!--============================
        SCROLL BUTTON  END
    ==============================-->

    <?php
        $isAuth = false;
        if(Auth::check()) $isAuth = true;
        $shop_page = App\Models\ShopPage::first();
        $max_val = $shop_page->filter_price_range;
        $currencySetting = App\Models\Setting::first();
        $currency_icon = $currencySetting->currency_icon;
        $tawk_setting = App\Models\TawkChat::first();
        $cookie_consent = App\Models\CookieConsent::first();
        $setting = App\Models\Setting::first();

    ?>
    <script>
        let filter_max_val = "<?php echo e($max_val); ?>";
        let currency_icon = "<?php echo e($currency_icon); ?>";
        let themeColor = "<?php echo e($setting->theme_one); ?>";
    </script>

    <?php if($tawk_setting->status == 1): ?>
    <script type="text/javascript">
        var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
        (function(){
            var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
            s1.async=true;
            s1.src='<?php echo e($tawk_setting->chat_link); ?>';
            s1.charset='UTF-8';
            s1.setAttribute('crossorigin','*');
            s0.parentNode.insertBefore(s1,s0);
        })();
    </script>

    <?php endif; ?>

    <?php if($cookie_consent->status == 1): ?>
    <script src="<?php echo e(asset('user/js/cookieconsent.min.js')); ?>"></script>

    <script>
    window.addEventListener("load",function(){window.wpcc.init({"border":"<?php echo e($cookie_consent->border); ?>","corners":"<?php echo e($cookie_consent->corners); ?>","colors":{"popup":{"background":"<?php echo e($cookie_consent->background_color); ?>","text":"<?php echo e($cookie_consent->text_color); ?> !important","border":"<?php echo e($cookie_consent->border_color); ?>"},"button":{"background":"<?php echo e($cookie_consent->btn_bg_color); ?>","text":"<?php echo e($cookie_consent->btn_text_color); ?>"}},"content":{"href":"<?php echo e(route('privacy-policy')); ?>","message":"<?php echo e($cookie_consent->message); ?>","link":"<?php echo e($cookie_consent->link_text); ?>","button":"<?php echo e($cookie_consent->btn_text); ?>"}})});
    </script>
    <?php endif; ?>

    <!--bootstrap js-->
    <script src="<?php echo e(asset('user/js/bootstrap.bundle.min.js')); ?>"></script>
    <!--font-awesome js-->
    <script src="<?php echo e(asset('user/js/Font-Awesome.js')); ?>"></script>
    <!--select2 js-->
    <script src="<?php echo e(asset('user/js/select2.min.js')); ?>"></script>
    <!--slick slider js-->
    <script src="<?php echo e(asset('user/js/slick.min.js')); ?>"></script>
    <!--simplyCountdown js-->
    <script src="<?php echo e(asset('user/js/simplyCountdown.js')); ?>"></script>
    <!--product zoomer js-->
    <script src="<?php echo e(asset('user/js/jquery.exzoom.js')); ?>"></script>
    <!--nice-number js-->
    <script src="<?php echo e(asset('user/js/jquery.nice-number.min.js')); ?>"></script>
    <!--counter js-->
    <script src="<?php echo e(asset('user/js/jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('user/js/jquery.countup.min.js')); ?>"></script>
    <!--calender js-->
    <script src="<?php echo e(asset('user/js/jquery.calendar.js')); ?>"></script>
    <!--add row js-->
    <script src="<?php echo e(asset('user/js/add_row_custon.js')); ?>"></script>
    <!--multiple-image-video js-->
    <script src="<?php echo e(asset('user/js/multiple-image-video.js')); ?>"></script>
    <!--sticky sidebar js-->
    <script src="<?php echo e(asset('user/js/sticky_sidebar.js')); ?>"></script>
    <!--price ranger js-->
    <script src="<?php echo e(asset('user/js/ranger_jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('user/js/ranger_slider.js')); ?>"></script>
    <!--isotope js-->
    <script src="<?php echo e(asset('user/js/isotope.pkgd.min.js')); ?>"></script>
    <!--venobox js-->
    <script src="<?php echo e(asset('user/js/venobox.min.js')); ?>"></script>
    <!--classycountdown js-->
    <script src="<?php echo e(asset('user/js/jquery.classycountdown.js')); ?>"></script>

    <!--main/custom js-->
    <script src="<?php echo e(asset('user/js/main.js')); ?>"></script>

    <script src="<?php echo e(asset('toastr/toastr.min.js')); ?>"></script>

    <script>
        <?php if(Session::has('messege')): ?>
        var type="<?php echo e(Session::get('alert-type','info')); ?>"
        switch(type){
            case 'info':
                toastr.info("<?php echo e(Session::get('messege')); ?>");
                break;
            case 'success':
                toastr.success("<?php echo e(Session::get('messege')); ?>");
                break;
            case 'warning':
                toastr.warning("<?php echo e(Session::get('messege')); ?>");
                break;
            case 'error':
                toastr.error("<?php echo e(Session::get('messege')); ?>");
                break;
        }
        <?php endif; ?>
    </script>

    <?php if($errors->any()): ?>
    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <script>
            toastr.error('<?php echo e($error); ?>');
        </script>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>



    <script>
        (function($) {
            "use strict";
            $(document).ready(function () {
                $(".click_first_cat").click();
                $(".click_featured_product").click();

                $("#modalSubscribeForm").on('submit', function(e){
                    e.preventDefault();

                    var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
                    if(isDemo == 0){
                        toastr.error('This Is Demo Version. You Can Not Change Anything');
                        return;
                    }

                    $("#modal-subscribe-spinner").removeClass('d-none')
                    $("#modalSubscribeBtn").addClass('after_subscribe')
                    $("#modalSubscribeBtn").attr('disabled',true);

                    $.ajax({
                        type: 'POST',
                        data: $('#modalSubscribeForm').serialize(),
                        url: "<?php echo e(route('subscribe-request')); ?>",
                        success: function (response) {
                            if(response.status == 1){
                                toastr.success(response.message);
                                $("#modal-subscribe-spinner").addClass('d-none')
                                $("#modalSubscribeBtn").removeClass('after_subscribe')
                                $("#modalSubscribeBtn").attr('disabled',false);
                                let expiredDate = $("#announcement_expired_date").val();
                                expiredDate = expiredDate*1;
                                let date = new Date();
                                date.setDate(date.getDate() + expiredDate);
                                let nextDate = date.toISOString().slice(0,10);
                                sessionStorage.setItem("announcementModal", "yes");
                                sessionStorage.setItem("announcementModalExpiration", nextDate);
                                $("#cross").click();

                            }

                            if(response.status == 0){
                                toastr.error(response.message);
                                $("#modal-subscribe-spinner").addClass('d-none')
                                $("#modalSubscribeBtn").removeClass('after_subscribe')
                                $("#modalSubscribeBtn").attr('disabled',false);
                            }
                        },
                        error: function(err) {
                            toastr.error('Something went wrong');
                            $("#modal-subscribe-spinner").addClass('d-none')
                            $("#modalSubscribeBtn").removeClass('after_subscribe')
                            $("#modalSubscribeBtn").attr('disabled',false);
                        }
                    });
                })

                $("#flexCheckDefault11").on("click", function(){
                    let expiredDate = $("#announcement_expired_date").val();
                    expiredDate = expiredDate*1;
                    let date = new Date();
                    date.setDate(date.getDate() + expiredDate);
                    let nextDate = date.toISOString().slice(0,10);
                    sessionStorage.setItem("announcementModal", "yes");
                    sessionStorage.setItem("announcementModalExpiration", nextDate);
                    $("#cross").click();
                })

                $("#subscriberForm").on('submit', function(e){
                    e.preventDefault();
                    var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
                    if(isDemo == 0){
                        toastr.error('This Is Demo Version. You Can Not Change Anything');
                        return;
                    }

                    $("#subscribe-spinner").removeClass('d-none')
                    $("#SubscribeBtn").addClass('after_subscribe')
                    $("#SubscribeBtn").attr('disabled',true);

                    $.ajax({
                        type: 'POST',
                        data: $('#subscriberForm').serialize(),
                        url: "<?php echo e(route('subscribe-request')); ?>",
                        success: function (response) {
                            if(response.status == 1){
                                toastr.success(response.message);
                                $("#subscribe-spinner").addClass('d-none')
                                $("#SubscribeBtn").removeClass('after_subscribe')
                                $("#SubscribeBtn").attr('disabled',false);
                                $("#subscriberForm").trigger("reset");
                            }

                            if(response.status == 0){
                                toastr.error(response.message);
                                $("#subscribe-spinner").addClass('d-none')
                                $("#SubscribeBtn").removeClass('after_subscribe')
                                $("#SubscribeBtn").attr('disabled',false);
                            }
                        },
                        error: function(err) {
                            toastr.error('Something went wrong');
                            $("#subscribe-spinner").addClass('d-none')
                            $("#SubscribeBtn").removeClass('after_subscribe')
                            $("#SubscribeBtn").attr('disabled',false);
                        }
                    });
                })

                $(".productModalVariant").on("change", function(){
                    let id = $(this).data("product");
                    calculateProductModalPrice(id);

                })



            });
        })(jQuery);

        function addToWishlist(id){

            var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
            if(isDemo == 0){
                toastr.error('This Is Demo Version. You Can Not Change Anything');
                return;
            }

            let isAuth = "<?php echo e($isAuth); ?>";
            if(!isAuth){
                toastr.error("<?php echo e(__('user.Please Login First')); ?>");
                return;
            }
            $.ajax({
                type: 'get',
                url: "<?php echo e(url('user/add-to-wishlist/')); ?>"+ "/" + id,
                success: function (response) {
                    if(response.status == 1){
                        toastr.success(response.message)

                        let currentQty = $("#wishlistQty").text();
                        currentQty = currentQty * 1 + 1*1;
                        $("#wishlistQty").text(currentQty);

                        let mobileMenuCurrentQty = $("#mobileMenuwishlistQty").text();
                        mobileMenuCurrentQty = mobileMenuCurrentQty *1 + 1*1;
                        $("#mobileMenuwishlistQty").text(mobileMenuCurrentQty);
                    }
                    if(response.status == 0){
                        toastr.error(response.message)
                    }
                },
                error: function(response) {
                    alert('error');
                }
            });
        }


        function calculateProductModalPrice(productId){
            $.ajax({
                type: 'get',
                data: $('#productModalFormId-'+productId).serialize(),
                url: "<?php echo e(route('calculate-product-price')); ?>",
                success: function (response) {
                    let qty = $("#productModalQty-"+productId).val();
                    let price = response.productPrice * qty;
                    price = price.toFixed(2);
                    $("#productModalPrice-"+productId).text(price);
                    $("#mainProductModalPrice-"+productId).text(price);
                },
                error: function(err) {
                    alert('error')
                }
            });

        }

        function productModalIncrement(id, current_stock){
            let qty = $("#productModalQty-"+id).val();
            if(parseInt(qty) < parseInt(current_stock)){
                qty = qty*1 + 1*1;
                $("#productModalQty-"+id).val(qty);
                calculateProductModalPrice(id)
            }

        }

        function productModalDecrement(id){
            let qty = $("#productModalQty-"+id).val();
            if(qty > 1){
                qty = qty - 1;
                $("#productModalQty-"+id).val(qty);
                calculateProductModalPrice(id)
            }

        }

        function addToCartMainProduct(productId){
            addToCartInProductModal(productId);
        }


        function addToCartInProductModal(productId){
            $.ajax({
                type: 'get',
                data: $('#productModalFormId-'+productId).serialize(),
                url: "<?php echo e(route('add-to-cart')); ?>",
                success: function (response) {
                    if(response.status == 0){
                        toastr.error(response.message)
                    }
                    if(response.status == 1){
                        toastr.success(response.message)
                        $.ajax({
                            type: 'get',
                            url: "<?php echo e(route('load-sidebar-cart')); ?>",
                            success: function (response) {
                                $("#load_sidebar_cart").html(response)
                                $.ajax({
                                    type: 'get',
                                    url: "<?php echo e(route('get-cart-qty')); ?>",
                                    success: function (response) {
                                        $("#cartQty").text(response.qty);
                                        $("#productModalView-"+productId).modal('hide');
                                    },
                                });
                            },
                        });
                    }
                },
                error: function(response) {

                }
            });
        }

        function addToBuyNow(id){
            $.ajax({
                type: 'get',
                data: $('#productModalFormId-'+id).serialize(),
                url: "<?php echo e(route('add-to-cart')); ?>",
                success: function (response) {
                    if(response.status == 0){
                        toastr.error(response.message)
                    }
                    if(response.status == 1){
                        window.location.href = "<?php echo e(route('cart')); ?>";
                        toastr.success(response.message)
                        $.ajax({
                            type: 'get',
                            url: "<?php echo e(route('load-sidebar-cart')); ?>",
                            success: function (response) {
                                $("#load_sidebar_cart").html(response)
                                $.ajax({
                                    type: 'get',
                                    url: "<?php echo e(route('get-cart-qty')); ?>",
                                    success: function (response) {
                                        $("#cartQty").text(response.qty);
                                    },
                                });
                            },
                        });
                    }
                },
                error: function(response) {

                }
            });
        }

        function sidebarCartItemRemove(id){
            $.ajax({
                type: 'get',
                url: "<?php echo e(url('sidebar-cart-item-remove')); ?>" + "/" + id,
                success: function (response) {
                    toastr.success(response.message)
                    let ifCheckoutPage = "<?php echo e(Route::is('user.checkout.payment') || Route::is('user.checkout.checkout') || Route::is('user.checkout.billing-address') ? 'yes' : 'no'); ?>";
                    if(ifCheckoutPage == 'yes'){
                        window.location.reload();
                    }
                    $.ajax({
                        type: 'get',
                        url: "<?php echo e(route('load-sidebar-cart')); ?>",
                        success: function (response) {
                            $("#load_sidebar_cart").html(response)
                            $.ajax({
                                type: 'get',
                                url: "<?php echo e(route('get-cart-qty')); ?>",
                                success: function (response) {
                                    $("#cartQty").text(response.qty);
                                },
                            });
                        },
                    });

                    $.ajax({
                        type: 'get',
                        url: "<?php echo e(route('load-main-cart')); ?>",
                        success: function (response) {
                            $("#CartResponse").html(response)
                        },
                    });
                },
            });

        }

        function addToCompare(id){
            $.ajax({
                type: 'get',
                url: "<?php echo e(url('add-to-compare')); ?>" + "/" + id,
                success: function (response) {
                    if(response.status == 1){
                        toastr.success(response.message)
                        let currentQty = $("#compareQty").text();
                        currentQty = currentQty * 1 + 1*1;
                        $("#compareQty").text(currentQty);

                        let mobileMenuCurrentQty = $("#mobileMenuCompareQty").text();
                        mobileMenuCurrentQty = mobileMenuCurrentQty *1 + 1*1;
                        $("#mobileMenuCompareQty").text(mobileMenuCurrentQty);

                    }else{
                        toastr.error(response.message)
                    }
                },
            });

        }

    </script>
</body>

</html>
<?php /**PATH /home/luckyledger/public_html/resources/views/layout.blade.php ENDPATH**/ ?>