
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Custom Page')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Create Custom Page')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.custom-page.index')); ?>"><?php echo e(__('admin.Custom Page')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Create Custom Page')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.custom-page.index')); ?>" class="btn btn-primary"><i class="fas fa-list"></i> <?php echo e(__('admin.Custom Page')); ?></a>
            <div class="row mt-4">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.custom-page.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Banner Image')); ?> <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control-file"  name="banner_image">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Page Name')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="page_name" class="form-control"  name="page_name" value="<?php echo e(old('page_name')); ?>">
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Slug')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="slug" class="form-control"  name="slug" value="<?php echo e(old('slug')); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Description')); ?> <span class="text-danger">*</span></label>
                                    <textarea name="description" cols="30" rows="10" class="summernote"><?php echo e(old('description')); ?></textarea>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Status')); ?> <span class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option value="1"><?php echo e(__('admin.Active')); ?></option>
                                        <option value="0"><?php echo e(__('admin.Inactive')); ?></option>
                                    </select>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button class="btn btn-primary"><?php echo e(__('admin.Save')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

<script>
        (function($) {
            "use strict";
            $(document).ready(function () {
                $("#page_name").on("focusout",function(e){
                    $("#slug").val(convertToSlug($(this).val()));

                })
            });
        })(jQuery);

        function convertToSlug(Text)
            {
                return Text
                    .toLowerCase()
                    .replace(/[^\w ]+/g,'')
                    .replace(/ +/g,'-');
            }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/create_custom_page.blade.php ENDPATH**/ ?>