
<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('user.Shopping Cart')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e(__('user.Shopping Cart')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($banner->image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.Shopping Cart')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="<?php echo e(route('cart')); ?>"><?php echo e(__('user.Shopping Cart')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->

    <div id="CartResponse">
    <?php if($cartContents->count() != 0): ?>
    <!--============================
          CART VIEW PAGE START
    ==============================-->
    <section id="wsus__cart_view">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="wsus__cart_tab">
                        <li><a class="wsus__order_active" href="<?php echo e(route('cart')); ?>"><?php echo e(__('user.Shopping Cart')); ?></a></li>
                        <li><a href="<?php echo e(route('user.checkout.billing-address')); ?>"><?php echo e(__('user.Checkout')); ?></a></li>
                        <li><a href="javascript:;"><?php echo e(__('user.payment')); ?></a></li>
                    </ul>
                </div>
                <div class="col-xl-12">
                    <div class="wsus__cart_list">
                        <div class="table-responsive" id="response_cart_view">
                            <form id="cartUpdateForm">
                            <table>
                                <tbody>
                                    <tr class="d-flex">
                                        <th class="wsus__pro_img">
                                            <?php echo e(__('user.Image')); ?>

                                        </th>

                                        <th class="wsus__pro_name">
                                            <?php echo e(__('user.Product details')); ?>

                                        </th>

                                        <th class="wsus__pro_status">
                                            <?php echo e(__('user.Price')); ?>

                                        </th>

                                        <th class="wsus__pro_select">
                                            <?php echo e(__('user.quantity')); ?>

                                        </th>

                                        <th class="wsus__pro_tk">
                                            <?php echo e(__('user.Sub Total')); ?>

                                        </th>

                                        <th class="wsus__pro_icon">
                                            <a href="javascript:;" id="cartClear" class="common_btn"><?php echo e(__('user.clear cart')); ?></a>
                                        </th>
                                    </tr>


                                        <?php echo csrf_field(); ?>
                                    <?php
                                        $subTotal = 0;
                                    ?>
                                    <?php $__currentLoopData = $cartContents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartContent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $variantPrice = 0;
                                        ?>
                                    <tr class="d-flex">
                                        <td class="wsus__pro_img"><img src="<?php echo e(asset($cartContent->options->image)); ?>" alt="product" class="img-fluid w-100">
                                        </td>

                                        <td class="wsus__pro_name">
                                            <p><a href="<?php echo e(route('product-detail', $cartContent->options->slug)); ?>"><?php echo e($cartContent->name); ?></a></p>
                                                <?php $__currentLoopData = $cartContent->options->variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indx => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span><?php echo e($variant); ?>: <?php echo e($cartContent->options->values[$indx]); ?>(<?php echo e($setting->currency_icon); ?><?php echo e($cartContent->options->prices[$indx]); ?>)</span>

                                                    <?php
                                                        $variantPrice += $cartContent->options->prices[$indx];
                                                    ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </td>

                                        <?php
                                            $productPrice = $cartContent->price;
                                            $total = $productPrice * $cartContent->qty ;
                                            $subTotal += $total;
                                        ?>

                                        <td class="wsus__pro_status">
                                            <p><?php echo e($setting->currency_icon); ?><?php echo e($productPrice); ?></p>
                                        </td>

                                        <td class="wsus__pro_select">
                                            <div class="modal_btn">
                                                <button onclick="shppingCartDecrement('<?php echo e($cartContent->rowId); ?>')" type="button" class="btn btn-danger btn-sm ">-</button>
                                                <input id="qty-<?php echo e($cartContent->rowId); ?>" name="quantities[]" readonly type="text" min="1" max="100" value="<?php echo e($cartContent->qty); ?>" />
                                                <button onclick="shppingCartIncrement('<?php echo e($cartContent->rowId); ?>')" type="button" class="btn btn-success btn-sm ">+</button>
                                            </div>

                                            <input type="hidden" name="rowIds[]" value="<?php echo e($cartContent->rowId); ?>">
                                            <input type="hidden" name="ids[]" value="<?php echo e($cartContent->id); ?>">
                                        </td>
                                        <td class="wsus__pro_tk">
                                            <h6><?php echo e($setting->currency_icon); ?><?php echo e($total); ?> </h6>
                                        </td>
                                        <td class="wsus__pro_icon">
                                            <a href="javascript:;" onclick="cartItemRemove('<?php echo e($cartContent->rowId); ?>')"><i class="far fa-times"></i></a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wsus__cart_list_footer mt-5 p-4">
                <div class="row justify-content-between">
                    <div class="col-xl-6 col-md-6">
                        <div class="wsus__cart_list_footer_top">
                            <h6 class="mb-4"><?php echo e(__('user.Do you have a coupon code?')); ?> </h6>
                            <form id="couponFormId">
                                <input type="text" name="coupon" placeholder="<?php echo e(__('user.Enter Your Coupon Code')); ?>">
                                <button type="submit" class="common_btn"><?php echo e(__('user.apply')); ?></button>
                            </form>
                            <a class="common_btn mt-4 text-center" href="<?php echo e(route('product')); ?>"><i class="fab fa-shopify"></i> <?php echo e(__('user.go to shop')); ?></a>
                        </div>
                    </div>
                    <?php
                        $tax_amount = 0;
                        $total_price = 0;
                        $coupon_price = 0;

                        foreach ($cartContents as $key => $content) {
                            $tax = $content->options->tax * $content->qty;
                            $tax_amount = $tax_amount + $tax;
                        }

                        $total_price = $tax_amount + $subTotal;

                        if(Session::get('coupon_price') && Session::get('offer_type')) {
                            if(Session::get('offer_type') == 1) {
                                $coupon_price = Session::get('coupon_price');
                                $coupon_price = ($coupon_price / 100) * $total_price;
                            }else {
                                $coupon_price = Session::get('coupon_price');
                            }
                        }

                        $total_price = $total_price - $coupon_price ;
                    ?>
                    <div class="col-xl-4 col-md-6">
                        <div class="wsus__cart_list_footer_button">
                            <h6><?php echo e(__('user.total cart')); ?></h6>
                            <p><?php echo e(__('user.subtotal')); ?>: <span><?php echo e($setting->currency_icon); ?><?php echo e($subTotal); ?></span></p>
                            <p><?php echo e(__('user.Tax')); ?>(+): <span><?php echo e($setting->currency_icon); ?><?php echo e($tax_amount); ?></span></p>
                            <p><?php echo e(__('user.Coupon')); ?>(-): <span><?php echo e($setting->currency_icon); ?><?php echo e($coupon_price); ?></span></p>
                            <p class="total"><span><?php echo e(__('user.total')); ?>:</span> <span><?php echo e($setting->currency_icon); ?><?php echo e($total_price); ?></span></p>
                            <a class="common_btn mt-4 w-100 text-center" href="<?php echo e(route('user.checkout.billing-address')); ?>"><?php echo e(__('user.checkout')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php
        $bannerOne = $banners->where('id',9)->first();
        $bannerTwo = $banners->where('id',10)->first();
    ?>
    <?php if($bannerOne->status == 1): ?>
    <section id="wsus__single_banner">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-6">
                    <div class="wsus__single_banner_content">
                        <div class="wsus__single_banner_img">
                            <img src="<?php echo e(asset($bannerOne->image)); ?>" alt="banner" class="img-fluid w-100">
                        </div>
                        <div class="wsus__single_banner_text">
                            <h6><?php echo e($bannerOne->description); ?></h6>
                            <h3><?php echo e($bannerOne->title); ?></h3>
                            <a class="shop_btn" href="<?php echo e($bannerOne->link); ?>"><?php echo e(__('user.shop now')); ?></a>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="wsus__single_banner_content single_banner_2">
                        <div class="wsus__single_banner_img">
                            <img src="<?php echo e(asset($bannerTwo->image)); ?>" alt="banner" class="img-fluid w-100">
                        </div>
                        <div class="wsus__single_banner_text">
                            <h6><?php echo e($bannerTwo->description); ?></h6>
                            <h3><?php echo e($bannerTwo->title); ?></h3>
                            <a class="shop_btn" href="<?php echo e($bannerTwo->link); ?>"><?php echo e(__('user.shop now')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>
    <!--============================
          CART VIEW PAGE END
    ==============================-->
    <?php else: ?>
            <!--============================
                CART VIEW PAGE START
            ==============================-->
    <section id="wsus__cart_view">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="wsus__cart_list cart_empty p-3 p-sm-5 text-center">
                        <p class="mb-4"><?php echo e(__('user.your shopping cart is empty')); ?></p>
                        <a href="<?php echo e(route('product')); ?>" class="common_btn"><i class="fal fa-store me-2"></i><?php echo e(__('user.Go to Shop')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
          CART VIEW PAGE END
    ==============================-->
    <?php endif; ?>

    </div>


<script>
    (function($) {
        "use strict";
        $(document).ready(function () {
            $(".shoppingDecrementId").on("click", function(e){
                cartItemIncrement();
            })
            $(".shoppingIncrementId").on("click", function(e){
                cartItemIncrement();
            })

            $("#cartClear").on("click", function(e){
                $.ajax({
                    type: 'get',
                    url: "<?php echo e(route('cart-clear')); ?>",
                    success: function (response) {
                        $("#CartResponse").html(response)
                        toastr.success("<?php echo e(__('user.Your shopping cart is cleared')); ?>");
                        $.ajax({
                            type: 'get',
                            url: "<?php echo e(route('load-sidebar-cart')); ?>",
                            success: function (response) {
                                $("#load_sidebar_cart").html(response)
                                $.ajax({
                                    type: 'get',
                                    url: "<?php echo e(route('get-cart-qty')); ?>",
                                    success: function (response) {
                                        $("#cartQty").text(response.qty);
                                    },
                                });
                            },
                        });
                    },
                    error: function(err) {
                        toastr.error("<?php echo e(__('user.Something went wrong')); ?>");

                    }
                });
            })

            $("#couponFormId").on("submit", function(e){
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    data: $('#couponFormId').serialize(),
                    url: "<?php echo e(route('apply-coupon')); ?>",
                    success: function (response) {
                        if(response.status == 0){
                            toastr.error(response.message);
                        }else{
                            $("#CartResponse").html(response)
                            toastr.success("<?php echo e(__('user.Your shopping cart is cleared')); ?>");
                        }

                    },
                    error: function(err) {
                        toastr.error("<?php echo e(__('user.Something went wrong')); ?>");

                    }
                });
            })


        });
    })(jQuery);

    function shppingCartDecrement(id){
        let qty = $("#qty-"+id).val();
        if(qty > 1){
            qty = qty - 1;
            $("#qty-"+id).val(qty);
            cartItemIncrement();
        }
    }

    function shppingCartIncrement(id){
        let qty = $("#qty-"+id).val();
        qty = qty*1 + 1*1;
        $("#qty-"+id).val(qty);
        cartItemIncrement();
    }

    function cartItemIncrement(){
        $.ajax({
            type: 'POST',
            data: $('#cartUpdateForm').serialize(),
            url: "<?php echo e(route('cart-update')); ?>",
            success: function (response) {
                if(response.status == 0){
                    toastr.error(response.message);
                    return ;
                }

                $("#CartResponse").html(response)
                toastr.success("<?php echo e(__('user.Item Updated Successfully')); ?>");
                $.ajax({
                    type: 'get',
                    url: "<?php echo e(route('load-sidebar-cart')); ?>",
                    success: function (response) {
                        $("#load_sidebar_cart").html(response)
                        $.ajax({
                            type: 'get',
                            url: "<?php echo e(route('get-cart-qty')); ?>",
                            success: function (response) {
                                $("#cartQty").text(response.qty);
                            },
                        });
                    },
                });
            },
            error: function(err) {
                toastr.error("<?php echo e(__('user.Something went wrong')); ?>");

            }
        });
    }


    function cartItemRemove(rowId){
        $.ajax({
            type: 'get',
            url: "<?php echo e(url('cart-item-remove')); ?>" + "/" + rowId,
            success: function (response) {
                $("#CartResponse").html(response)
                toastr.success("<?php echo e(__('user.Item Removed Successfully')); ?>");
                $.ajax({
                    type: 'get',
                    url: "<?php echo e(route('load-sidebar-cart')); ?>",
                    success: function (response) {
                        $("#load_sidebar_cart").html(response)
                        $.ajax({
                            type: 'get',
                            url: "<?php echo e(route('get-cart-qty')); ?>",
                            success: function (response) {
                                $("#cartQty").text(response.qty);
                            },
                        });
                    },
                });
            },
            error: function(err) {
                toastr.error("<?php echo e(__('user.Something went wrong')); ?>");

            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/cart.blade.php ENDPATH**/ ?>