
<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('user.Billing Address')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e(__('user.Billing Address')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($banner->image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.Billing Address')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="<?php echo e(route('user.checkout.billing-address')); ?>"><?php echo e(__('user.Billing Address')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->


    <!--============================
          CHECK OUT PAGE START
    ==============================-->
    <section id="wsus__cart_view">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="wsus__cart_tab">
                        <li><a href="<?php echo e(route('cart')); ?>"><?php echo e(__('user.Shopping Cart')); ?></a></li>
                        <li><a  class="wsus__order_active" href="<?php echo e(route('user.checkout.billing-address')); ?>"><?php echo e(__('user.Billing Address')); ?></a></li>
                        <li><a  href="javascript:;"><?php echo e(__('user.Shipping Address')); ?></a></li>
                        <li><a href="javascript:;"><?php echo e(__('user.payment')); ?></a></li>
                    </ul>
                </div>
                <form class="wsus__checkout_form" method="POST" action="<?php echo e(route('user.checkout.update-billing-address')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-xl-7 col-lg-6">
                            <div class="wsus__check_form">
                                <h5><?php echo e(__('user.Billing Address')); ?></h5>
                                <?php if($billing): ?>
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="wsus__add_address_single">
                                                <input type="text" placeholder="<?php echo e(__('user.Name')); ?>*" name="name" value="<?php echo e($billing->name); ?>">
                                            </div>
                                        </div>
                                        <div class="col-xl-12">
                                            <div class="wsus__add_address_single">
                                                <input type="email" placeholder="<?php echo e(__('user.Email')); ?>*" name="email" value="<?php echo e($billing->email); ?>">
                                            </div>
                                        </div>
                                        <div class="col-xl-12">
                                            <div class="wsus__add_address_single">
                                                <input type="text" placeholder="<?php echo e(__('user.Phone')); ?>*" name="phone" value="<?php echo e($billing->phone); ?>">
                                            </div>
                                        </div>

                                        <div class="col-xl-12">
                                            <div class="wsus__check_single_form">
                                                <select class="select_2" name="country" id="country_id">
                                                    <option value=""><?php echo e(__('user.Select Country')); ?>*</option>
                                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php echo e($country->id == $billing->country_id ? 'selected' : ''); ?> value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xl-12">
                                            <div class="wsus__check_single_form">
                                                <select class="select_2" name="state" id="state_id">
                                                    <option value="0"><?php echo e(__('user.Select State')); ?></option>
                                                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php echo e($state->id == $billing->state_id ? 'selected' : ''); ?> value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xl-12">
                                            <div class="wsus__check_single_form">
                                                <select class="select_2" name="city" id="city_id">
                                                    <option value="0"><?php echo e(__('user.Select City')); ?></option>
                                                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php echo e($city->id == $billing->city_id ? 'selected' : ''); ?> value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-xl-6">
                                            <div class="wsus__add_address_single">
                                                <input type="text" placeholder="<?php echo e(__('user.Zip Code')); ?>" name="zip_code" value="<?php echo e($billing->zip_code); ?>">
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="wsus__add_address_single">
                                                <input type="text" name="address" placeholder="<?php echo e(__('user.Address')); ?>*" value="<?php echo e($billing->address); ?>">
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <input type="checkbox" name="same_as_shipping" id="same_as_shipping"> <label for="same_as_shipping"><?php echo e(__('user.Same as Shipping Address')); ?></label>
                                        </div>

                                    </div>
                                <?php else: ?>
                                    <div class="row">
                                        <div class="col-xl-6 col-md-6">
                                            <div class="wsus__add_address_single">
                                                <input type="text" placeholder="<?php echo e(__('user.Name')); ?>*" name="name" >
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-md-6">
                                            <div class="wsus__add_address_single">
                                                <input type="email" placeholder="<?php echo e(__('user.Email')); ?>*" name="email">
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-md-6">
                                            <div class="wsus__add_address_single">
                                                <input type="text" placeholder="<?php echo e(__('user.Phone')); ?>*" name="phone">
                                            </div>
                                        </div>

                                        <div class="col-xl-6 col-md-6">
                                            <div class="wsus__check_single_form">
                                                <select class="select_2" name="country" id="country_id">
                                                    <option value=""><?php echo e(__('user.Select Country')); ?>*</option>
                                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-md-6">
                                            <div class="wsus__check_single_form">
                                                <select class="select_2" name="state" id="state_id">
                                                    <option value="0"><?php echo e(__('user.Select State')); ?></option>
                                                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-md-6">
                                            <div class="wsus__check_single_form">
                                                <select class="select_2" name="city" id="city_id">
                                                    <option value="0"><?php echo e(__('user.Select City')); ?></option>
                                                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-xl-6 col-md-6">
                                            <div class="wsus__add_address_single">
                                                <input type="text" placeholder="<?php echo e(__('user.Zip Code')); ?>" name="zip_code">
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-md-6">
                                            <div class="wsus__add_address_single">
                                                <input type="text" name="address" placeholder="<?php echo e(__('user.Address')); ?>*">
                                            </div>
                                        </div>

                                        <div class="col-xl-6">
                                            <input type="checkbox" name="same_as_shipping" id="same_as_shipping"> <label for="same_as_shipping"><?php echo e(__('user.Same as Shipping Address')); ?></label>
                                        </div>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-5 col-lg-6">
                            <div class="wsus__order_details" id="sticky_sidebar">
                                <h5><?php echo e(__('user.products')); ?></h5>
                                <ul class="wsus__order_details_item">
                                    <?php
                                        $subTotal = 0;
                                    ?>
                                    <?php $__currentLoopData = $cartContents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartContent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $variantPrice = 0;
                                        ?>
                                        <li>
                                            <div class="wsus__order_details_img">
                                                <img src="<?php echo e(asset($cartContent->options->image)); ?>" alt="blazer" class="img-fluid w-100">
                                                <span><?php echo e($cartContent->qty); ?></span>
                                            </div>
                                            <div class="wsus__order_details_text">
                                                <p><?php echo e($cartContent->name); ?></p>
                                                <span>
                                                    <?php
                                                        $totalVariant = count($cartContent->options->variants);
                                                    ?>
                                                    <?php $__currentLoopData = $cartContent->options->variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indx => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $variantPrice += $cartContent->options->prices[$indx];
                                                        ?>
                                                        <?php echo e($variant); ?>: <?php echo e($cartContent->options->values[$indx]); ?><?php echo e($totalVariant == ++$indx ? '' : ','); ?>

                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </span>
                                            </div>

                                            <?php
                                                $productPrice = $cartContent->price ;
                                                $total = $productPrice * $cartContent->qty ;
                                                $subTotal += $total;
                                            ?>
                                            <div class="wsus__order_details_tk">
                                                <p><?php echo e($setting->currency_icon); ?><?php echo e($total); ?></p>
                                            </div>
                                        </li>
                                        <?php
                                            $totalVariant = 0;
                                        ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>

                                <?php
                                    $tax_amount = 0;
                                    $total_price = 0;
                                    $coupon_price = 0;
                                    foreach ($cartContents as $key => $content) {
                                        $tax = $content->options->tax * $content->qty;
                                        $tax_amount = $tax_amount + $tax;
                                    }

                                    $total_price = $tax_amount + $subTotal;

                                    if(Session::get('coupon_price') && Session::get('offer_type')) {
                                        if(Session::get('offer_type') == 1) {
                                            $coupon_price = Session::get('coupon_price');
                                            $coupon_price = ($coupon_price / 100) * $total_price;
                                        }else {
                                            $coupon_price = Session::get('coupon_price');
                                        }
                                    }

                                    $total_price = $total_price - $coupon_price ;
                                ?>

                                <div class="wsus__order_details_summery">
                                    <p><?php echo e(__('user.subtotal')); ?>: <span><?php echo e($setting->currency_icon); ?><?php echo e($subTotal); ?></span></p>
                                    <p><?php echo e(__('user.Tax')); ?>(+): <span><?php echo e($setting->currency_icon); ?><?php echo e($tax_amount); ?></span></p>
                                    <p><?php echo e(__('user.Coupon')); ?>(-): <span><?php echo e($setting->currency_icon); ?><?php echo e($coupon_price); ?></span></p>
                                    <p class="total"><span><?php echo e(__('user.total')); ?>:</span> <span><?php echo e($setting->currency_icon); ?><?php echo e($total_price); ?></span></p>
                                </div>
                                <button type="submit" class="common_btn"><?php echo e(__('user.Continue Shopping')); ?></button>
                            </div>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </section>
    <!--============================
         CHECK OUT PAGE END
    ==============================-->


    <script>
        (function($) {
            "use strict";
            $(document).ready(function () {

                $("#country_id").on("change",function(){
                    var countryId = $("#country_id").val();
                    if(countryId){
                        $.ajax({
                            type:"get",
                            url:"<?php echo e(url('/user/state-by-country/')); ?>"+"/"+countryId,
                            success:function(response){
                                $("#state_id").html(response.states);
                                var response= "<option value=''><?php echo e(__('user.Select a City')); ?></option>";
                                $("#city_id").html(response);
                            },
                            error:function(err){
                            }
                        })
                    }else{
                        var response= "<option value=''><?php echo e(__('user.Select a State')); ?></option>";
                        $("#state_id").html(response);
                        var response= "<option value=''><?php echo e(__('user.Select a City')); ?></option>";
                        $("#city_id").html(response);
                    }

                })

                $("#state_id").on("change",function(){
                    var countryId = $("#state_id").val();
                    if(countryId){
                        $.ajax({
                            type:"get",
                            url:"<?php echo e(url('/user/city-by-state/')); ?>"+"/"+countryId,
                            success:function(response){
                                $("#city_id").html(response.cities);
                            },
                            error:function(err){
                            }
                        })
                    }else{
                        var response= "<option value=''><?php echo e(__('user.Select a City')); ?></option>";
                        $("#city_id").html(response);
                    }

                })
            });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/user/checkout_billing_address.blade.php ENDPATH**/ ?>