
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Coupon')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Coupon')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Coupon')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <a href="javascript:;" data-toggle="modal" data-target="#createCoupon" class="btn btn-primary"><i class="fas fa-plus"></i> <?php echo e(__('admin.Add New')); ?></a>
            <div class="row mt-4">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                      <div class="table-responsive table-invoice">
                        <table class="table table-striped" id="dataTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('admin.SN')); ?></th>
                                    <th><?php echo e(__('admin.Name')); ?></th>
                                    <th><?php echo e(__('admin.Code')); ?></th>
                                    <th><?php echo e(__('admin.Discount')); ?></th>
                                    <th><?php echo e(__('admin.Number of Times')); ?></th>
                                    <th><?php echo e(__('admin.Apply Qty')); ?></th>
                                    <th><?php echo e(__('admin.Expired Date')); ?></th>
                                    <th><?php echo e(__('admin.Status')); ?></th>
                                    <th><?php echo e(__('admin.Action')); ?></th>
                                  </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$index); ?></td>
                                        <td><?php echo e($coupon->name); ?></td>
                                        <td><?php echo e($coupon->code); ?></td>
                                        <td><?php echo e($coupon->offer_type == 1 ? '' : $setting->currency_icon); ?><?php echo e($coupon->discount); ?><?php echo e($coupon->offer_type == 1 ? '%' : ''); ?></td>
                                        <td><?php echo e($coupon->max_quantity); ?></td>
                                        <td><?php echo e($coupon->apply_qty); ?></td>
                                        <td><?php echo e(date('d M, Y',strtotime($coupon->expired_date))); ?></td>
                                        <td>
                                            <?php if($coupon->status == 1): ?>
                                            <a href="javascript:;" onclick="changeCouponStatus(<?php echo e($coupon->id); ?>)">
                                                <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.Inactive')); ?>" data-onstyle="success" data-offstyle="danger">
                                            </a>

                                            <?php else: ?>
                                            <a href="javascript:;" onclick="changeCouponStatus(<?php echo e($coupon->id); ?>)">
                                                <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.Inactive')); ?>" data-onstyle="success" data-offstyle="danger">
                                            </a>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                        <a href="javascript:;" data-toggle="modal" data-target="#editCoupon-<?php echo e($coupon->id); ?>" class="btn btn-primary btn-sm"><i class="fa fa-edit" aria-hidden="true"></i></a>

                                        <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="btn btn-danger btn-sm" onclick="deleteData(<?php echo e($coupon->id); ?>)"><i class="fa fa-trash" aria-hidden="true"></i></a>

                                        </td>
                                    </tr>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

      <!-- Modal -->
      <div class="modal fade" id="createCoupon" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
          <div class="modal-dialog" role="document">
              <div class="modal-content">
                      <div class="modal-header">
                              <h5 class="modal-title"><?php echo e(__('admin.Create Coupon')); ?></h5>
                                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                  </button>
                          </div>
                  <div class="modal-body">
                      <div class="container-fluid">
                        <form action="<?php echo e(route('admin.coupon.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Name')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="name" class="form-control"  name="name">
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Code')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="code" class="form-control"  name="code">
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Number of times')); ?> <span class="text-danger">*</span></label>
                                    <input type="number" id="number_of_time" class="form-control"  name="number_of_time">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Expired Date')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="expired_date" class="form-control datepicker"  name="expired_date" autocomplete="off">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Discount')); ?> <span class="text-danger">*</span></label>
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <select name="offer_type" id="" class="form-control">
                                                <option value="1"><?php echo e(__('admin.Percentage')); ?>(%)</option>
                                                <option value="2"><?php echo e(__('admin.Amount')); ?>(<?php echo e($setting->currency_icon); ?>)</option>
                                            </select>
                                        </div>
                                        <input type="text" name="discount" class="form-control" placeholder="Discount" aria-label="Discount" aria-describedby="basic-addon1">
                                    </div>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Status')); ?> <span class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option value="1"><?php echo e(__('admin.Active')); ?></option>
                                        <option  value="0"><?php echo e(__('admin.Inactive')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('admin.Save')); ?></button>
                                    <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('admin.Close')); ?></button>
                                </div>
                            </div>
                        </form>
                      </div>
                  </div>
              </div>
          </div>
      </div>

      
      <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="modal fade" id="editCoupon-<?php echo e($coupon->id); ?>" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                    <div class="modal-header">
                            <h5 class="modal-title"><?php echo e(__('admin.Edit Coupon')); ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                        </div>
                <div class="modal-body">
                    <div class="container-fluid">
                      <form action="<?php echo e(route('admin.coupon.update', $coupon->id)); ?>" method="POST">
                          <?php echo csrf_field(); ?>
                          <?php echo method_field('PUT'); ?>
                          <div class="row">
                              <div class="form-group col-12">
                                  <label><?php echo e(__('admin.Name')); ?> <span class="text-danger">*</span></label>
                                  <input type="text" id="name" class="form-control"  name="name" value="<?php echo e($coupon->name); ?>">
                              </div>
                              <div class="form-group col-12">
                                  <label><?php echo e(__('admin.Code')); ?> <span class="text-danger">*</span></label>
                                  <input type="text" id="code" class="form-control"  name="code" value="<?php echo e($coupon->code); ?>">
                              </div>
                              <div class="form-group col-12">
                                  <label><?php echo e(__('admin.Number of times')); ?> <span class="text-danger">*</span></label>
                                  <input type="number" id="number_of_time" class="form-control"  name="number_of_time" value="<?php echo e($coupon->max_quantity); ?>">
                              </div>

                              <div class="form-group col-12">
                                <label><?php echo e(__('admin.Expired Date')); ?> <span class="text-danger">*</span></label>
                                <input type="text" id="expired_date" class="form-control datepicker" value="<?php echo e($coupon->expired_date); ?>"  name="expired_date" autocomplete="off">
                            </div>

                              <div class="form-group col-12">
                                  <label><?php echo e(__('admin.Discount')); ?> <span class="text-danger">*</span></label>
                                  <div class="input-group mb-3">
                                      <div class="input-group-prepend">
                                          <select name="offer_type" id="" class="form-control">
                                              <option <?php echo e($coupon->offer_type == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Percentage')); ?>(%)</option>
                                              <option <?php echo e($coupon->offer_type == 2 ? 'selected' : ''); ?> value="2"><?php echo e(__('admin.Amount')); ?>(<?php echo e($setting->currency_icon); ?>)</option>
                                          </select>
                                      </div>
                                      <input type="text" name="discount" class="form-control" placeholder="Discount" aria-label="Discount" aria-describedby="basic-addon1" value="<?php echo e($coupon->discount); ?>">
                                  </div>
                              </div>

                              <div class="form-group col-12">
                                  <label><?php echo e(__('admin.Status')); ?> <span class="text-danger">*</span></label>
                                  <select name="status" class="form-control">
                                      <option <?php echo e($coupon->status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Active')); ?></option>
                                      <option <?php echo e($coupon->status == 0 ? 'selected' : ''); ?>  value="0"><?php echo e(__('admin.Inactive')); ?></option>
                                  </select>
                              </div>
                          </div>
                          <div class="row">
                              <div class="col-12">
                                  <button type="submit" class="btn btn-primary"><?php echo e(__('admin.Save')); ?></button>
                                  <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('admin.Close')); ?></button>
                              </div>
                          </div>
                      </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<script>
    function deleteData(id){
        $("#deleteForm").attr("action",'<?php echo e(url("admin/coupon/")); ?>'+"/"+id)
    }
    function changeCouponStatus(id){
        var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
        if(isDemo == 0){
            toastr.error('This Is Demo Version. You Can Not Change Anything');
            return;
        }
        $.ajax({
            type:"put",
            data: { _token : '<?php echo e(csrf_token()); ?>' },
            url:"<?php echo e(url('/admin/coupon-status/')); ?>"+"/"+id,
            success:function(response){
                toastr.success(response)
            },
            error:function(err){
                console.log(err);

            }
        })
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/coupon.blade.php ENDPATH**/ ?>