
<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('user.Compare')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e(__('user.Compare')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($banner->image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.Compare')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="<?php echo e(route('compare')); ?>"><?php echo e(__('user.Compare')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->

    <?php if(count($compare_contents) > 0): ?>
    <!--==========================
           COMPARE START
    ===========================-->
    <section id="wsus__compare">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="wsus__compare_list">
                        <?php
                            $qty = count($compare_contents);
                            $qty += 1;
                            $percentage = 100 / $qty;
                        ?>
                        <style>
                            @media (min-width: 1200px) and (max-width: 1399.99px){
                                .wsus__compare_list table tbody tr td {
                                    width: <?php echo e($percentage); ?>%;
                                }
                            }

                        </style>
                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr class="d-flex">
                                        <td class="wsus__compare_img">
                                         <p><?php echo e(__('user.Product details')); ?></p>
                                        </td>
                                        <?php $__currentLoopData = $compare_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compare_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td class="wsus__compare_img"><img src="<?php echo e(asset($compare_content->options->product->thumb_image)); ?>" alt="product" class="img-fluid w-100">
                                            </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </tr>
                                    <tr class="d-flex">
                                        <td class="wsus__compare_text">
                                            <p><?php echo e(__('user.Product Name')); ?></p>
                                        </td>
                                        <?php $__currentLoopData = $compare_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compare_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td class="wsus__compare_text">
                                                <p><a href="<?php echo e(route('product-detail', $compare_content->options->product->slug)); ?>"><?php echo e($compare_content->options->product->short_name); ?></a></p>
                                            </td>
                                        </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tr>
                                    <tr class="d-flex">
                                        <td class="wsus__compare_text">
                                            <p><?php echo e(__('user.Price')); ?></p>
                                        </td>
                                        <?php $__currentLoopData = $compare_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compare_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $product = App\Models\Product::where('id',$compare_content->id)->first();
                                            ?>
                                            <td class="wsus__compare_text">
                                                <?php
                                                    $variantPrice = 0;
                                                    $variants = $product->variants->where('status', 1);
                                                    if($variants->count() != 0){
                                                        foreach ($variants as $variants_key => $variant) {
                                                            if($variant->variantItems->where('status',1)->count() != 0){
                                                                $item = $variant->variantItems->where('is_default',1)->first();
                                                                if($item){
                                                                    $variantPrice += $item->price;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    $isCampaign = false;
                                                    $today = date('Y-m-d H:i:s');
                                                    $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $product->id])->first();
                                                    if($campaign){
                                                        $campaign = $campaign->campaign;
                                                        if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                            $isCampaign = true;
                                                        }
                                                        $campaignOffer = $campaign->offer;
                                                        $productPrice = $product->price;
                                                        $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                        $totalPrice = $product->price;
                                                        $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                                    }

                                                    $totalPrice = $product->price;
                                                    if($product->offer_price != null){
                                                        $offerPrice = $product->offer_price;
                                                        $offer = $totalPrice - $offerPrice;
                                                        $percentage = ($offer * 100) / $totalPrice;
                                                        $percentage = round($percentage);
                                                    }
                                                ?>

                                                <?php if($isCampaign): ?>
                                                    <p class="wsus__compare_price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?></p>
                                                <?php else: ?>
                                                    <?php if($product->offer_price == null): ?>
                                                        <p class="wsus__compare_price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                                    <?php else: ?>
                                                        <p class="wsus__compare_price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $product->offer_price + $variantPrice)); ?></p>
                                                    <?php endif; ?>
                                                <?php endif; ?>

                                            </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                    </tr>
                                    <tr class="d-flex">
                                        <td class="wsus__compare_text">
                                            <p><?php echo e(__('user.Rating')); ?></p>
                                        </td>
                                        <?php $__currentLoopData = $compare_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compare_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $product = App\Models\Product::where('id',$compare_content->id)->first();
                                                $reviewQty = $product->reviews->where('status',1)->count();
                                                $totalReview = $product->reviews->where('status',1)->sum('rating');
                                                if ($reviewQty > 0) {
                                                    $average = $totalReview / $reviewQty;

                                                    $intAverage = intval($average);

                                                    $nextValue = $intAverage + 1;
                                                    $reviewPoint = $intAverage;
                                                    $halfReview=false;
                                                    if($intAverage < $average && $average < $nextValue){
                                                        $reviewPoint= $intAverage + 0.5;
                                                        $halfReview=true;
                                                    }
                                                }

                                            ?>
                                            <?php if($reviewQty > 0): ?>
                                            <td class="wsus__compare_text">
                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                    <?php if($i <= $reviewPoint): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php elseif($i> $reviewPoint ): ?>
                                                        <?php if($halfReview==true): ?>
                                                        <i class="fas fa-star-half-alt"></i>
                                                            <?php
                                                                $halfReview=false
                                                            ?>
                                                        <?php else: ?>
                                                        <i class="fal fa-star"></i>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                                <span>(<?php echo e($reviewQty); ?>)</span>
                                            </td>

                                            <?php endif; ?>

                                            <?php if($reviewQty == 0): ?>
                                            <td class="wsus__compare_text">
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <span>(0)</span>
                                            </td>
                                            <?php endif; ?>


                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tr>
                                    <tr class="d-flex">
                                        <td class="wsus__compare_text">
                                            <p><?php echo e(__('user.Warranty')); ?></p>
                                        </td>
                                        <?php $__currentLoopData = $compare_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compare_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td class="wsus__compare_text">
                                                <span class="wsus__compare_size">
                                                    <?php if($compare_content->options->product->is_warranty == 1): ?>
                                                        <?php echo e(__('user.Available')); ?>

                                                    <?php else: ?>
                                                        <?php echo e(__('user.Not Available')); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>

                                    <tr class="d-flex">
                                        <td class="wsus__compare_text">
                                            <p><?php echo e(__('user.Product Return')); ?></p>
                                        </td>
                                        <?php $__currentLoopData = $compare_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compare_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td class="wsus__compare_text">
                                                <span class="wsus__compare_size">
                                                    <?php if($compare_content->options->product->is_return == 1): ?>
                                                        <?php echo e(__('user.Available')); ?>

                                                    <?php else: ?>
                                                        <?php echo e(__('user.Not Available')); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>


                                    <tr class="d-flex">
                                        <td class="wsus__compare_text">
                                            <p><?php echo e(__('user.Item Availability')); ?></p>
                                        </td>


                                        <?php $__currentLoopData = $compare_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compare_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td class="wsus__compare_text">
                                                <?php if($compare_content->options->product->qty > 0): ?>
                                                <span class="wsus__compare_stock"><?php echo e(__('user.In Stock')); ?></span>
                                                <?php else: ?>
                                                <span class="wsus__compare_stock_out"><?php echo e(__('user.Out Of Stock')); ?></span>
                                                <?php endif; ?>

                                            </td>
                                        </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </tr>

                                    <tr class="d-flex">
                                        <td class="wsus__compare_text">
                                            <p><?php echo e(__('user.Specifications')); ?></p>
                                        </td>
                                        <?php $__currentLoopData = $compare_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compare_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $product = App\Models\Product::where('id',$compare_content->id)->first();
                                            ?>
                                            <td class="wsus__compare_text wsus__compare_des">
                                                <?php if($product->is_specification == 1): ?>
                                                    <?php $__currentLoopData = $product->specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <p><span><?php echo e($specification->key->key); ?> : </span> <span class="det"><?php echo e($specification->specification); ?></span></p>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                <?php echo e(__('user.N/A')); ?>

                                                <?php endif; ?>

                                            </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tr>
                                    <tr class="d-flex">
                                        <td class="wsus__compare_text">
                                            <p><?php echo e(__('user.Add To Cart')); ?> </p>
                                        </td>
                                        <?php $__currentLoopData = $compare_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compare_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <td class="wsus__compare_text">
                                             <a href="<?php echo e(route('product-detail', $compare_content->options->product->slug)); ?>" class="common_btn"><?php echo e(__('user.Add to cart')); ?></a>
                                        </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tr>
                                    <tr class="d-flex">
                                        <td class="wsus__compare_text">
                                            <p><?php echo e(__('user.remove')); ?> </p>
                                        </td>
                                        <?php $__currentLoopData = $compare_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compare_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <td class="wsus__compare_text wsus__del_area">
                                            <a href="<?php echo e(route('remove-compare',$compare_content->rowId)); ?>" class="wsus__compare_del"><i class="far fa-times"></i></a>
                                        </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php else: ?>
    <section id="wsus__cart_view">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="wsus__cart_list cart_empty p-3 p-sm-5 text-center">
                        <p class="mb-4"><?php echo e(__('user.your compare list is empty')); ?></p>
                        <a href="<?php echo e(route('product')); ?>" class="common_btn"><i class="fal fa-store me-2"></i><?php echo e(__('user.Go to Shop')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>
    <!--==========================
           COMPARE END
    ===========================-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/compare.blade.php ENDPATH**/ ?>