
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Products')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Products')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Products')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.product.create')); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> <?php echo e(__('admin.Add New')); ?></a>
            <div class="row mt-4">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                      <div class="table-responsive table-invoice">
                        <table class="table table-striped" id="dataTable">
                            <thead>
                                <tr>
                                    <th width="5%"><?php echo e(__('admin.SN')); ?></th>
                                    <th width="15%"><?php echo e(__('admin.Seller')); ?></th>
                                    <th width="30%"><?php echo e(__('admin.Product')); ?></th>
                                    <th width="10%"><?php echo e(__('admin.Price')); ?></th>
                                    <th width="15%"><?php echo e(__('admin.Type')); ?></th>
                                    <th width="10%"><?php echo e(__('admin.Status')); ?></th>
                                    <th width="15%"><?php echo e(__('admin.Action')); ?></th>
                                  </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$index); ?></td>
                                        <td><a href="<?php echo e(route('admin.seller-show', $product->vendor_id)); ?>"><?php echo e($product->seller->user->name); ?></a></td>
                                        <td><a href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e($product->short_name); ?></a></td>
                                        <td><?php echo e($setting->currency_icon); ?><?php echo e($product->price); ?></td>
                                        <td>
                                            <?php if($product->is_undefine == 1): ?>
                                                <?php echo e(__('admin.Undefine Product')); ?>

                                            <?php elseif($product->new_product == 1): ?>
                                                <?php echo e(__('admin.New Arrival')); ?>

                                            <?php elseif($product->is_featured == 1): ?>
                                                <?php echo e(__('admin.Featured Product')); ?>

                                            <?php elseif($product->is_top == 1): ?>
                                                <?php echo e(__('admin.Top Product')); ?>

                                            <?php elseif($product->is_best == 1): ?>
                                                <?php echo e(__('admin.Best Product')); ?>

                                            <?php elseif($product->is_flash_deal == 1): ?>
                                                <?php echo e(__('admin.Flash Deal')); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($product->status == 1): ?>
                                            <a href="javascript:;" onclick="changeProductStatus(<?php echo e($product->id); ?>)">
                                                <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.InActive')); ?>" data-onstyle="success" data-offstyle="danger">
                                            </a>

                                            <?php else: ?>
                                            <a href="javascript:;" onclick="changeProductStatus(<?php echo e($product->id); ?>)">
                                                <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.InActive')); ?>" data-onstyle="success" data-offstyle="danger">
                                            </a>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                        <a href="<?php echo e(route('admin.product.edit',$product->id)); ?>" class="btn btn-primary btn-sm"><i class="fa fa-edit" aria-hidden="true"></i></a>

                                        <?php
                                            $existOrder = $orderProducts->where('product_id',$product->id)->count();
                                        ?>

                                        <?php if($existOrder == 0): ?>
                                            <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="btn btn-danger btn-sm" onclick="deleteData(<?php echo e($product->id); ?>)"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        <?php else: ?>
                                            <a href="javascript:;" data-toggle="modal" data-target="#canNotDeleteModal" class="btn btn-danger btn-sm" disabled><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        <?php endif; ?>

                                        <div class="dropdown d-inline">
                                            <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="dropdownMenuButton2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                              <i class="fas fa-cog"></i>
                                            </button>

                                            <div class="dropdown-menu" x-placement="top-start" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(0px, -131px, 0px);">
                                              <a class="dropdown-item has-icon" href="<?php echo e(route('admin.product-gallery',$product->id)); ?>"><i class="far fa-image"></i> <?php echo e(__('admin.Image Gallery')); ?></a>

                                              <a class="dropdown-item has-icon" href="<?php echo e(route('admin.product-highlight',$product->id)); ?>"><i class="fas fa-lightbulb"></i> <?php echo e(__('admin.Highlight')); ?></a>

                                              <a class="dropdown-item has-icon" href="<?php echo e(route('admin.product-variant',$product->id)); ?>"><i class="fas fa-cog"></i><?php echo e(__('admin.Product Variant')); ?></a>

                                            </div>
                                          </div>

                                        </td>
                                    </tr>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

      <!-- Modal -->
      <div class="modal fade" id="canNotDeleteModal" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                      <div class="modal-body">
                          <?php echo e(__('admin.You can not delete this product. Because there are one or more order has been created in this product.')); ?>

                      </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('admin.Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

<script>
    function deleteData(id){
        $("#deleteForm").attr("action",'<?php echo e(url("admin/product/")); ?>'+"/"+id)
    }
    function changeProductStatus(id){
        var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
        if(isDemo == 0){
            toastr.error('This Is Demo Version. You Can Not Change Anything');
            return;
        }
        $.ajax({
            type:"put",
            data: { _token : '<?php echo e(csrf_token()); ?>' },
            url:"<?php echo e(url('/admin/product-status/')); ?>"+"/"+id,
            success:function(response){
                toastr.success(response)
            },
            error:function(err){
                console.log(err);

            }
        })
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/seller_product.blade.php ENDPATH**/ ?>