
<?php $__env->startSection('title'); ?>
    <title><?php echo e($campaign->name); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($campaign->name); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($banner->image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.Campaign')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="<?php echo e(route('campaign')); ?>"><?php echo e(__('user.Campaign')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->


    <!--============================
        DAILY DEALS DETAILS START
    ==============================-->
    <section id="wsus__daily_deals">
        <div class="container">
            <div class="wsus__offer_details_area">

                <?php if($bannerOne->status == 1): ?>
                <div class="row">
                    <div class="col-xl-6 col-md-6">
                        <div class="wsus__offer_details_banner">
                            <img src="<?php echo e(asset($bannerOne->image)); ?>" alt="offrt img" class="img-fluid w-100">
                            <div class="wsus__offer_details_banner_text">
                                <span><?php echo e($bannerOne->title); ?></span>
                                <p><b><?php echo e($bannerOne->description); ?></b></p>
                                <a href="<?php echo e($bannerOne->link); ?>" class="shop_btn"><?php echo e(__('user.shop now')); ?></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-md-6">
                        <div class="wsus__offer_details_banner">
                            <img src="<?php echo e(asset($bannerTwo->image)); ?>" alt="offrt img" class="img-fluid w-100">
                            <div class="wsus__offer_details_banner_text">
                                <span><?php echo e($bannerTwo->title); ?></span>
                                <p><b><?php echo e($bannerTwo->description); ?></b></p>
                                <a href="<?php echo e($bannerTwo->link); ?>" class="shop_btn"><?php echo e(__('user.shop now')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>

                <?php endif; ?>

                <div class="row">
                    <div class="col-xl-12">
                        <div class="wsus__section_header rounded-0">
                            <h3><?php echo e($campaign->name); ?></h3>
                            <div class="wsus__offer_countdown">
                                <span class="end_text"><?php echo e(__('user.ends time')); ?> :</span>
                                <div class="simply-countdown campaign-details"></div>
                                <?php if(env('APP_VERSION') == 0): ?>
                                    <?php
                                        $demo_end = Carbon\Carbon::now()->addDays(3);
                                    ?>
                                    <script>
                                        var campaign_end_year = <?php echo e($demo_end->format('Y')); ?>

                                        var campaign_end_month = <?php echo e($demo_end->format('m')); ?>

                                        var campaign_end_date = <?php echo e($demo_end->format('d')); ?>

                                        var campaign_hour = <?php echo e($demo_end->format('H')); ?>

                                        var campaign_min = <?php echo e($demo_end->format('i')); ?>

                                        var campaign_sec = <?php echo e($demo_end->format('s')); ?>

                                    </script>
                                <?php else: ?>
                                    <script>
                                        var campaign_end_year = <?php echo e(date('Y', strtotime($campaign->end_date))); ?>

                                        var campaign_end_month = <?php echo e(date('m', strtotime($campaign->end_date))); ?>

                                        var campaign_end_date = <?php echo e(date('d', strtotime($campaign->end_date))); ?>

                                        var campaign_hour = <?php echo e(date('H', strtotime($campaign->end_date))); ?>

                                        var campaign_min = <?php echo e(date('i', strtotime($campaign->end_date))); ?>

                                        var campaign_sec = <?php echo e(date('s', strtotime($campaign->end_date))); ?>

                                    </script>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <?php $__currentLoopData = $campaignProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaignProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-sm-6 col-lg-3">
                            <div class="wsus__offer_det_single">
                                <div class="wsus__product_item wsus__before">
                                    <?php if($campaignProduct->product->new_product == 1): ?>
                                        <span class="wsus__new"><?php echo e(__('user.New')); ?></span>
                                    <?php elseif($campaignProduct->product->is_featured == 1): ?>
                                        <span class="wsus__new"><?php echo e(__('user.Featured')); ?></span>
                                    <?php elseif($campaignProduct->product->is_top == 1): ?>
                                        <span class="wsus__new"><?php echo e(__('user.Top')); ?></span>
                                    <?php elseif($campaignProduct->product->is_best == 1): ?>
                                        <span class="wsus__new"><?php echo e(__('user.Best')); ?></span>
                                    <?php endif; ?>

                                    <?php
                                        $variantPrice = 0;
                                        $variants = $campaignProduct->product->variants->where('status', 1);
                                        if($variants->count() != 0){
                                            foreach ($variants as $variants_key => $variant) {
                                                if($variant->variantItems->where('status',1)->count() != 0){
                                                    $item = $variant->variantItems->where('is_default',1)->first();
                                                    if($item){
                                                        $variantPrice += $item->price;
                                                    }
                                                }
                                            }
                                        }

                                        $isCampaign = false;
                                        $today = date('Y-m-d H:i:s');
                                        $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $campaignProduct->product->id])->first();
                                        if($campaign){
                                            $campaign = $campaign->campaign;
                                            if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                $isCampaign = true;
                                            }
                                            $campaignOffer = $campaign->offer;
                                            $productPrice = $campaignProduct->product->price;
                                            $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                            $totalPrice = $campaignProduct->product->price;
                                            $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                        }

                                        $totalPrice = $campaignProduct->product->price;
                                        if($campaignProduct->product->offer_price != null){
                                            $offerPrice = $campaignProduct->product->offer_price;
                                            $offer = $totalPrice - $offerPrice;
                                            $percentage = ($offer * 100) / $totalPrice;
                                            $percentage = round($percentage);
                                        }
                                    ?>
                                    <?php if($isCampaign): ?>
                                        <span class="wsus__minus">-<?php echo e($campaignOffer); ?>%</span>
                                    <?php else: ?>
                                        <?php if($campaignProduct->product->offer_price != null): ?>
                                            <span class="wsus__minus">-<?php echo e($percentage); ?>%</span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <a class="wsus__pro_link" href="<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>">
                                        <img src="<?php echo e(asset($campaignProduct->product->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_1" />
                                        <img src="<?php echo e(asset($campaignProduct->product->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_2" />
                                    </a>
                                    <ul class="wsus__single_pro_icon">
                                        <li><a data-bs-toggle="modal" data-bs-target="#productModalView-<?php echo e($campaignProduct->product->id); ?>"><i class="fal fa-eye"></i></a></li>
                                        <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($campaignProduct->product->id); ?>')"><i class="far fa-heart"></i></a></li>
                                        <li><a href="javascript:;" onclick="addToCompare('<?php echo e($campaignProduct->product->id); ?>')"><i class="far fa-random"></i></a></li>
                                    </ul>
                                    <div class="wsus__product_details">
                                        <a class="wsus__category" href="<?php echo e(route('product',['category' =>  $campaignProduct->product->category->slug])); ?>"><?php echo e($campaignProduct->product->category->name); ?> </a>

                                        <?php
                                            $reviewQty = $campaignProduct->product->reviews->where('status',1)->count();
                                            $totalReview = $campaignProduct->product->reviews->where('status',1)->sum('rating');
                                            if ($reviewQty > 0) {
                                                $average = $totalReview / $reviewQty;
                                                $intAverage = intval($average);
                                                $nextValue = $intAverage + 1;
                                                $reviewPoint = $intAverage;
                                                $halfReview=false;
                                                if($intAverage < $average && $average < $nextValue){
                                                    $reviewPoint= $intAverage + 0.5;
                                                    $halfReview=true;
                                                }
                                            }
                                        ?>

                                        <?php if($reviewQty > 0): ?>
                                        <p class="wsus__pro_rating">
                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                <?php if($i <= $reviewPoint): ?>
                                                    <i class="fas fa-star"></i>
                                                <?php elseif($i> $reviewPoint ): ?>
                                                    <?php if($halfReview==true): ?>
                                                    <i class="fas fa-star-half-alt"></i>
                                                        <?php
                                                            $halfReview=false
                                                        ?>
                                                    <?php else: ?>
                                                    <i class="fal fa-star"></i>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                        <?php endif; ?>

                                        <?php if($reviewQty == 0): ?>
                                            <p class="wsus__pro_rating">
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                            </p>
                                        <?php endif; ?>
                                        <a class="wsus__pro_name" href="<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>"><?php echo e($campaignProduct->product->short_name); ?></a>

                                        <?php if($isCampaign): ?>
                                            <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php else: ?>
                                            <?php if($campaignProduct->product->offer_price == null): ?>
                                                <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                            <?php else: ?>
                                                <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignProduct->product->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <a class="add_cart" onclick="addToCartMainProduct('<?php echo e($campaignProduct->product->id); ?>')" href="javascript:;"><?php echo e(__('user.add to cart')); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>


                <?php $__currentLoopData = $campaignProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaignProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <section class="product_popup_modal">
                        <div class="modal fade" id="productModalView-<?php echo e($campaignProduct->product->id); ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                                class="far fa-times"></i></button>
                                        <div class="row">
                                            <div class="col-xl-6 col-12 col-sm-10 col-md-8 col-lg-6 m-auto display">
                                                <div class="wsus__quick_view_img">
                                                    <?php if($campaignProduct->product->video_link): ?>
                                                        <?php
                                                            $video_id=explode("=",$campaignProduct->product->video_link);
                                                        ?>
                                                        <a class="venobox wsus__pro_det_video" data-autoplay="true" data-vbtype="video"
                                                        href="https://youtu.be/<?php echo e($video_id[1]); ?>">
                                                        <i class="fas fa-play"></i>
                                                    </a>
                                                    <?php endif; ?>

                                                    <div class="row modal_slider">
                                                        <?php $__currentLoopData = $campaignProduct->product->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-xl-12">
                                                            <div class="modal_slider_img">
                                                                <img src="<?php echo e(asset($image->image)); ?>" alt="product" class="img-fluid w-100">
                                                            </div>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-12 col-sm-12 col-md-12 col-lg-6">
                                                <div class="wsus__pro_details_text">
                                                    <a class="title" href="<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>"><?php echo e($campaignProduct->product->name); ?></a>

                                                        <?php if($campaignProduct->product->qty == 0): ?>
                                                        <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.Out of Stock')); ?></span></p>
                                                        <?php else: ?>
                                                            <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.In stock')); ?>

                                                                <?php if($setting->show_product_qty == 1): ?>
                                                                    </span> (<?php echo e($campaignProduct->product->qty); ?> <?php echo e(__('user.item')); ?>)
                                                                <?php endif; ?>
                                                            </p>
                                                        <?php endif; ?>


                                                    <?php
                                                        $reviewQty = $campaignProduct->product->reviews->where('status',1)->count();
                                                        $totalReview = $campaignProduct->product->reviews->where('status',1)->sum('rating');

                                                        if ($reviewQty > 0) {
                                                            $average = $totalReview / $reviewQty;

                                                            $intAverage = intval($average);

                                                            $nextValue = $intAverage + 1;
                                                            $reviewPoint = $intAverage;
                                                            $halfReview=false;
                                                            if($intAverage < $average && $average < $nextValue){
                                                                $reviewPoint= $intAverage + 0.5;
                                                                $halfReview=true;
                                                            }
                                                        }
                                                    ?>

                                                    <?php
                                                        $variantPrice = 0;
                                                        $variants = $campaignProduct->product->variants->where('status', 1);
                                                        if($variants->count() != 0){
                                                            foreach ($variants as $variants_key => $variant) {
                                                                if($variant->variantItems->where('status',1)->count() != 0){
                                                                    $item = $variant->variantItems->where('is_default',1)->first();
                                                                    if($item){
                                                                        $variantPrice += $item->price;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        $isCampaign = false;
                                                        $today = date('Y-m-d H:i:s');
                                                        $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $campaignProduct->product->id])->first();
                                                        if($campaign){
                                                            $campaign = $campaign->campaign;
                                                            if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                                $isCampaign = true;
                                                            }
                                                            $campaignOffer = $campaign->offer;
                                                            $productPrice = $campaignProduct->product->price;
                                                            $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                            $totalPrice = $campaignProduct->product->price;
                                                            $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                                        }

                                                        $totalPrice = $campaignProduct->product->price;
                                                        if($campaignProduct->product->offer_price != null){
                                                            $offerPrice = $campaignProduct->product->offer_price;
                                                            $offer = $totalPrice - $offerPrice;
                                                            $percentage = ($offer * 100) / $totalPrice;
                                                            $percentage = round($percentage);
                                                        }


                                                    ?>

                                                    <?php if($isCampaign): ?>
                                                        <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductModalPrice-<?php echo e($campaignProduct->product->id); ?>"><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?></span>  <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                    <?php else: ?>
                                                        <?php if($campaignProduct->product->offer_price == null): ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($campaignProduct->product->id); ?>"><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></span></h4>
                                                        <?php else: ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($campaignProduct->product->id); ?>"><?php echo e(sprintf("%.2f", $campaignProduct->product->offer_price + $variantPrice)); ?></span> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty > 0): ?>
                                                        <p class="review">
                                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                                <?php if($i <= $reviewPoint): ?>
                                                                    <i class="fas fa-star"></i>
                                                                <?php elseif($i> $reviewPoint ): ?>
                                                                    <?php if($halfReview==true): ?>
                                                                    <i class="fas fa-star-half-alt"></i>
                                                                        <?php
                                                                            $halfReview=false
                                                                        ?>
                                                                    <?php else: ?>
                                                                    <i class="fal fa-star"></i>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php endfor; ?>
                                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty == 0): ?>
                                                        <p class="review">
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php
                                                        $productPrice = 0;
                                                        if($isCampaign){
                                                            $productPrice = $campaignOfferPrice + $variantPrice;
                                                        }else{
                                                            if ($campaignProduct->product->offer_price == null) {
                                                                $productPrice = $totalPrice + $variantPrice;
                                                            }else {
                                                                $productPrice = $campaignProduct->product->offer_price + $variantPrice;
                                                            }
                                                        }
                                                    ?>
                                                    <form id="productModalFormId-<?php echo e($campaignProduct->product->id); ?>">
                                                    <div class="wsus__quentity">
                                                        <h5><?php echo e(__('user.quantity')); ?> :</h5>
                                                        <div class="modal_btn">
                                                            <button onclick="productModalDecrement('<?php echo e($campaignProduct->product->id); ?>')" type="button" class="btn btn-danger btn-sm">-</button>
                                                            <input id="productModalQty-<?php echo e($campaignProduct->product->id); ?>" name="quantity"  readonly class="form-control" type="text" min="1" max="100" value="1" />
                                                            <button onclick="productModalIncrement('<?php echo e($campaignProduct->product->id); ?>', <?php echo e($campaignProduct->product->qty); ?>)" type="button" class="btn btn-success btn-sm">+</button>
                                                        </div>
                                                        <h3 class="d-none"><?php echo e($currencySetting->currency_icon); ?><span id="productModalPrice-<?php echo e($campaignProduct->product->id); ?>"><?php echo e(sprintf("%.2f",$productPrice)); ?></span></h3>

                                                        <input type="hidden" name="product_id" value="<?php echo e($campaignProduct->product->id); ?>">
                                                        <input type="hidden" name="image" value="<?php echo e($campaignProduct->product->thumb_image); ?>">
                                                        <input type="hidden" name="slug" value="<?php echo e($campaignProduct->product->slug); ?>">

                                                    </div>
                                                    <?php
                                                        $productVariants = App\Models\ProductVariant::where(['status' => 1, 'product_id'=> $campaignProduct->product->id])->get();
                                                    ?>
                                                    <?php if($productVariants->count() != 0): ?>
                                                        <div class="wsus__selectbox">
                                                            <div class="row">
                                                                <?php $__currentLoopData = $productVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productVariant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $items = App\Models\ProductVariantItem::orderBy('is_default','desc')->where(['product_variant_id' => $productVariant->id, 'product_id' => $campaignProduct->product->id])->get();
                                                                    ?>
                                                                    <?php if($items->count() != 0): ?>
                                                                        <div class="col-xl-6 col-sm-6 mb-3">
                                                                            <h5 class="mb-2"><?php echo e($productVariant->name); ?>:</h5>

                                                                            <input type="hidden" name="variants[]" value="<?php echo e($productVariant->id); ?>">
                                                                            <input type="hidden" name="variantNames[]" value="<?php echo e($productVariant->name); ?>">

                                                                            <select class="select_2 productModalVariant" name="items[]" data-product="<?php echo e($campaignProduct->product->id); ?>">
                                                                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <ul class="wsus__button_area">
                                                        <li><button type="button" onclick="addToCartInProductModal('<?php echo e($campaignProduct->product->id); ?>')" class="add_cart"><?php echo e(__('user.add to cart')); ?></button></li>
                                                        <li><a class="buy_now" href="javascript:;" onclick="addToBuyNow('<?php echo e($campaignProduct->product->id); ?>')"><?php echo e(__('user.buy now')); ?></a></li>
                                                        <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($campaignProduct->product->id); ?>')"><i class="fal fa-heart"></i></a></li>
                                                        <li><a href="javascript:;" onclick="addToCompare('<?php echo e($campaignProduct->product->id); ?>')"><i class="far fa-random"></i></a></li>
                                                    </ul>
                                                </form>
                                                <?php if($campaignProduct->product->sku): ?>
                                                <p class="brand_model"><span><?php echo e(__('user.Model')); ?> :</span> <?php echo e($campaignProduct->product->sku); ?></p>
                                                <?php endif; ?>

                                                <p class="brand_model"><span><?php echo e(__('user.Brand')); ?> :</span> <a href="<?php echo e(route('product',['brand' => $campaignProduct->product->brand->slug])); ?>"><?php echo e($campaignProduct->product->brand->name); ?></a></p>
                                                <p class="brand_model"><span><?php echo e(__('user.Category')); ?> :</span> <a href="<?php echo e(route('product',['category' => $campaignProduct->product->category->slug])); ?>"><?php echo e($campaignProduct->product->category->name); ?></a></p>
                                                <div class="wsus__pro_det_share d-none">
                                                    <h5><?php echo e(__('user.share')); ?> :</h5>
                                                    <ul class="d-flex">
                                                        <li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>&t=<?php echo e($campaignProduct->product->name); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                                        <li><a class="twitter" href="https://twitter.com/share?text=<?php echo e($campaignProduct->product->name); ?>&url=<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>"><i class="fab fa-twitter"></i></a></li>
                                                        <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>&title=<?php echo e($campaignProduct->product->name); ?>"><i class="fab fa-linkedin"></i></a></li>
                                                        <li><a class="pinterest" href="https://www.pinterest.com/pin/create/button/?description=<?php echo e($campaignProduct->product->name); ?>&media=&url=<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>"><i class="fab fa-pinterest-p"></i></a></li>
                                                    </ul>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!--============================
        DAILY DEALS DETAILS END
    ==============================-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/campaign_detail.blade.php ENDPATH**/ ?>