
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Menu visibility')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Menu visibility')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Menu visibility')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <div class="row mt-4">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <th><?php echo e(__('admin.Menu')); ?></th>
                                <th><?php echo e(__('admin.Visibility')); ?></th>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td width="50%"><?php echo e($menu->menu_name); ?></td>
                                        <td width="50%">
                                            <?php if($menu->status): ?>
                                                <a href="javascript:;" onclick="changeMenuVisibility(<?php echo e($menu->id); ?>)">
                                                    <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.InActive')); ?>" data-onstyle="success" data-offstyle="danger">
                                                </a>
                                            <?php else: ?>
                                                <a href="javascript:;" onclick="changeMenuVisibility(<?php echo e($menu->id); ?>)">
                                                    <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.InActive')); ?>" data-onstyle="success" data-offstyle="danger">
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

      <script>
          function changeMenuVisibility(id){
            var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
            if(isDemo == 0){
                toastr.error('This Is Demo Version. You Can Not Change Anything');
                return;
            }
            $.ajax({
                type:"put",
                data: { _token : '<?php echo e(csrf_token()); ?>' },
                url:"<?php echo e(url('/admin/update-menu-visibility/')); ?>"+"/"+id,
                success:function(response){
                   toastr.success(response)
                },
                error:function(err){

                }
            })
          }
      </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/menu_visibility.blade.php ENDPATH**/ ?>