
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Privacy Policy')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Privacy Policy')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Privacy Policy')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <div class="row mt-4">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                        <?php if($isPrivacyPolicy): ?>
                            <form action="<?php echo e(route('admin.privacy-policy.update',$privacyPolicy->id)); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="row">
                                    <div class="form-group col-12">
                                        <label><?php echo e(__('admin.Banner Preview')); ?></label>
                                        <div>
                                            <img class="admin-banner-img" id="preview-img" src="<?php echo e($privacyPolicy->privacy_banner ? asset($privacyPolicy->privacy_banner) : asset('uploads/website-images/preview.png')); ?>" width="200px" alt="">
                                        </div>

                                    </div>

                                    <div class="form-group col-12">
                                        <label><?php echo e(__('admin.New Banner')); ?></label>
                                        <input type="file" name="banner_image" class="form-control-file" onchange="previewThumnailImage(event)">
                                    </div>

                                    <div class="form-group col-12">
                                        <label><?php echo e(__('admin.Privacy Policy')); ?><span class="text-danger">*</span></label>
                                        <textarea name="privacy_policy" cols="30" rows="10" class="summernote"><?php echo e($privacyPolicy->privacy_policy); ?></textarea>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                    </div>
                                </div>
                            </form>
                        <?php else: ?>
                            <form action="<?php echo e(route('admin.privacy-policy.store')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="form-group col-12">
                                        <label><?php echo e(__('admin.Banner Preview')); ?></label>
                                        <div>
                                            <img class="admin-banner-img" id="preview-img" src="<?php echo e(asset('uploads/website-images/preview.png')); ?>" width="200px" alt="">
                                        </div>

                                    </div>

                                    <div class="form-group col-12">
                                        <label><?php echo e(__('admin.Banner Image')); ?></label>
                                        <input type="file" name="banner_image" class="form-control-file" onchange="previewThumnailImage(event)">
                                    </div>

                                    <div class="form-group col-12">
                                        <label><?php echo e(__('admin.Privacy Policy')); ?><span class="text-danger">*</span></label>
                                        <textarea name="privacy_policy" cols="30" rows="10" class="summernote"></textarea>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <button class="btn btn-primary"><?php echo e(__('admin.Save')); ?></button>
                                    </div>
                                </div>
                            </form>
                        <?php endif; ?>

                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>


<script>
    function previewThumnailImage(event) {
        var reader = new FileReader();
        reader.onload = function(){
            var output = document.getElementById('preview-img');
            output.src = reader.result;
        }
        reader.readAsDataURL(event.target.files[0]);
    };
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/privacy_policy.blade.php ENDPATH**/ ?>