
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Invoice')); ?></title>
<?php $__env->stopSection(); ?>
<style>
    @media  print {
        .section-header,
        .order-status,
        #sidebar-wrapper,
        .print-area,
        .main-footer,
        .additional_info {
            display:none!important;
        }

    }
</style>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Invoice')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Invoice')); ?></div>
            </div>
          </div>
          <div class="section-body">
            <div class="invoice">
              <div class="invoice-print">
                <div class="row">
                  <div class="col-lg-12">
                    <div class="invoice-title">
                      <h2><img src="<?php echo e(asset($setting->logo)); ?>" alt="" width="120px"></h2>
                      <div class="invoice-number">Order #<?php echo e($order->order_id); ?></div>
                    </div>
                    <hr>
                    <?php
                        $orderAddress = $order->orderAddress;
                    ?>
                    <div class="row">
                      <div class="col-md-6">
                        <address>
                          <strong><?php echo e(__('admin.Billing Information')); ?>:</strong><br>
                            <?php echo e($orderAddress->billing_name); ?><br>
                            <?php if($orderAddress->billing_email): ?>
                            <?php echo e($orderAddress->billing_email); ?><br>
                            <?php endif; ?>
                            <?php if($orderAddress->billing_phone): ?>
                            <?php echo e($orderAddress->billing_phone); ?><br>
                            <?php endif; ?>
                            <?php echo e($orderAddress->billing_address); ?>,
                            <?php echo e($orderAddress->billing_city.', '. $orderAddress->billing_state.', '.$orderAddress->billing_country); ?><br>
                        </address>
                      </div>
                      <div class="col-md-6 text-md-right">
                        <address>
                          <strong><?php echo e(__('admin.Shipping Information')); ?> :</strong><br>
                          <?php echo e($orderAddress->shipping_name); ?><br>
                            <?php if($orderAddress->shipping_email): ?>
                            <?php echo e($orderAddress->shipping_email); ?><br>
                            <?php endif; ?>
                            <?php if($orderAddress->shipping_phone): ?>
                            <?php echo e($orderAddress->shipping_phone); ?><br>
                            <?php endif; ?>
                            <?php echo e($orderAddress->shipping_address); ?>,
                            <?php echo e($orderAddress->shipping_city.', '. $orderAddress->shipping_state.', '.$orderAddress->shipping_country); ?><br>
                        </address>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-6">
                        <address>
                          <strong><?php echo e(__('admin.Payment Information')); ?>:</strong><br>
                          <?php echo e(__('admin.Method')); ?>: <?php echo e($order->payment_method); ?><br>
                          <?php echo e(__('admin.Status')); ?> : <?php if($order->payment_status == 1): ?>
                              <span class="badge badge-success"><?php echo e(__('admin.Success')); ?></span>
                              <?php else: ?>
                              <span class="badge badge-danger"><?php echo e(__('admin.Pending')); ?></span>
                          <?php endif; ?> <br>
                          <?php echo e(__('admin.Transaction')); ?>: <?php echo clean(nl2br($order->transection_id)); ?>

                        </address>
                      </div>
                      <div class="col-md-6 text-md-right">
                        <address>
                          <strong><?php echo e(__('admin.Order Information')); ?>:</strong><br>
                          <?php if($order->agree_terms_condition == 'yes'): ?>
                          <?php echo e(__('admin.Agree with Terms & Conditions')); ?>: <span class="badge badge-success"><?php echo e(__('admin.Yes')); ?> </span><br>
                          <?php else: ?>
                          <?php echo e(__('admin.Agree with Terms & Conditions')); ?>: <span class="badge badge-danger"><?php echo e(__('admin.No')); ?> </span><br>
                          <?php endif; ?>
                          <?php echo e(__('admin.Date')); ?>: <?php echo e($order->created_at->format('d F, Y')); ?><br>
                          <?php echo e(__('admin.Shipping')); ?>: <?php echo e($order->shipping_method); ?><br>
                          <?php echo e(__('admin.Status')); ?> :
                          <?php if($order->order_status == 1): ?>
                          <span class="badge badge-success"><?php echo e(__('admin.Pregress')); ?> </span>
                          <?php elseif($order->order_status == 2): ?>
                          <span class="badge badge-success"><?php echo e(__('admin.Delivered')); ?> </span>
                          <?php elseif($order->order_status == 3): ?>
                          <span class="badge badge-success"><?php echo e(__('admin.Completed')); ?> </span>
                          <?php elseif($order->order_status == 4): ?>
                          <span class="badge badge-danger"><?php echo e(__('admin.Declined')); ?> </span>
                          <?php else: ?>
                          <span class="badge badge-danger"><?php echo e(__('admin.Pending')); ?></span>
                        <?php endif; ?>
                        </address>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row mt-4">
                  <div class="col-md-12">
                    <div class="section-title"><?php echo e(__('admin.Order Summary')); ?></div>
                    <div class="table-responsive">
                      <table class="table table-striped table-hover table-md">
                        <tr>
                          <th width="5%">#</th>
                          <th width="25%"><?php echo e(__('admin.Product')); ?></th>
                          <th width="20%"><?php echo e(__('admin.Variant')); ?></th>
                          <?php if($setting->enable_multivendor == 1): ?>
                          <th width="10%"><?php echo e(__('admin.Shop Name')); ?></th>
                          <?php endif; ?>
                          <th width="10%" class="text-center"><?php echo e(__('admin.Unit Price')); ?></th>
                          <th width="10%" class="text-center"><?php echo e(__('admin.Quantity')); ?></th>
                          <th width="10%" class="text-right"><?php echo e(__('admin.Total')); ?></th>
                        </tr>
                        <?php
                            $subTotal = 0;
                        ?>
                        <?php $__currentLoopData = $order->orderProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $orderProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $variantPrice = 0;
                                $totalVariant = $orderProduct->orderProductVariants->count();
                            ?>
                            <tr>
                                <td><?php echo e(++$index); ?></td>
                                <td><a href=""><?php echo e($orderProduct->product_name); ?></a></td>
                                <td>
                                    <?php $__currentLoopData = $orderProduct->orderProductVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indx => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($variant->variant_name.' : '.$variant->variant_value); ?><?php echo e($totalVariant == ++$indx ? '' : ','); ?>

                                        <br>
                                        <?php
                                            $variantPrice += $variant->variant_price;
                                        ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </td>
                                <?php if($setting->enable_multivendor == 1): ?>
                                <td>
                                    <?php if($orderProduct->seller): ?>
                                        <a href="<?php echo e(route('admin.seller-show',$orderProduct->seller->id)); ?>"><?php echo e($orderProduct->seller->shop_name); ?></a>
                                    <?php endif; ?>
                                </td>
                                <?php endif; ?>
                                <td class="text-center"><?php echo e($setting->currency_icon); ?><?php echo e($orderProduct->unit_price); ?></td>
                                <td class="text-center"><?php echo e($orderProduct->qty); ?></td>
                                <?php
                                    $total = ($orderProduct->unit_price * $orderProduct->qty)
                                ?>
                                <td class="text-right"><?php echo e($setting->currency_icon); ?><?php echo e($total); ?></td>
                            </tr>
                            <?php
                                $totalVariant = 0;
                            ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </table>
                    </div>
                    <?php if($order->additional_info): ?>
                    <div class="row additional_info">
                        <div class="col">
                            <hr>
                            <h5><?php echo e(__('admin.Additional Information')); ?>: </h5>
                            <p><?php echo clean(nl2br($order->additional_info)); ?></p>
                            <hr>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="row mt-3">
                      <div class="col-lg-6 order-status">
                        <div class="section-title"><?php echo e(__('admin.Order Status')); ?></div>

                        <form action="<?php echo e(route('admin.update-order-status',$order->id)); ?>" method="POST">
                          <?php echo csrf_field(); ?>
                          <?php echo method_field("PUT"); ?>
                          <div class="form-group">
                              <label for=""><?php echo e(__('admin.Payment')); ?></label>
                            <select name="payment_status" id="" class="form-control">
                                <option <?php echo e($order->payment_status == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.Pending')); ?></option>
                                <option <?php echo e($order->payment_status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Success')); ?></option>
                            </select>
                          </div>

                          <div class="form-group">
                            <label for=""><?php echo e(__('admin.Order')); ?></label>
                            <select name="order_status" id="" class="form-control">
                              <option <?php echo e($order->order_status == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.Pending')); ?></option>
                              <option <?php echo e($order->order_status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.In Progress')); ?></option>
                              <option <?php echo e($order->order_status == 2 ? 'selected' : ''); ?>  value="2"><?php echo e(__('admin.Delivered')); ?></option>
                              <option <?php echo e($order->order_status == 3 ? 'selected' : ''); ?> value="3"><?php echo e(__('admin.Completed')); ?></option>
                              <option <?php echo e($order->order_status == 4 ? 'selected' : ''); ?> value="4"><?php echo e(__('admin.Declined')); ?></option>
                            </select>
                          </div>

                          <button class="btn btn-primary" type="submit"><?php echo e(__('admin.Update Status')); ?></button>
                        </form>
                      </div>

                      <div class="col-lg-6 text-right">
                        <div class="invoice-detail-item">
                          <div class="invoice-detail-name"><?php echo e(__('admin.Subtotal')); ?> : <?php echo e($setting->currency_icon); ?><?php echo e($order->sub_total); ?></div>
                        </div>
                        <div class="invoice-detail-item">
                          <div class="invoice-detail-name"><?php echo e(__('admin.Discount')); ?>(-) : <?php echo e($setting->currency_icon); ?><?php echo e($order->coupon_coast); ?></div>
                        </div>
                        <div class="invoice-detail-item">
                          <div class="invoice-detail-name"><?php echo e(__('admin.Shipping')); ?> : <?php echo e($setting->currency_icon); ?><?php echo e($order->shipping_cost); ?></div>
                        </div>
                        <div class="invoice-detail-item">
                          <div class="invoice-detail-name"><?php echo e(__('admin.Tax')); ?> : <?php echo e($setting->currency_icon); ?><?php echo e($order->order_vat); ?></div>
                        </div>

                        <hr class="mt-2 mb-2">
                        <div class="invoice-detail-item">
                          <div class="invoice-detail-value invoice-detail-value-lg"><?php echo e(__('admin.Total')); ?> : <?php echo e($setting->currency_icon); ?><?php echo e($order->amount_real_currency); ?></div>
                        </div>
                      </div>

                    </div>
                  </div>
                </div>
              </div>

              <div class="text-md-right print-area">
                <hr>
                <button class="btn btn-success btn-icon icon-left" onclick="window.print()"><i class="fas fa-print"></i> <?php echo e(__('admin.Print')); ?></button>
                <button class="btn btn-danger btn-icon icon-left" data-toggle="modal" data-target="#deleteModal" onclick="deleteData(<?php echo e($order->id); ?>)"><i class="fas fa-times"></i> <?php echo e(__('admin.Delete')); ?></button>
              </div>
            </div>
          </div>

        </section>
      </div>
      <script>
        function deleteData(id){
            $("#deleteForm").attr("action",'<?php echo e(url("admin/delete-order/")); ?>'+"/"+id)
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/show_order.blade.php ENDPATH**/ ?>