
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Product Review')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Product Review')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.product.index')); ?>"><?php echo e(__('admin.Product')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Product Review')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.product-review')); ?>" class="btn btn-primary"><i class="fas fa-list"></i> <?php echo e(__('admin.Product Review')); ?></a>
            <div class="row mt-4">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                      <div class="table-responsive table-invoice">
                        <table class="table table-striped table-bordered">
                           <tr>
                               <td><?php echo e(__('admin.User Name')); ?></td>
                               <td><?php echo e($review->user->name); ?></td>
                           </tr>
                           <tr>
                               <td><?php echo e(__('admin.User Email')); ?></td>
                               <td><?php echo e($review->user->email); ?></td>
                           </tr>
                           <tr>
                               <td><?php echo e(__('admin.Product')); ?></td>
                               <td><a href="<?php echo e(route('admin.product.edit', $review->product->id)); ?>"><?php echo e($review->product->name); ?></a></td>
                           </tr>
                           <tr>
                               <td><?php echo e(__('admin.Rating')); ?></td>
                               <td><?php echo e($review->rating); ?></td>
                           </tr>
                           <tr>
                               <td><?php echo e(__('admin.Review')); ?></td>
                               <td><?php echo e($review->review); ?></td>
                           </tr>

                           <tr>
                               <td><?php echo e(__('admin.Status')); ?></td>
                               <td>
                                <?php if($review->status == 1): ?>
                                    <a href="javascript:;" onclick="manageReviewStatus(<?php echo e($review->id); ?>)">
                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.InActive')); ?>" data-onstyle="success" data-offstyle="danger">
                                    </a>
                                <?php else: ?>
                                    <a href="javascript:;" onclick="manageReviewStatus(<?php echo e($review->id); ?>)">
                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.InActive')); ?>" data-onstyle="success" data-offstyle="danger">
                                    </a>
                                <?php endif; ?>
                               </td>
                           </tr>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

<script>
    function manageReviewStatus(id){
            $.ajax({
                type:"put",
                data: { _token : '<?php echo e(csrf_token()); ?>' },
                url:"<?php echo e(url('/admin/product-review-status/')); ?>"+"/"+id,
                success:function(response){
                    toastr.success(response)
                },
                error:function(err){
                    console.log(err);

                }
            })
        }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/show_product_review.blade.php ENDPATH**/ ?>