
<?php $__env->startSection('title'); ?>
    <title><?php echo e($blog->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($blog->seo_description); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($blog->banner_image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.Blog')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="<?php echo e(route('blog')); ?>"><?php echo e(__('user.Blog')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->


    <!--============================
        BLOGS DETAILS START
    ==============================-->
    <section id="wsus__blog_details">
        <div class="container">
            <div class="row">
                <div class="col-xxl-9 col-xl-8 col-lg-8">
                    <div class="wsus__main_blog">
                        <div class="wsus__main_blog_img">
                            <img src="<?php echo e(asset($blog->image)); ?>" alt="blog" class="img-fluid w-100">
                        </div>
                        <p class="wsus__main_blog_header">
                            <span><i class="fas fa-user-tie"></i> by <?php echo e($blog->admin->name); ?></span>
                            <span><i class="fal fa-calendar-alt"></i> <?php echo e($blog->created_at->format('d F, Y')); ?></span>
                            <span><i class="fal fa-comment-alt-smile"></i> <?php echo e($blog->comments->where('status',1)->count()); ?> <?php echo e(__('user.Comment')); ?></span>
                            <span><i class="far fa-eye"></i> <?php echo e($blog->views); ?> <?php echo e(__('user.Views')); ?></span>
                        </p>
                        <h2><?php echo e($blog->title); ?></h2>
                        <?php echo clean($blog->description); ?>



                        <div class="wsus__share_blog">
                            <p><?php echo e(__('user.share')); ?>:</p>
                            <ul>
                                <li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('blog-detail', $blog->slug)); ?>&t=<?php echo e($blog->title); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                <li><a class="twitter" href="https://twitter.com/share?text=<?php echo e($blog->title); ?>&url=<?php echo e(route('blog-detail', $blog->slug)); ?>"><i class="fab fa-twitter"></i></a></li>
                                <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('blog-detail', $blog->slug)); ?>&title=<?php echo e($blog->title); ?>"><i class="fab fa-linkedin-in"></i></a></li>
                                <li><a class="pinterest" href="https://www.pinterest.com/pin/create/button/?description=<?php echo e($blog->title); ?>&media=&url=<?php echo e(route('blog-detail', $blog->slug)); ?>"><i class="fab fa-pinterest-p"></i></a></li>
                            </ul>
                        </div>

                        <?php if($relatedBlogs->count() != 0): ?>
                        <div class="wsus__related_post">
                            <div class="row">
                                <div class="col-xl-12">
                                    <h5><?php echo e(__('user.related post')); ?></h5>
                                </div>
                            </div>
                            <div class="row blog_det_slider">
                                <?php
                                    $colorId=1;
                                ?>
                                <?php $__currentLoopData = $relatedBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $relatedBlog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        if($index %4 ==0){
                                            $colorId=1;
                                        }

                                        $color="";
                                        if($colorId==1){
                                            $color="blue";
                                        }else if($colorId==2){
                                            $color="red";
                                        }else if($colorId==3){
                                            $color="orange";
                                        }else if($colorId==4){
                                            $color="green";
                                        }
                                    ?>
                                    <div class="col-xl-6 col-xxl-4 col-sm-6">
                                        <div class="wsus__single_blog">
                                            <a class="wsus__blog_img" href="<?php echo e(route('blog-detail',$relatedBlog->slug)); ?>">
                                                <img src="<?php echo e(asset($relatedBlog->image)); ?>" alt="blog" class="img-fluid w-100">
                                            </a>
                                            <a class="blog_top <?php echo e($color); ?>" href="<?php echo e(route('blog-by-category', $relatedBlog->category->slug)); ?>"><?php echo e($relatedBlog->category->name); ?></a>
                                            <div class="wsus__blog_text">
                                                <div class="wsus__blog_text_center">
                                                    <a href="<?php echo e(route('blog-detail',$relatedBlog->slug)); ?>"><?php echo e($relatedBlog->title); ?></a>
                                                    <p class="date"><span><?php echo e($relatedBlog->created_at->format('d F, Y')); ?></span> <?php echo e(__('user.Hosted by')); ?> <?php echo e($relatedBlog->admin->name); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                        $colorId ++;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="wsus__comment_area">
                            <h4><?php echo e(__('user. comment ')); ?> <span><?php echo e($blog->comments->where('status',1)->count()); ?></span></h4>

                            <?php $__currentLoopData = $blog->comments->where('status',1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogComment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="wsus__main_comment">
                                    <div class="wsus__comment_img">
                                        <img src="http://www.gravatar.com/avatar/75d23af433e0cea4c0e45a56dba18b30" alt="user" class="img-fluid w-100">
                                    </div>
                                    <div class="wsus__comment_text replay">
                                        <h6><?php echo e($blogComment->name); ?> <span><?php echo e($blogComment->created_at->format('d M, Y')); ?></span></h6>
                                        <p><?php echo e($blogComment->comment); ?></p>

                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </div>
                        <div class="wsus__post_comment">
                            <h4><?php echo e(__('user.post a comment')); ?></h4>
                            <form id="blogCommentForm">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-xl-6">
                                        <div class="wsus__single_com">
                                            <input type="text" name="name" placeholder="<?php echo e(__('user.Name')); ?>">
                                            <input type="hidden" name="blog_id" value="<?php echo e($blog->id); ?>">
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="wsus__single_com">
                                            <input type="email" placeholder="<?php echo e(__('user.Email')); ?>" name="email">
                                        </div>
                                    </div>
                                    <div class="col-xl-12">
                                        <div class="wsus__single_com">
                                            <textarea cols="3" rows="3" placeholder="<?php echo e(__('user.Your Comment')); ?>" name="comment"></textarea>
                                        </div>
                                    </div>

                                    <?php if($recaptchaSetting->status==1): ?>
                                        <div class="col-xl-12">
                                            <div class="wsus__single_com mb-3">
                                                <div class="g-recaptcha" data-sitekey="<?php echo e($recaptchaSetting->site_key); ?>"></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                </div>
                                <button class="common_btn" type="submit"><?php echo e(__('user.Submit Comment')); ?></button>
                            </form>
                        </div>

                    </div>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-4">
                    <div class="wsus__blog_sidebar">
                        <div class="wsus__blog_search">
                            <h4><?php echo e(__('user.search')); ?></h4>
                            <form action="<?php echo e(route('search-blog')); ?>">
                                <input type="text" placeholder="Search" name="search">
                                <button type="submit" class="common_btn"><i class="far fa-search"></i></button>
                            </form>
                        </div>
                        <div class="wsus__blog_category">
                            <h4><?php echo e(__('user.Categories')); ?></h4>
                            <ul>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('blog-by-category', $category->slug)); ?>"><?php echo e($category->name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php if($popularPosts->count() > 0): ?>
                        <div class="wsus__blog_post">
                            <h4><?php echo e(__('user.Popular Post')); ?></h4>
                            <?php $__currentLoopData = $popularPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $popularBlog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="wsus__blog_post_single">
                                    <a href="<?php echo e(route('blog-detail',$popularBlog->blog->slug)); ?>" class="wsus__blog_post_img">
                                        <img src="<?php echo e(asset($popularBlog->blog->image)); ?>" alt="blog" class="imgofluid w-100">
                                    </a>
                                    <div class="wsus__blog_post_text">
                                        <a href="<?php echo e(route('blog-detail',$popularBlog->blog->slug)); ?>"><?php echo e($popularBlog->blog->title); ?></a>
                                        <p> <span><?php echo e($popularBlog->blog->created_at->format('d F, Y')); ?> </span> <?php echo e($popularBlog->blog->comments->where('status',1)->count()); ?> <?php echo e(__('user.Comment')); ?> </p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BLOGS DETAILS END
    ==============================-->


    <script>
        (function($) {
            "use strict";
            $(document).ready(function () {
                $("#blogCommentForm").on('submit', function(e){
                    e.preventDefault();
                    var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
                    if(isDemo == 0){
                        toastr.error('This Is Demo Version. You Can Not Change Anything');
                        return;
                    }
                    $.ajax({
                        type: 'POST',
                        data: $('#blogCommentForm').serialize(),
                        url: "<?php echo e(route('blog-comment')); ?>",
                        success: function (response) {
                            if(response.status == 1){
                                toastr.success(response.message)
                                $("#blogCommentForm").trigger("reset");
                            }
                        },
                        error: function(response) {
                            if(response.responseJSON.errors.name)toastr.error(response.responseJSON.errors.name[0])
                            if(response.responseJSON.errors.email)toastr.error(response.responseJSON.errors.email[0])
                            if(response.responseJSON.errors.comment)toastr.error(response.responseJSON.errors.comment[0])

                            if(!response.responseJSON.errors.name || !response.responseJSON.errors.email || !response.responseJSON.errors.comment){
                                toastr.error("<?php echo e(__('user.Please complete the recaptcha to submit the form')); ?>")
                            }
                        }
                    });
                })


            });
        })(jQuery);

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/blog_detail.blade.php ENDPATH**/ ?>