
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Blog Comment')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Blog Comment')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.blog.index')); ?>"><?php echo e(__('admin.Blog')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Blog Comment')); ?></div>
            </div>
          </div>

          <div class="section-body">

            <div class="row mt-4">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                      <div class="table-responsive table-invoice">
                        <table class="table table-striped" id="dataTable">
                            <thead>
                                <tr>
                                    <th width="5%"><?php echo e(__('admin.SN')); ?></th>
                                    <th width="15%"><?php echo e(__('admin.Name')); ?></th>
                                    <th width="15%"><?php echo e(__('admin.Email')); ?></th>
                                    <th width="30%"><?php echo e(__('admin.Comment')); ?></th>
                                    <th width="10%"><?php echo e(__('admin.Blog')); ?></th>
                                    <th width="15%"><?php echo e(__('admin.Status')); ?></th>
                                    <th width="5%"><?php echo e(__('admin.Action')); ?></th>
                                  </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $blogComments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $blogComment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$index); ?></td>
                                        <td><?php echo e($blogComment->name); ?></td>
                                        <td><?php echo e($blogComment->email); ?></td>
                                        <td><?php echo e($blogComment->comment); ?></td>
                                        <td> <a class="btn btn-success btn-sm" href="<?php echo e(route('blog-detail',$blogComment->blog->slug)); ?>"><?php echo e(__('admin.view')); ?></a></td>
                                        <td>

                                            <?php if($blogComment->status == 1): ?>
                                            <a href="javascript:;" onclick="changeBlogCommentStatus(<?php echo e($blogComment->id); ?>)">
                                                <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.Inactive')); ?>" data-onstyle="success" data-offstyle="danger">
                                            </a>

                                            <?php else: ?>
                                            <a href="javascript:;" onclick="changeBlogCommentStatus(<?php echo e($blogComment->id); ?>)">
                                                <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.Inactive')); ?>" data-onstyle="success" data-offstyle="danger">
                                            </a>

                                            <?php endif; ?>
                                        </td>
                                        <td>

                                        <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="btn btn-danger btn-sm" onclick="deleteData(<?php echo e($blogComment->id); ?>)"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                    </td>

                                    </tr>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

<script>
    function deleteData(id){
        $("#deleteForm").attr("action",'<?php echo e(url("admin/blog-comment/")); ?>'+"/"+id)
    }
    function changeBlogCommentStatus(id){
        var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
        if(isDemo == 0){
            toastr.error('This Is Demo Version. You Can Not Change Anything');
            return;
        }
        $.ajax({
            type:"put",
            data: { _token : '<?php echo e(csrf_token()); ?>' },
            url:"<?php echo e(url('/admin/blog-comment-status/')); ?>"+"/"+id,
            success:function(response){
                toastr.success(response)
            },
            error:function(err){
                console.log(err);

            }
        })
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/blog_comment.blade.php ENDPATH**/ ?>