
<?php $__env->startSection('title'); ?>
    <title><?php echo e($seoSetting->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($seoSetting->seo_description); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>
    <!--============================
        BANNER PART START
    ==============================-->
    <?php
        $sliderVisibility = $visibilities->where('id',1)->first();
    ?>
    <?php if($sliderVisibility->status == 1): ?>
    <section id="wsus__banner">
        <div class="container">
            <div class="row">
                <div class="col-xl-3 col-lg-3 d-none d-lg-block">
                    <ul class="wsus_menu_cat_item">
                        <?php $__currentLoopData = $productCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($productCategory->subCategories->count() == 0): ?>
                                <li><a href="<?php echo e(route('product',['category' => $productCategory->slug])); ?>"><i class="<?php echo e($productCategory->icon); ?>"></i> <?php echo e($productCategory->name); ?></a></li>
                            <?php else: ?>
                                <li><a class="wsus__droap_arrow" href="<?php echo e(route('product',['category' => $productCategory->slug])); ?>"><i class="<?php echo e($productCategory->icon); ?>"></i> <?php echo e($productCategory->name); ?> </a>
                                    <ul class="wsus_menu_cat_droapdown">
                                        <?php $__currentLoopData = $productCategory->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($subCategory->childCategories->count() == 0): ?>
                                                <li><a href="<?php echo e(route('product',['sub_category' => $subCategory->slug])); ?>"><?php echo e($subCategory->name); ?></a></li>
                                            <?php else: ?>
                                                <li><a href="<?php echo e(route('product',['sub_category' => $subCategory->slug])); ?>"><?php echo e($subCategory->name); ?> <i class="fas fa-angle-right"></i></a>
                                                    <ul class="wsus__sub_category">
                                                        <?php $__currentLoopData = $subCategory->childCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li><a href="<?php echo e(route('product',['child_category' => $childCategory->slug])); ?>"><?php echo e($childCategory->name); ?></a> </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </li>
                                            <?php endif; ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="col-xl-9 col-lg-9">
                    <div class="wsus__banner_content">
                        <div class="row banner_slider">
                            <?php $__currentLoopData = $sliders->take($sliderVisibility->qty); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-12">
                                <div class="wsus__single_slider" style="background: url(<?php echo e(asset($slider->image)); ?>);">
                                    <div class="wsus__single_slider_text">
                                        <h1><?php echo nl2br($slider->title); ?></h1>
                                        <h6><?php echo nl2br($slider->description); ?></h6>
                                        <a class="common_btn" href="<?php echo e($slider->link); ?>"><?php echo e(__('user.shop now')); ?></a>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>
    <!--============================
        BANNER PART END
    ==============================-->

    <!--============================
        BRAND SLIDER START
    ==============================-->
    <?php
        $brandVisibility = $visibilities->where('id',2)->first();
    ?>
    <?php if($brandVisibility->status == 1): ?>
        <section id="wsus__brand_sleder">
            <div class="container">
                <div class="brand_border">
                    <div class="row brand_slider">
                        <?php $__currentLoopData = $brands->take($brandVisibility->qty); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-2">
                            <div class="wsus__brand_logo">
                                <a href="<?php echo e(route('product',['brand' => $brand->slug])); ?>"><img src="<?php echo e(asset($brand->logo)); ?>" alt="brand" class="img-fluid w-100"></a>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!--============================
        BRAND SLIDER END
    ==============================-->


    <!--============================
        FLASH SELL START
    ==============================-->
    <?php
        $campaignVisibility = $visibilities->where('id',3)->first();
    ?>
    <?php if($campaignVisibility->status == 1): ?>
        <section id="wsus__flash_sell">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12 offer_time">
                        <?php if($campaign): ?>
                        <?php
                            $end = strtotime($campaign->end_date);
                            $current_time=  Carbon\Carbon::now()->timestamp;
                            $capmaign_time = $end - $current_time;

                            if(env('APP_VERSION') == 0){
                                $demo_end = Carbon\Carbon::now()->addDays(3);
                                $demo_end = $demo_end->format('Y-m-d H:i:s');
                                $end = strtotime($demo_end);
                                $capmaign_time = $end - $current_time;
                             }
                        ?>
                        <script>
                            var capmaign_time = <?php echo e($capmaign_time); ?>;
                        </script>

                        <?php if(env('APP_VERSION') == 0): ?>
                            <?php
                                $demo_end = Carbon\Carbon::now()->addDays(3);
                            ?>
                            <script>
                                var campaign_end_year = <?php echo e($demo_end->format('Y')); ?>

                                var campaign_end_month = <?php echo e($demo_end->format('m')); ?>

                                var campaign_end_date = <?php echo e($demo_end->format('d')); ?>

                                var campaign_hour = <?php echo e($demo_end->format('H')); ?>

                                var campaign_min = <?php echo e($demo_end->format('i')); ?>

                                var campaign_sec = <?php echo e($demo_end->format('s')); ?>

                            </script>
                            <?php else: ?>
                            <script>
                                var campaign_end_year = <?php echo e(date('Y', strtotime($campaign->end_date))); ?>

                                var campaign_end_month = <?php echo e(date('m', strtotime($campaign->end_date))); ?>

                                var campaign_end_date = <?php echo e(date('d', strtotime($campaign->end_date))); ?>

                                var campaign_hour = <?php echo e(date('H', strtotime($campaign->end_date))); ?>

                                var campaign_min = <?php echo e(date('i', strtotime($campaign->end_date))); ?>

                                var campaign_sec = <?php echo e(date('s', strtotime($campaign->end_date))); ?>

                            </script>
                        <?php endif; ?>

                        <div class="wsus__flash_coundown">
                            <span class="end_text"><?php echo e($campaign->name); ?></span>

                            <div class="simply-countdown campaign-details"></div>

                            <a class="common_btn" href="<?php echo e(route('campaign-detail', $campaign->slug)); ?>"><?php echo e(__('user.see more')); ?> <i class="fas fa-caret-right"></i></a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="row flash_sell_slider">
                    <?php if($campaignProducts != null): ?>
                        <?php $__currentLoopData = $campaignProducts->take($campaignVisibility->qty); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaignProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-sm-6 col-lg-4">
                            <div class="wsus__product_item">
                                <?php if($campaignProduct->product->new_product == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.New')); ?></span>
                                <?php elseif($campaignProduct->product->is_featured == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Featured')); ?></span>
                                <?php elseif($campaignProduct->product->is_top == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Top')); ?></span>
                                <?php elseif($campaignProduct->product->is_best == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Best')); ?></span>
                                <?php endif; ?>

                                <?php
                                    $variantPrice = 0;
                                    $variants = $campaignProduct->product->variants->where('status', 1);
                                    if($variants->count() != 0){
                                        foreach ($variants as $variants_key => $variant) {
                                            if($variant->variantItems->where('status',1)->count() != 0){
                                                $item = $variant->variantItems->where('is_default',1)->first();
                                                if($item){
                                                    $variantPrice += $item->price;
                                                }
                                            }
                                        }
                                    }

                                    $isCampaign = false;
                                    $today = date('Y-m-d H:i:s');
                                    $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $campaignProduct->product->id])->first();
                                    if($campaign){
                                        $campaign = $campaign->campaign;
                                        if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                            $isCampaign = true;
                                        }
                                        $campaignOffer = $campaign->offer;
                                        $productPrice = $campaignProduct->product->price;
                                        $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                        $totalPrice = $campaignProduct->product->price;
                                        $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                    }

                                    $totalPrice = $campaignProduct->product->price;
                                    if($campaignProduct->product->offer_price != null){
                                        $offerPrice = $campaignProduct->product->offer_price;
                                        $offer = $totalPrice - $offerPrice;
                                        $percentage = ($offer * 100) / $totalPrice;
                                        $percentage = round($percentage);
                                    }
                                ?>

                                <?php if($isCampaign): ?>
                                    <span class="wsus__minus">-<?php echo e($campaignOffer); ?>%</span>
                                <?php else: ?>
                                    <?php if($campaignProduct->product->offer_price != null): ?>
                                        <span class="wsus__minus">-<?php echo e($percentage); ?>%</span>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <a class="wsus__pro_link" href="<?php echo e(route('product-detail',$campaignProduct->product->slug)); ?>">
                                    <img src="<?php echo e(asset($campaignProduct->product->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_1" />
                                    <img src="<?php echo e(asset($campaignProduct->product->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_2" />
                                </a>
                                <ul class="wsus__single_pro_icon">
                                    <li><a href="#" data-bs-toggle="modal" data-bs-target="#productModalView-<?php echo e($campaignProduct->product->id); ?>"><i
                                                class="far fa-eye"></i></a></li>
                                    <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($campaignProduct->product->id); ?>')"><i class="far fa-heart"></i></a></li>
                                    <li><a href="javascript:;" onclick="addToCompare('<?php echo e($campaignProduct->product->id); ?>')"><i class="far fa-random"></i></a>
                                    </li>
                                </ul>
                                <div class="wsus__product_details">
                                    <a class="wsus__category" href="<?php echo e(route('product',['category' => $campaignProduct->product->category->slug])); ?>"><?php echo e($campaignProduct->product->category->name); ?> </a>
                                    <?php
                                        $reviewQty = $campaignProduct->product->reviews->where('status',1)->count();
                                        $totalReview = $campaignProduct->product->reviews->where('status',1)->sum('rating');

                                        if ($reviewQty > 0) {
                                            $average = $totalReview / $reviewQty;

                                            $intAverage = intval($average);

                                            $nextValue = $intAverage + 1;
                                            $reviewPoint = $intAverage;
                                            $halfReview=false;
                                            if($intAverage < $average && $average < $nextValue){
                                                $reviewPoint= $intAverage + 0.5;
                                                $halfReview=true;
                                            }
                                        }
                                    ?>

                                    <?php if($reviewQty > 0): ?>
                                        <p class="wsus__pro_rating">
                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                <?php if($i <= $reviewPoint): ?>
                                                    <i class="fas fa-star"></i>
                                                <?php elseif($i> $reviewPoint ): ?>
                                                    <?php if($halfReview==true): ?>
                                                    <i class="fas fa-star-half-alt"></i>
                                                        <?php
                                                            $halfReview=false
                                                        ?>
                                                    <?php else: ?>
                                                    <i class="fal fa-star"></i>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                    <?php endif; ?>

                                    <?php if($reviewQty == 0): ?>
                                        <p class="wsus__pro_rating">
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                    <?php endif; ?>
                                    <a class="wsus__pro_name" href="<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>"><?php echo e($campaignProduct->product->short_name); ?></a>

                                    <?php if($isCampaign): ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                    <?php else: ?>
                                        <?php if($campaignProduct->product->offer_price == null): ?>
                                            <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                        <?php else: ?>
                                            <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignProduct->product->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <a class="add_cart" onclick="addToCartMainProduct('<?php echo e($campaignProduct->product->id); ?>')" href="javascript:;"><?php echo e(__('user.add to cart')); ?></a>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>

                <?php if($campaignProducts != null): ?>
                    <?php $__currentLoopData = $campaignProducts->take($campaignVisibility->qty); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaignProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <section class="product_popup_modal">
                            <div class="modal fade" id="productModalView-<?php echo e($campaignProduct->product->id); ?>" tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                                    class="far fa-times"></i></button>
                                            <div class="row">
                                                <div class="col-xl-6 col-12 col-sm-10 col-md-8 col-lg-6 m-auto display">
                                                    <div class="wsus__quick_view_img">
                                                        <?php if($campaignProduct->product->video_link): ?>
                                                            <?php
                                                                $video_id=explode("=",$campaignProduct->product->video_link);
                                                            ?>
                                                            <a class="venobox wsus__pro_det_video" data-autoplay="true" data-vbtype="video"
                                                            href="https://youtu.be/<?php echo e($video_id[1]); ?>">
                                                            <i class="fas fa-play"></i>
                                                        </a>
                                                        <?php endif; ?>

                                                        <div class="row modal_slider">
                                                            <?php $__currentLoopData = $campaignProduct->product->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="col-xl-12">
                                                                <div class="modal_slider_img">
                                                                    <img src="<?php echo e(asset($image->image)); ?>" alt="product" class="img-fluid w-100">
                                                                </div>
                                                            </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xl-6 col-12 col-sm-12 col-md-12 col-lg-6">
                                                    <div class="wsus__pro_details_text">
                                                        <a class="title" href="<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>"><?php echo e($campaignProduct->product->name); ?></a>

                                                            <?php if($campaignProduct->product->qty == 0): ?>
                                                            <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.Out of Stock')); ?></span></p>
                                                            <?php else: ?>
                                                                <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.In stock')); ?>

                                                                    <?php if($setting->show_product_qty == 1): ?>
                                                                        </span> (<?php echo e($campaignProduct->product->qty); ?> <?php echo e(__('user.item')); ?>)
                                                                    <?php endif; ?>
                                                                </p>
                                                            <?php endif; ?>


                                                        <?php
                                                            $reviewQty = $campaignProduct->product->reviews->where('status',1)->count();
                                                            $totalReview = $campaignProduct->product->reviews->where('status',1)->sum('rating');

                                                            if ($reviewQty > 0) {
                                                                $average = $totalReview / $reviewQty;

                                                                $intAverage = intval($average);

                                                                $nextValue = $intAverage + 1;
                                                                $reviewPoint = $intAverage;
                                                                $halfReview=false;
                                                                if($intAverage < $average && $average < $nextValue){
                                                                    $reviewPoint= $intAverage + 0.5;
                                                                    $halfReview=true;
                                                                }
                                                            }
                                                        ?>

                                                        <?php
                                                            $variantPrice = 0;
                                                            $variants = $campaignProduct->product->variants->where('status', 1);
                                                            if($variants->count() != 0){
                                                                foreach ($variants as $variants_key => $variant) {
                                                                    if($variant->variantItems->where('status',1)->count() != 0){
                                                                        $item = $variant->variantItems->where('is_default',1)->first();
                                                                        if($item){
                                                                            $variantPrice += $item->price;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            $isCampaign = false;
                                                            $today = date('Y-m-d H:i:s');
                                                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $campaignProduct->product->id])->first();
                                                            if($campaign){
                                                                $campaign = $campaign->campaign;
                                                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                                    $isCampaign = true;
                                                                }
                                                                $campaignOffer = $campaign->offer;
                                                                $productPrice = $campaignProduct->product->price;
                                                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                                $totalPrice = $campaignProduct->product->price;
                                                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                                            }

                                                            $totalPrice = $campaignProduct->product->price;
                                                            if($campaignProduct->product->offer_price != null){
                                                                $offerPrice = $campaignProduct->product->offer_price;
                                                                $offer = $totalPrice - $offerPrice;
                                                                $percentage = ($offer * 100) / $totalPrice;
                                                                $percentage = round($percentage);
                                                            }


                                                        ?>

                                                        <?php if($isCampaign): ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductModalPrice-<?php echo e($campaignProduct->product->id); ?>"><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?></span>  <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                        <?php else: ?>
                                                            <?php if($campaignProduct->product->offer_price == null): ?>
                                                                <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($campaignProduct->product->id); ?>"><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></span></h4>
                                                            <?php else: ?>
                                                                <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($campaignProduct->product->id); ?>"><?php echo e(sprintf("%.2f", $campaignProduct->product->offer_price + $variantPrice)); ?></span> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                            <?php endif; ?>
                                                        <?php endif; ?>

                                                        <?php if($reviewQty > 0): ?>
                                                            <p class="review">
                                                                <?php for($i = 1; $i <=5; $i++): ?>
                                                                    <?php if($i <= $reviewPoint): ?>
                                                                        <i class="fas fa-star"></i>
                                                                    <?php elseif($i> $reviewPoint ): ?>
                                                                        <?php if($halfReview==true): ?>
                                                                        <i class="fas fa-star-half-alt"></i>
                                                                            <?php
                                                                                $halfReview=false
                                                                            ?>
                                                                        <?php else: ?>
                                                                        <i class="fal fa-star"></i>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                <?php endfor; ?>
                                                                <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                                            </p>
                                                        <?php endif; ?>

                                                        <?php if($reviewQty == 0): ?>
                                                            <p class="review">
                                                                <i class="fal fa-star"></i>
                                                                <i class="fal fa-star"></i>
                                                                <i class="fal fa-star"></i>
                                                                <i class="fal fa-star"></i>
                                                                <i class="fal fa-star"></i>
                                                                <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                                            </p>
                                                        <?php endif; ?>

                                                        <?php
                                                            $productPrice = 0;
                                                            if($isCampaign){
                                                                $productPrice = $campaignOfferPrice + $variantPrice;
                                                            }else{
                                                                if ($campaignProduct->product->offer_price == null) {
                                                                    $productPrice = $totalPrice + $variantPrice;
                                                                }else {
                                                                    $productPrice = $campaignProduct->product->offer_price + $variantPrice;
                                                                }
                                                            }
                                                        ?>
                                                        <form id="productModalFormId-<?php echo e($campaignProduct->product->id); ?>">
                                                        <div class="wsus__quentity">
                                                            <h5><?php echo e(__('user.quantity')); ?> :</h5>
                                                            <div class="modal_btn">
                                                                <button onclick="productModalDecrement('<?php echo e($campaignProduct->product->id); ?>')" type="button" class="btn btn-danger btn-sm">-</button>
                                                                <input id="productModalQty-<?php echo e($campaignProduct->product->id); ?>" name="quantity"  readonly class="form-control" type="text" min="1" max="100" value="1" />
                                                                <button onclick="productModalIncrement('<?php echo e($campaignProduct->product->id); ?>','<?php echo e($campaignProduct->product->qty); ?>')" type="button" class="btn btn-success btn-sm">+</button>
                                                            </div>
                                                            <h3 class="d-none"><?php echo e($currencySetting->currency_icon); ?><span id="productModalPrice-<?php echo e($campaignProduct->product->id); ?>"><?php echo e(sprintf("%.2f",$productPrice)); ?></span></h3>

                                                            <input type="hidden" name="product_id" value="<?php echo e($campaignProduct->product->id); ?>">
                                                            <input type="hidden" name="image" value="<?php echo e($campaignProduct->product->thumb_image); ?>">
                                                            <input type="hidden" name="slug" value="<?php echo e($campaignProduct->product->slug); ?>">

                                                        </div>
                                                        <?php
                                                            $productVariants = App\Models\ProductVariant::where(['status' => 1, 'product_id'=> $campaignProduct->product->id])->get();
                                                        ?>
                                                        <?php if($productVariants->count() != 0): ?>
                                                            <div class="wsus__selectbox">
                                                                <div class="row">
                                                                    <?php $__currentLoopData = $productVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productVariant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php
                                                                            $items = App\Models\ProductVariantItem::orderBy('is_default','desc')->where(['product_variant_id' => $productVariant->id, 'product_id' => $campaignProduct->product->id])->get();
                                                                        ?>
                                                                        <?php if($items->count() != 0): ?>
                                                                            <div class="col-xl-6 col-sm-6 mb-3">
                                                                                <h5 class="mb-2"><?php echo e($productVariant->name); ?>:</h5>

                                                                                <input type="hidden" name="variants[]" value="<?php echo e($productVariant->id); ?>">
                                                                                <input type="hidden" name="variantNames[]" value="<?php echo e($productVariant->name); ?>">

                                                                                <select class="select_2 productModalVariant" name="items[]" data-product="<?php echo e($campaignProduct->product->id); ?>">
                                                                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                        <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                </select>

                                                                            </div>
                                                                        <?php endif; ?>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                        <ul class="wsus__button_area">
                                                            <li><button type="button" onclick="addToCartInProductModal('<?php echo e($campaignProduct->product->id); ?>')" class="add_cart"><?php echo e(__('user.add to cart')); ?></button></li>
                                                            <li><a class="buy_now" href="javascript:;" onclick="addToBuyNow('<?php echo e($campaignProduct->product->id); ?>')"><?php echo e(__('user.buy now')); ?></a></li>
                                                            <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($campaignProduct->product->id); ?>')"><i class="fal fa-heart"></i></a></li>
                                                            <li><a href="javascript:;" onclick="addToCompare('<?php echo e($campaignProduct->product->id); ?>')"><i class="far fa-random"></i></a></li>
                                                        </ul>
                                                    </form>
                                                    <?php if($campaignProduct->product->sku): ?>
                                                    <p class="brand_model"><span><?php echo e(__('user.Model')); ?> :</span> <?php echo e($campaignProduct->product->sku); ?></p>
                                                    <?php endif; ?>

                                                    <p class="brand_model"><span><?php echo e(__('user.Brand')); ?> :</span> <a href="<?php echo e(route('product',['brand' => $campaignProduct->product->brand->slug])); ?>"><?php echo e($campaignProduct->product->brand->name); ?></a></p>
                                                    <p class="brand_model"><span><?php echo e(__('user.Category')); ?> :</span> <a href="<?php echo e(route('product',['category' => $campaignProduct->product->category->slug])); ?>"><?php echo e($campaignProduct->product->category->name); ?></a></p>
                                                    <div class="wsus__pro_det_share d-none">
                                                        <h5><?php echo e(__('user.share')); ?> :</h5>
                                                        <ul class="d-flex">
                                                            <li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>&t=<?php echo e($campaignProduct->product->name); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                                            <li><a class="twitter" href="https://twitter.com/share?text=<?php echo e($campaignProduct->product->name); ?>&url=<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>"><i class="fab fa-twitter"></i></a></li>
                                                            <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>&title=<?php echo e($campaignProduct->product->name); ?>"><i class="fab fa-linkedin"></i></a></li>
                                                            <li><a class="pinterest" href="https://www.pinterest.com/pin/create/button/?description=<?php echo e($campaignProduct->product->name); ?>&media=&url=<?php echo e(route('product-detail', $campaignProduct->product->slug)); ?>"><i class="fab fa-pinterest-p"></i></a></li>
                                                        </ul>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </section>
    <?php endif; ?>
    <!--============================
        FLASH SELL END
    ==============================-->


    <!--============================
       MONTHLY TOP PRODUCT START
    ==============================-->
 <?php
    $popularCategoryVisible = $visibilities->where('id',4)->first();
?>
<?php if($popularCategoryVisible->status == 1): ?>
    <section id="wsus__monthly_top">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="wsus__section_header for_md">
                        <h3><?php echo e($popularCategory->title); ?></h3>
                        <div class="monthly_top_filter">
                            <button class=" active click_first_cat" data-filter=".first_cat"><?php echo e($firstCategory ? $firstCategory->name : ''); ?></button>
                            <button data-filter=".second_cat"><?php echo e($secondCategory ? $secondCategory->name : ''); ?></button>
                            <button data-filter=".third_cat"><?php echo e($thirdCategory ? $thirdCategory->name : ''); ?></button>
                            <button data-filter=".fourth_cat"><?php echo e($fourthCategory ? $fourthCategory->name : ''); ?></button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-3 col-lg-4">
                    <div class="wsus__monthly_top_banner">
                        <div class="wsus__monthly_top_banner_img">
                            <img src="<?php echo e(asset($oneColumnBanner->image)); ?>" alt="img" class="img-fluid w-100">
                            <span></span>
                        </div>
                        <div class="wsus__monthly_top_banner_text">
                            <h3><?php echo e($oneColumnBanner->title); ?></h3>
                            <H6><?php echo e($oneColumnBanner->description); ?></H6>
                            <a class="shop_btn" href="<?php echo e($oneColumnBanner->link); ?>"><?php echo e(__('user.shop now')); ?></a>
                        </div>
                    </div>
                </div>
                <div class="col-xl-9 col-lg-8">
                    <div class="row grid">
                        <?php $__currentLoopData = $firstCategoryproducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $firstCategoryproduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-4 col-sm-6  first_cat">
                                <a class="wsus__hot_deals__single" href="<?php echo e(route('product-detail', $firstCategoryproduct->slug)); ?>">
                                    <div class="wsus__hot_deals__single_img">
                                        <img src="<?php echo e($firstCategoryproduct->thumb_image); ?>" alt="bag" class="img-fluid w-100">
                                    </div>
                                    <?php
                                        $reviewQty = $firstCategoryproduct->reviews->where('status',1)->count();
                                        $totalReview = $firstCategoryproduct->reviews->where('status',1)->sum('rating');

                                        if ($reviewQty > 0) {
                                            $average = $totalReview / $reviewQty;

                                            $intAverage = intval($average);

                                            $nextValue = $intAverage + 1;
                                            $reviewPoint = $intAverage;
                                            $halfReview=false;
                                            if($intAverage < $average && $average < $nextValue){
                                                $reviewPoint= $intAverage + 0.5;
                                                $halfReview=true;
                                            }
                                        }
                                    ?>

                                    <div class="wsus__hot_deals__single_text">
                                        <h5><?php echo e($firstCategoryproduct->short_name); ?></h5>

                                        <?php if($reviewQty > 0): ?>
                                            <p class="wsus__rating">
                                                <?php for($i = 1; $i <=5; $i++): ?>
                                                    <?php if($i <= $reviewPoint): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php elseif($i> $reviewPoint ): ?>
                                                        <?php if($halfReview==true): ?>
                                                        <i class="fas fa-star-half-alt"></i>
                                                            <?php
                                                                $halfReview=false
                                                            ?>
                                                        <?php else: ?>
                                                        <i class="fal fa-star"></i>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                                <span>(<?php echo e($reviewQty); ?>)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php if($reviewQty == 0): ?>
                                            <p class="wsus__rating">
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <span>(0)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php
                                            $variantPrice = 0;
                                            $variants = $firstCategoryproduct->variants->where('status', 1);
                                            if($variants->count() != 0){
                                                foreach ($variants as $variants_key => $variant) {
                                                    if($variant->variantItems->where('status',1)->count() != 0){
                                                        $item = $variant->variantItems->where('is_default',1)->first();
                                                        if($item){
                                                            $variantPrice += $item->price;
                                                        }
                                                    }
                                                }
                                            }
                                            $isCampaign = false;
                                            $today = date('Y-m-d H:i:s');
                                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $firstCategoryproduct->id])->first();
                                            if($campaign){
                                                $campaign = $campaign->campaign;
                                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                    $isCampaign = true;
                                                }
                                                $campaignOffer = $campaign->offer;
                                                $productPrice = $firstCategoryproduct->price;
                                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                $totalPrice = $firstCategoryproduct->price;
                                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                            }

                                            $totalPrice = $firstCategoryproduct->price;
                                            if($firstCategoryproduct->offer_price != null){
                                                $offerPrice = $firstCategoryproduct->offer_price;
                                                $offer = $totalPrice - $offerPrice;
                                                $percentage = ($offer * 100) / $totalPrice;
                                                $percentage = round($percentage);
                                            }
                                        ?>
                                        <?php if($isCampaign): ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php else: ?>
                                            <?php if($firstCategoryproduct->offer_price == null): ?>
                                                <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                            <?php else: ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $firstCategoryproduct->offer_price + $variantPrice)); ?> <del><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php $__currentLoopData = $secondCategoryproducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secondCategoryproduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-4 col-sm-6  second_cat">
                                <a class="wsus__hot_deals__single" href="<?php echo e(route('product-detail', $secondCategoryproduct->slug)); ?>">
                                    <div class="wsus__hot_deals__single_img">
                                        <img src="<?php echo e($secondCategoryproduct->thumb_image); ?>" alt="bag" class="img-fluid w-100">
                                    </div>
                                    <?php
                                        $reviewQty = $secondCategoryproduct->reviews->where('status',1)->count();
                                        $totalReview = $secondCategoryproduct->reviews->where('status',1)->sum('rating');

                                        if ($reviewQty > 0) {
                                            $average = $totalReview / $reviewQty;

                                            $intAverage = intval($average);

                                            $nextValue = $intAverage + 1;
                                            $reviewPoint = $intAverage;
                                            $halfReview=false;
                                            if($intAverage < $average && $average < $nextValue){
                                                $reviewPoint= $intAverage + 0.5;
                                                $halfReview=true;
                                            }
                                        }
                                    ?>

                                    <div class="wsus__hot_deals__single_text">
                                        <h5><?php echo e($secondCategoryproduct->short_name); ?></h5>

                                        <?php if($reviewQty > 0): ?>
                                            <p class="wsus__rating">
                                                <?php for($i = 1; $i <=5; $i++): ?>
                                                    <?php if($i <= $reviewPoint): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php elseif($i> $reviewPoint ): ?>
                                                        <?php if($halfReview==true): ?>
                                                        <i class="fas fa-star-half-alt"></i>
                                                            <?php
                                                                $halfReview=false
                                                            ?>
                                                        <?php else: ?>
                                                        <i class="fal fa-star"></i>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                                <span>(<?php echo e($reviewQty); ?>)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php if($reviewQty == 0): ?>
                                            <p class="wsus__rating">
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <span>(0)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php
                                            $variantPrice = 0;
                                            $variants = $secondCategoryproduct->variants->where('status', 1);
                                            if($variants->count() != 0){
                                                foreach ($variants as $variants_key => $variant) {
                                                    if($variant->variantItems->where('status',1)->count() != 0){
                                                        $item = $variant->variantItems->where('is_default',1)->first();
                                                        if($item){
                                                            $variantPrice += $item->price;
                                                        }
                                                    }
                                                }
                                            }
                                            $isCampaign = false;
                                            $today = date('Y-m-d H:i:s');
                                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $secondCategoryproduct->id])->first();
                                            if($campaign){
                                                $campaign = $campaign->campaign;
                                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                    $isCampaign = true;
                                                }
                                                $campaignOffer = $campaign->offer;
                                                $productPrice = $secondCategoryproduct->price;
                                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                $totalPrice = $secondCategoryproduct->price;
                                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                            }

                                            $totalPrice = $secondCategoryproduct->price;
                                            if($secondCategoryproduct->offer_price != null){
                                                $offerPrice = $secondCategoryproduct->offer_price;
                                                $offer = $totalPrice - $offerPrice;
                                                $percentage = ($offer * 100) / $totalPrice;
                                                $percentage = round($percentage);
                                            }
                                        ?>
                                        <?php if($isCampaign): ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php else: ?>
                                            <?php if($secondCategoryproduct->offer_price == null): ?>
                                                <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                            <?php else: ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $secondCategoryproduct->offer_price + $variantPrice)); ?> <del><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php $__currentLoopData = $thirdCategoryproducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $thirdCategoryproduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-4 col-sm-6  third_cat">
                                <a class="wsus__hot_deals__single" href="<?php echo e(route('product-detail', $thirdCategoryproduct->slug)); ?>">
                                    <div class="wsus__hot_deals__single_img">
                                        <img src="<?php echo e($thirdCategoryproduct->thumb_image); ?>" alt="bag" class="img-fluid w-100">
                                    </div>
                                    <?php
                                        $reviewQty = $thirdCategoryproduct->reviews->where('status',1)->count();
                                        $totalReview = $thirdCategoryproduct->reviews->where('status',1)->sum('rating');

                                        if ($reviewQty > 0) {
                                            $average = $totalReview / $reviewQty;

                                            $intAverage = intval($average);

                                            $nextValue = $intAverage + 1;
                                            $reviewPoint = $intAverage;
                                            $halfReview=false;
                                            if($intAverage < $average && $average < $nextValue){
                                                $reviewPoint= $intAverage + 0.5;
                                                $halfReview=true;
                                            }
                                        }
                                    ?>

                                    <div class="wsus__hot_deals__single_text">
                                        <h5><?php echo e($thirdCategoryproduct->short_name); ?></h5>

                                        <?php if($reviewQty > 0): ?>
                                            <p class="wsus__rating">
                                                <?php for($i = 1; $i <=5; $i++): ?>
                                                    <?php if($i <= $reviewPoint): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php elseif($i> $reviewPoint ): ?>
                                                        <?php if($halfReview==true): ?>
                                                        <i class="fas fa-star-half-alt"></i>
                                                            <?php
                                                                $halfReview=false
                                                            ?>
                                                        <?php else: ?>
                                                        <i class="fal fa-star"></i>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                                <span>(<?php echo e($reviewQty); ?>)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php if($reviewQty == 0): ?>
                                            <p class="wsus__rating">
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <span>(0)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php
                                            $variantPrice = 0;
                                            $variants = $thirdCategoryproduct->variants->where('status', 1);
                                            if($variants->count() != 0){
                                                foreach ($variants as $variants_key => $variant) {
                                                    if($variant->variantItems->where('status',1)->count() != 0){
                                                        $item = $variant->variantItems->where('is_default',1)->first();
                                                        if($item){
                                                            $variantPrice += $item->price;
                                                        }
                                                    }
                                                }
                                            }
                                            $isCampaign = false;
                                            $today = date('Y-m-d H:i:s');
                                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $thirdCategoryproduct->id])->first();
                                            if($campaign){
                                                $campaign = $campaign->campaign;
                                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                    $isCampaign = true;
                                                }
                                                $campaignOffer = $campaign->offer;
                                                $productPrice = $thirdCategoryproduct->price;
                                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                $totalPrice = $thirdCategoryproduct->price;
                                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                            }

                                            $totalPrice = $thirdCategoryproduct->price;
                                            if($thirdCategoryproduct->offer_price != null){
                                                $offerPrice = $thirdCategoryproduct->offer_price;
                                                $offer = $totalPrice - $offerPrice;
                                                $percentage = ($offer * 100) / $totalPrice;
                                                $percentage = round($percentage);
                                            }
                                        ?>
                                        <?php if($isCampaign): ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($totalPrice); ?></del></p>
                                        <?php else: ?>
                                            <?php if($thirdCategoryproduct->offer_price == null): ?>
                                                <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                            <?php else: ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $thirdCategoryproduct->offer_price + $variantPrice)); ?> <del><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php $__currentLoopData = $fourthCategoryproducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fourthCategoryproduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-4 col-sm-6  fourth_cat">
                                <a class="wsus__hot_deals__single" href="<?php echo e(route('product-detail', $fourthCategoryproduct->slug)); ?>">
                                    <div class="wsus__hot_deals__single_img">
                                        <img src="<?php echo e($fourthCategoryproduct->thumb_image); ?>" alt="bag" class="img-fluid w-100">
                                    </div>
                                    <?php
                                        $reviewQty = $fourthCategoryproduct->reviews->where('status',1)->count();
                                        $totalReview = $fourthCategoryproduct->reviews->where('status',1)->sum('rating');

                                        if ($reviewQty > 0) {
                                            $average = $totalReview / $reviewQty;

                                            $intAverage = intval($average);

                                            $nextValue = $intAverage + 1;
                                            $reviewPoint = $intAverage;
                                            $halfReview=false;
                                            if($intAverage < $average && $average < $nextValue){
                                                $reviewPoint= $intAverage + 0.5;
                                                $halfReview=true;
                                            }
                                        }
                                    ?>

                                    <div class="wsus__hot_deals__single_text">
                                        <h5><?php echo e($fourthCategoryproduct->short_name); ?></h5>

                                        <?php if($reviewQty > 0): ?>
                                            <p class="wsus__rating">
                                                <?php for($i = 1; $i <=5; $i++): ?>
                                                    <?php if($i <= $reviewPoint): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php elseif($i> $reviewPoint ): ?>
                                                        <?php if($halfReview==true): ?>
                                                        <i class="fas fa-star-half-alt"></i>
                                                            <?php
                                                                $halfReview=false
                                                            ?>
                                                        <?php else: ?>
                                                        <i class="fal fa-star"></i>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                                <span>(<?php echo e($reviewQty); ?>)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php if($reviewQty == 0): ?>
                                            <p class="wsus__rating">
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <span>(0)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php
                                            $variantPrice = 0;
                                            $variants = $fourthCategoryproduct->variants->where('status', 1);
                                            if($variants->count() != 0){
                                                foreach ($variants as $variants_key => $variant) {
                                                    if($variant->variantItems->where('status',1)->count() != 0){
                                                        $item = $variant->variantItems->where('is_default',1)->first();
                                                        if($item){
                                                            $variantPrice += $item->price;
                                                        }
                                                    }
                                                }
                                            }
                                            $isCampaign = false;
                                            $today = date('Y-m-d H:i:s');
                                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $fourthCategoryproduct->id])->first();
                                            if($campaign){
                                                $campaign = $campaign->campaign;
                                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                    $isCampaign = true;
                                                }
                                                $campaignOffer = $campaign->offer;
                                                $productPrice = $fourthCategoryproduct->price;
                                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                $totalPrice = $fourthCategoryproduct->price;
                                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                            }

                                            $totalPrice = $fourthCategoryproduct->price;
                                            if($fourthCategoryproduct->offer_price != null){
                                                $offerPrice = $fourthCategoryproduct->offer_price;
                                                $offer = $totalPrice - $offerPrice;
                                                $percentage = ($offer * 100) / $totalPrice;
                                                $percentage = round($percentage);
                                            }
                                        ?>
                                        <?php if($isCampaign): ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e(sprintf("%.2f", $totalPrice )); ?></del></p>
                                        <?php else: ?>
                                            <?php if($fourthCategoryproduct->offer_price == null): ?>
                                                <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice )); ?></p>
                                            <?php else: ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $fourthCategoryproduct->offer_price + $variantPrice )); ?> <del><?php echo e(sprintf("%.2f", $totalPrice )); ?></del></p>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php endif; ?>
    <!--============================
       MONTHLY TOP PRODUCT END
    ==============================-->


    <!--============================
        SINGLE BANNER START
    ==============================-->
    <?php
        $bannerVisibility = $visibilities->where('id',5)->first();
    ?>
    <?php if($bannerVisibility->status == 1): ?>
    <section id="wsus__single_banner">
        <div class="container">
            <div class="row">
                <?php
                    $bannerOne = $banners->where('id',3)->first();
                    $bannerTwo = $banners->where('id',4)->first();
                ?>
                <div class="col-xl-6 col-lg-6">
                    <div class="wsus__single_banner_content">
                        <div class="wsus__single_banner_img">
                            <img src="<?php echo e(asset($bannerOne->image)); ?>" alt="banner" class="img-fluid w-100">
                        </div>
                        <div class="wsus__single_banner_text">
                            <h6><?php echo e($bannerOne->description); ?></h6>
                            <h3><?php echo e($bannerOne->title); ?></h3>
                            <a class="shop_btn" href="<?php echo e($bannerOne->link); ?>"><?php echo e(__('user.shop now')); ?></a>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="wsus__single_banner_content">
                        <div class="wsus__single_banner_img">
                            <img src="<?php echo e(asset($bannerTwo->image)); ?>" alt="banner" class="img-fluid w-100">
                        </div>
                        <div class="wsus__single_banner_text">
                            <h6><?php echo e($bannerTwo->description); ?></h6>
                            <h3><?php echo e($bannerTwo->title); ?></h3>
                            <a class="shop_btn" href="<?php echo e($bannerTwo->link); ?>"><?php echo e(__('user.shop now')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>
    <!--============================
        SINGLE BANNER END
    ==============================-->


    <!--============================
           HOT DEALS START
    ==============================-->
    <section id="wsus__hot_deals">
        <div class="container">
            <?php
                $flashDealVisibility = $visibilities->where('id',6)->first();
                $productIds = [];
                $productYears = [];
                $productMonths = [];
                $productDays = [];

                if(env('APP_VERSION') == 0){
                    $demo_end = Carbon\Carbon::now()->addDays(3);
                    foreach ($flashDealProducts as $key => $flashDealProduct) {
                        $productIds[] = $flashDealProduct->id;
                        $productYears[] = $demo_end->format('Y');
                        $productMonths[] = $demo_end->format('m');;
                        $productDays[] = $demo_end->format('d');
                    }
                }else {
                    foreach ($flashDealProducts as $key => $flashDealProduct) {
                        $productIds[] = $flashDealProduct->id;
                        $productYears[] = date('Y', strtotime($flashDealProduct->flash_deal_date));
                        $productMonths[] = date('m', strtotime($flashDealProduct->flash_deal_date));
                        $productDays[] = date('d', strtotime($flashDealProduct->flash_deal_date));
                    }
                }

            ?>
            <script>
                var productIds = <?= json_encode($productIds)?>;
                var productYears = <?= json_encode($productYears)?>;
                var productMonths = <?= json_encode($productMonths)?>;
                var productDays = <?= json_encode($productDays)?>;
            </script>
            <?php if($flashDealVisibility->status == 1): ?>
            <div class="row">
                <div class="col-xl-12">
                    <div class="wsus__section_header">
                        <h3><?php echo e(__('user.Flash Deal')); ?></h3>
                    </div>
                </div>
            </div>
            <div class="row hot_deals_slider">
                <?php $__currentLoopData = $flashDealProducts->take($flashDealVisibility->qty); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flashDealProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-6 col-lg-6">
                    <div class="wsus__hot_deals_offer">
                        <div class="wsus__hot_deals_img">
                            <img src="<?php echo e($flashDealProduct->thumb_image); ?>" alt="mobile" class="img-fluid w-100">
                            <div class="simply-countdown flash-deal-product-<?php echo e($flashDealProduct->id); ?>"></div>
                        </div>
                        <div class="wsus__hot_deals_text">
                            <a class="wsus__hot_title" href="<?php echo e(route('product-detail', $flashDealProduct->slug)); ?>"><?php echo e($flashDealProduct->short_name); ?></a>
                            <?php
                                $reviewQty = $flashDealProduct->reviews->where('status',1)->count();
                                $totalReview = $flashDealProduct->reviews->where('status',1)->sum('rating');
                                if ($reviewQty > 0) {
                                    $average = $totalReview / $reviewQty;
                                    $intAverage = intval($average);
                                    $nextValue = $intAverage + 1;
                                    $reviewPoint = $intAverage;
                                    $halfReview=false;
                                    if($intAverage < $average && $average < $nextValue){
                                        $reviewPoint= $intAverage + 0.5;
                                        $halfReview=true;
                                    }
                                }
                            ?>

                            <?php if($reviewQty > 0): ?>
                                <p class="wsus__rating">
                                    <?php for($i = 1; $i <=5; $i++): ?>
                                        <?php if($i <= $reviewPoint): ?>
                                            <i class="fas fa-star"></i>
                                        <?php elseif($i> $reviewPoint ): ?>
                                            <?php if($halfReview==true): ?>
                                            <i class="fas fa-star-half-alt"></i>
                                                <?php
                                                    $halfReview=false
                                                ?>
                                            <?php else: ?>
                                            <i class="fal fa-star"></i>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                    <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                </p>
                            <?php endif; ?>

                            <?php if($reviewQty == 0): ?>
                                <p class="wsus__rating">
                                    <i class="fal fa-star"></i>
                                    <i class="fal fa-star"></i>
                                    <i class="fal fa-star"></i>
                                    <i class="fal fa-star"></i>
                                    <i class="fal fa-star"></i>
                                    <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                </p>
                            <?php endif; ?>

                            <?php
                                $variantPrice = 0;
                                $variants = $flashDealProduct->variants->where('status', 1);
                                if($variants->count() != 0){
                                    foreach ($variants as $variants_key => $variant) {
                                        if($variant->variantItems->where('status',1)->count() != 0){
                                            $item = $variant->variantItems->where('is_default',1)->first();
                                            if($item){
                                                $variantPrice += $item->price;
                                            }
                                        }
                                    }
                                }

                                $isCampaign = false;
                                $today = date('Y-m-d H:i:s');

                                $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $flashDealProduct->id])->first();
                                if($campaign){
                                    $campaign = $campaign->campaign;
                                    if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                        $isCampaign = true;
                                    }
                                    $campaignOffer = $campaign->offer;
                                    $productPrice = $flashDealProduct->price;
                                    $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                    $totalPrice = $productPrice;
                                    $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                }

                                $totalPrice = $flashDealProduct->price;
                                if($flashDealProduct->offer_price != null){
                                    $offerPrice = $flashDealProduct->offer_price;
                                    $offer = $totalPrice - $offerPrice;
                                    $percentage = ($offer * 100) / $totalPrice;
                                    $percentage = round($percentage);
                                }
                            ?>

                                <?php if($isCampaign): ?>
                                    <p class="wsus__hot_deals_proce"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f",$totalPrice)); ?></del></p>
                                <?php else: ?>
                                    <?php if($flashDealProduct->offer_price == null): ?>
                                    <p class="wsus__hot_deals_proce"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                    <?php else: ?>
                                    <p class="wsus__hot_deals_proce"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $flashDealProduct->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                    <?php endif; ?>
                                <?php endif; ?>

                            <P class="wsus__details">
                                <?php echo e($flashDealProduct->short_description); ?>

                            </P>
                            <ul>
                                <li><a class="add_cart" onclick="addToCartMainProduct('<?php echo e($flashDealProduct->id); ?>')" href="javascript:;"><?php echo e(__('user.add to cart')); ?></a></li>
                                <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($flashDealProduct->id); ?>')"><i class="far fa-heart"></i></a></li>
                                <li><a href="javascript:;" onclick="addToCompare('<?php echo e($flashDealProduct->id); ?>')"><i class="far fa-random"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
                <?php $__currentLoopData = $flashDealProducts->take($flashDealVisibility->qty); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flashDealProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <section class="product_popup_modal">
                        <div class="modal fade" id="productModalView-<?php echo e($flashDealProduct->id); ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                                class="far fa-times"></i></button>
                                        <div class="row">
                                            <div class="col-xl-6 col-12 col-sm-10 col-md-8 col-lg-6 m-auto display">
                                                <div class="wsus__quick_view_img">
                                                    <?php if($flashDealProduct->video_link): ?>
                                                        <?php
                                                            $video_id=explode("=",$flashDealProduct->video_link);
                                                        ?>
                                                        <a class="venobox wsus__pro_det_video" data-autoplay="true" data-vbtype="video"
                                                        href="https://youtu.be/<?php echo e($video_id[1]); ?>">
                                                        <i class="fas fa-play"></i>
                                                    </a>
                                                    <?php endif; ?>

                                                    <div class="row modal_slider">
                                                        <?php $__currentLoopData = $flashDealProduct->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-xl-12">
                                                            <div class="modal_slider_img">
                                                                <img src="<?php echo e(asset($image->image)); ?>" alt="product" class="img-fluid w-100">
                                                            </div>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-12 col-sm-12 col-md-12 col-lg-6">
                                                <div class="wsus__pro_details_text">
                                                    <a class="title" href="<?php echo e(route('product-detail', $flashDealProduct->slug)); ?>"><?php echo e($flashDealProduct->name); ?></a>

                                                        <?php if($flashDealProduct->qty == 0): ?>
                                                        <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.Out of Stock')); ?></span></p>
                                                        <?php else: ?>
                                                            <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.In stock')); ?>

                                                                <?php if($setting->show_product_qty == 1): ?>
                                                                    </span> (<?php echo e($flashDealProduct->qty); ?> <?php echo e(__('user.item')); ?>)
                                                                <?php endif; ?>
                                                            </p>
                                                        <?php endif; ?>


                                                    <?php
                                                        $reviewQty = $flashDealProduct->reviews->where('status',1)->count();
                                                        $totalReview = $flashDealProduct->reviews->where('status',1)->sum('rating');

                                                        if ($reviewQty > 0) {
                                                            $average = $totalReview / $reviewQty;

                                                            $intAverage = intval($average);

                                                            $nextValue = $intAverage + 1;
                                                            $reviewPoint = $intAverage;
                                                            $halfReview=false;
                                                            if($intAverage < $average && $average < $nextValue){
                                                                $reviewPoint= $intAverage + 0.5;
                                                                $halfReview=true;
                                                            }
                                                        }
                                                    ?>

                                                    <?php
                                                        $variantPrice = 0;
                                                        $variants = $flashDealProduct->variants->where('status', 1);
                                                        if($variants->count() != 0){
                                                            foreach ($variants as $variants_key => $variant) {
                                                                if($variant->variantItems->where('status',1)->count() != 0){
                                                                    $item = $variant->variantItems->where('is_default',1)->first();
                                                                    if($item){
                                                                        $variantPrice += $item->price;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        $isCampaign = false;
                                                        $today = date('Y-m-d H:i:s');
                                                        $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $flashDealProduct->id])->first();
                                                        if($campaign){
                                                            $campaign = $campaign->campaign;
                                                            if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                                $isCampaign = true;
                                                            }
                                                            $campaignOffer = $campaign->offer;
                                                            $productPrice = $flashDealProduct->price;
                                                            $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                            $totalPrice = $flashDealProduct->price;
                                                            $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                                        }

                                                        $totalPrice = $flashDealProduct->price;
                                                        if($flashDealProduct->offer_price != null){
                                                            $offerPrice = $flashDealProduct->offer_price;
                                                            $offer = $totalPrice - $offerPrice;
                                                            $percentage = ($offer * 100) / $totalPrice;
                                                            $percentage = round($percentage);
                                                        }


                                                    ?>

                                                    <?php if($isCampaign): ?>
                                                        <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductModalPrice-<?php echo e($flashDealProduct->id); ?>"><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?></span>  <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                    <?php else: ?>
                                                        <?php if($flashDealProduct->offer_price == null): ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($flashDealProduct->id); ?>"><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></span></h4>
                                                        <?php else: ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($flashDealProduct->id); ?>"><?php echo e(sprintf("%.2f", $flashDealProduct->offer_price + $variantPrice)); ?></span> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty > 0): ?>
                                                        <p class="review">
                                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                                <?php if($i <= $reviewPoint): ?>
                                                                    <i class="fas fa-star"></i>
                                                                <?php elseif($i> $reviewPoint ): ?>
                                                                    <?php if($halfReview==true): ?>
                                                                    <i class="fas fa-star-half-alt"></i>
                                                                        <?php
                                                                            $halfReview=false
                                                                        ?>
                                                                    <?php else: ?>
                                                                    <i class="fal fa-star"></i>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php endfor; ?>
                                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty == 0): ?>
                                                        <p class="review">
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php
                                                        $productPrice = 0;
                                                        if($isCampaign){
                                                            $productPrice = $campaignOfferPrice + $variantPrice;
                                                        }else{
                                                            if ($flashDealProduct->offer_price == null) {
                                                                $productPrice = $totalPrice + $variantPrice;
                                                            }else {
                                                                $productPrice = $flashDealProduct->offer_price + $variantPrice;
                                                            }
                                                        }
                                                    ?>
                                                    <form id="productModalFormId-<?php echo e($flashDealProduct->id); ?>">
                                                    <div class="wsus__quentity">
                                                        <h5><?php echo e(__('user.quantity')); ?> :</h5>
                                                        <div class="modal_btn">
                                                            <button onclick="productModalDecrement('<?php echo e($flashDealProduct->id); ?>')" type="button" class="btn btn-danger btn-sm">-</button>
                                                            <input id="productModalQty-<?php echo e($flashDealProduct->id); ?>" name="quantity"  readonly class="form-control" type="text" min="1" max="100" value="1" />
                                                            <button onclick="productModalIncrement('<?php echo e($flashDealProduct->id); ?>','<?php echo e($flashDealProduct->qty); ?>')" type="button" class="btn btn-success btn-sm">+</button>
                                                        </div>
                                                        <h3 class="d-none"><?php echo e($currencySetting->currency_icon); ?><span id="productModalPrice-<?php echo e($flashDealProduct->id); ?>"><?php echo e(sprintf("%.2f",$productPrice)); ?></span></h3>

                                                        <input type="hidden" name="product_id" value="<?php echo e($flashDealProduct->id); ?>">
                                                        <input type="hidden" name="image" value="<?php echo e($flashDealProduct->thumb_image); ?>">
                                                        <input type="hidden" name="slug" value="<?php echo e($flashDealProduct->slug); ?>">

                                                    </div>
                                                    <?php
                                                        $productVariants = App\Models\ProductVariant::where(['status' => 1, 'product_id'=> $flashDealProduct->id])->get();
                                                    ?>
                                                    <?php if($productVariants->count() != 0): ?>
                                                        <div class="wsus__selectbox">
                                                            <div class="row">
                                                                <?php $__currentLoopData = $productVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productVariant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $items = App\Models\ProductVariantItem::orderBy('is_default','desc')->where(['product_variant_id' => $productVariant->id, 'product_id' => $flashDealProduct->id])->get();
                                                                    ?>
                                                                    <?php if($items->count() != 0): ?>
                                                                        <div class="col-xl-6 col-sm-6 mb-3">
                                                                            <h5 class="mb-2"><?php echo e($productVariant->name); ?>:</h5>

                                                                            <input type="hidden" name="variants[]" value="<?php echo e($productVariant->id); ?>">
                                                                            <input type="hidden" name="variantNames[]" value="<?php echo e($productVariant->name); ?>">

                                                                            <select class="select_2 productModalVariant" name="items[]" data-product="<?php echo e($flashDealProduct->id); ?>">
                                                                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <ul class="wsus__button_area">
                                                        <li><button type="button" onclick="addToCartInProductModal('<?php echo e($flashDealProduct->id); ?>')" class="add_cart"><?php echo e(__('user.add to cart')); ?></button></li>
                                                        <li><a class="buy_now" href="javascript:;" onclick="addToBuyNow('<?php echo e($flashDealProduct->id); ?>')"><?php echo e(__('user.buy now')); ?></a></li>
                                                        <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($flashDealProduct->id); ?>')"><i class="fal fa-heart"></i></a></li>
                                                        <li><a href="javascript:;" onclick="addToCompare('<?php echo e($flashDealProduct->id); ?>')"><i class="far fa-random"></i></a></li>
                                                    </ul>
                                                </form>
                                                <?php if($flashDealProduct->sku): ?>
                                                <p class="brand_model"><span><?php echo e(__('user.Model')); ?> :</span> <?php echo e($flashDealProduct->sku); ?></p>
                                                <?php endif; ?>

                                                <p class="brand_model"><span><?php echo e(__('user.Brand')); ?> :</span> <a href="<?php echo e(route('product',['brand' => $flashDealProduct->brand->slug])); ?>"><?php echo e($flashDealProduct->brand->name); ?></a></p>
                                                <p class="brand_model"><span><?php echo e(__('user.Category')); ?> :</span> <a href="<?php echo e(route('product',['category' => $flashDealProduct->category->slug])); ?>"><?php echo e($flashDealProduct->category->name); ?></a></p>
                                                <div class="wsus__pro_det_share d-none">
                                                    <h5><?php echo e(__('user.share')); ?> :</h5>
                                                    <ul class="d-flex">
                                                        <li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('product-detail', $flashDealProduct->slug)); ?>&t=<?php echo e($flashDealProduct->name); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                                        <li><a class="twitter" href="https://twitter.com/share?text=<?php echo e($flashDealProduct->name); ?>&url=<?php echo e(route('product-detail', $flashDealProduct->slug)); ?>"><i class="fab fa-twitter"></i></a></li>
                                                        <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('product-detail', $flashDealProduct->slug)); ?>&title=<?php echo e($flashDealProduct->name); ?>"><i class="fab fa-linkedin"></i></a></li>
                                                        <li><a class="pinterest" href="https://www.pinterest.com/pin/create/button/?description=<?php echo e($flashDealProduct->name); ?>&media=&url=<?php echo e(route('product-detail', $flashDealProduct->slug)); ?>"><i class="fab fa-pinterest-p"></i></a></li>
                                                    </ul>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>


            <?php
                $productHighlightVisibility = $visibilities->where('id',7)->first();
            ?>
            <?php if($productHighlightVisibility->status == 1): ?>
            <div class="row">
            <div class="wsus__hot_large_item">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="wsus__section_header justify-content-md-center">
                            <div class="monthly_top_filter2">
                                <button class="active click_featured_product" data-filter="._featured"><?php echo e(__('user.Featured')); ?></button>
                                <button data-filter="._best"><?php echo e(__('user.Best Product')); ?></button>
                                <button data-filter="._top"><?php echo e(__('user.Top Rated')); ?></button>
                                <button data-filter="._new"><?php echo e(__('user.New')); ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row grid2">
                    <?php $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featuredProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php
                            $reviewQty = $featuredProduct->reviews->where('status',1)->count();
                            $totalReview = $featuredProduct->reviews->where('status',1)->sum('rating');

                            if ($reviewQty > 0) {
                                $average = $totalReview / $reviewQty;

                                $intAverage = intval($average);

                                $nextValue = $intAverage + 1;
                                $reviewPoint = $intAverage;
                                $halfReview=false;
                                if($intAverage < $average && $average < $nextValue){
                                    $reviewPoint= $intAverage + 0.5;
                                    $halfReview=true;
                                }
                            }
                        ?>

                        <?php
                            $variantPrice = 0;
                            $variants = $featuredProduct->variants->where('status', 1);
                            if($variants->count() != 0){
                                foreach ($variants as $variants_key => $variant) {
                                    if($variant->variantItems->where('status',1)->count() != 0){
                                        $item = $variant->variantItems->where('is_default',1)->first();
                                        if($item){
                                            $variantPrice += $item->price;
                                        }
                                    }
                                }
                            }

                            $isCampaign = false;
                            $today = date('Y-m-d H:i:s');

                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $featuredProduct->id])->first();
                            if($campaign){
                                $campaign = $campaign->campaign;
                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                    $isCampaign = true;
                                }
                                $campaignOffer = $campaign->offer;
                                $productPrice = $featuredProduct->price;
                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                $totalPrice = $productPrice;
                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                            }

                            $totalPrice = $featuredProduct->price;
                            if($featuredProduct->offer_price != null){
                                $offerPrice = $featuredProduct->offer_price;
                                $offer = $totalPrice - $offerPrice;
                                $percentage = ($offer * 100) / $totalPrice;
                                $percentage = round($percentage);
                            }
                        ?>
                        <div class="col-xl-3 col-sm-6 col-md-6 col-lg-4 _featured">
                            <div class="wsus__product_item">
                                <?php if($featuredProduct->new_product == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.New')); ?></span>
                                <?php elseif($featuredProduct->is_featured == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Featured')); ?></span>
                                <?php elseif($featuredProduct->is_top == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Top')); ?></span>
                                <?php elseif($featuredProduct->is_best == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Best')); ?></span>
                                <?php endif; ?>

                                <?php if($isCampaign): ?>
                                    <span class="wsus__minus">-<?php echo e($campaignOffer); ?>%</span>
                                <?php else: ?>
                                    <?php if($featuredProduct->offer_price != null): ?>
                                        <span class="wsus__minus">-<?php echo e($percentage); ?>%</span>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <a class="wsus__pro_link" href="<?php echo e(route('product-detail', $featuredProduct->slug)); ?>">
                                    <img src="<?php echo e(asset($featuredProduct->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_1" />
                                    <img src="<?php echo e(asset($featuredProduct->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_2" />
                                </a>


                                <ul class="wsus__single_pro_icon">
                                    <li><a data-bs-toggle="modal" data-bs-target="#productModalView-<?php echo e($featuredProduct->id); ?>"><i class="fal fa-eye"></i></a></li>
                                    <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($featuredProduct->id); ?>')"><i class="far fa-heart"></i></a></li>
                                    <li><a href="javascript:;" onclick="addToCompare('<?php echo e($featuredProduct->id); ?>')"><i class="far fa-random"></i></a></li>
                                </ul>
                                <div class="wsus__product_details">
                                    <a class="wsus__category" href="<?php echo e(route('product',['category' => $featuredProduct->category->slug])); ?>"><?php echo e($featuredProduct->category->name); ?> </a>

                                    <?php if($reviewQty > 0): ?>
                                        <p class="wsus__pro_rating">
                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                <?php if($i <= $reviewPoint): ?>
                                                    <i class="fas fa-star"></i>
                                                <?php elseif($i> $reviewPoint ): ?>
                                                    <?php if($halfReview==true): ?>
                                                    <i class="fas fa-star-half-alt"></i>
                                                        <?php
                                                            $halfReview=false
                                                        ?>
                                                    <?php else: ?>
                                                    <i class="fal fa-star"></i>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                    <?php endif; ?>

                                    <?php if($reviewQty == 0): ?>
                                        <p class="wsus__pro_rating">
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                    <?php endif; ?>

                                    <a class="wsus__pro_name" href="<?php echo e(route('product-detail', $featuredProduct->slug)); ?>"><?php echo e($featuredProduct->short_name); ?></a>
                                    <?php if($isCampaign): ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f",$totalPrice)); ?></del></p>
                                    <?php else: ?>
                                        <?php if($featuredProduct->offer_price == null): ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                        <?php else: ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $featuredProduct->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <a class="add_cart" onclick="addToCartMainProduct('<?php echo e($featuredProduct->id); ?>')" href="javascript:;"><?php echo e(__('user.add to cart')); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php $__currentLoopData = $bestProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bestProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $reviewQty = $bestProduct->reviews->where('status',1)->count();
                            $totalReview = $bestProduct->reviews->where('status',1)->sum('rating');

                            if ($reviewQty > 0) {
                                $average = $totalReview / $reviewQty;

                                $intAverage = intval($average);

                                $nextValue = $intAverage + 1;
                                $reviewPoint = $intAverage;
                                $halfReview=false;
                                if($intAverage < $average && $average < $nextValue){
                                    $reviewPoint= $intAverage + 0.5;
                                    $halfReview=true;
                                }
                            }
                        ?>

                        <?php
                            $variantPrice = 0;
                            $variants = $bestProduct->variants->where('status', 1);
                            if($variants->count() != 0){
                                foreach ($variants as $variants_key => $variant) {
                                    if($variant->variantItems->where('status',1)->count() != 0){
                                        $item = $variant->variantItems->where('is_default',1)->first();
                                        if($item){
                                            $variantPrice += $item->price;
                                        }
                                    }
                                }
                            }

                            $isCampaign = false;
                            $today = date('Y-m-d H:i:s');

                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $bestProduct->id])->first();
                            if($campaign){
                                $campaign = $campaign->campaign;
                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                    $isCampaign = true;
                                }
                                $campaignOffer = $campaign->offer;
                                $productPrice = $bestProduct->price;
                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                $totalPrice = $productPrice;
                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                            }

                            $totalPrice = $bestProduct->price;
                            if($bestProduct->offer_price != null){
                                $offerPrice = $bestProduct->offer_price;
                                $offer = $totalPrice - $offerPrice;
                                $percentage = ($offer * 100) / $totalPrice;
                                $percentage = round($percentage);
                            }
                        ?>
                        <div class="col-xl-3 col-sm-6 col-md-6 col-lg-4 _best">
                            <div class="wsus__product_item">
                                <?php if($bestProduct->new_product == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.New')); ?></span>
                                <?php elseif($bestProduct->is_featured == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Featured')); ?></span>
                                <?php elseif($bestProduct->is_top == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Top')); ?></span>
                                <?php elseif($bestProduct->is_best == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Best')); ?></span>
                                <?php endif; ?>
                                <?php if($isCampaign): ?>
                                    <span class="wsus__minus">-<?php echo e($campaignOffer); ?>%</span>
                                <?php else: ?>
                                    <?php if($bestProduct->offer_price != null): ?>
                                        <span class="wsus__minus">-<?php echo e($percentage); ?>%</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <a class="wsus__pro_link" href="<?php echo e(route('product-detail', $bestProduct->slug)); ?>">
                                    <img src="<?php echo e(asset($bestProduct->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_1" />
                                    <img src="<?php echo e(asset($bestProduct->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_2" />
                                </a>
                                <?php
                                    $reviewQty = $bestProduct->reviews->where('status',1)->count();
                                    $totalReview = $bestProduct->reviews->where('status',1)->sum('rating');

                                    if ($reviewQty > 0) {
                                        $average = $totalReview / $reviewQty;

                                        $intAverage = intval($average);

                                        $nextValue = $intAverage + 1;
                                        $reviewPoint = $intAverage;
                                        $halfReview=false;
                                        if($intAverage < $average && $average < $nextValue){
                                            $reviewPoint= $intAverage + 0.5;
                                            $halfReview=true;
                                        }
                                    }
                                ?>

                                <?php
                                    $variantPrice = 0;
                                    $variants = $bestProduct->variants->where('status', 1);
                                    if($variants->count() != 0){
                                        foreach ($variants as $variants_key => $variant) {
                                            if($variant->variantItems->where('status',1)->count() != 0){
                                                $item = $variant->variantItems->where('is_default',1)->first();
                                                if($item){
                                                    $variantPrice += $item->price;
                                                }
                                            }
                                        }
                                    }

                                    $isCampaign = false;
                                    $today = date('Y-m-d H:i:s');

                                    $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $bestProduct->id])->first();
                                    if($campaign){
                                        $campaign = $campaign->campaign;
                                        if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                            $isCampaign = true;
                                        }
                                        $campaignOffer = $campaign->offer;
                                        $productPrice = $bestProduct->price;
                                        $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                        $totalPrice = $productPrice;
                                        $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                    }

                                    $totalPrice = $bestProduct->price;
                                    if($bestProduct->offer_price != null){
                                        $offerPrice = $bestProduct->offer_price;
                                        $offer = $totalPrice - $offerPrice;
                                        $percentage = ($offer * 100) / $totalPrice;
                                        $percentage = round($percentage);
                                    }
                                ?>

                                <ul class="wsus__single_pro_icon">
                                    <li><a data-bs-toggle="modal" data-bs-target="#productModalView-<?php echo e($bestProduct->id); ?>"><i class="fal fa-eye"></i></a></li>
                                    <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($bestProduct->id); ?>')"><i class="far fa-heart"></i></a></li>
                                    <li><a href="javascript:;" onclick="addToCompare('<?php echo e($bestProduct->id); ?>')"><i class="far fa-random"></i></a></li>
                                </ul>
                                <div class="wsus__product_details">
                                    <a class="wsus__category" href="<?php echo e(route('product',['category' => $bestProduct->category->slug])); ?>"><?php echo e($bestProduct->category->name); ?> </a>

                                    <?php if($reviewQty > 0): ?>
                                        <p class="wsus__pro_rating">
                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                <?php if($i <= $reviewPoint): ?>
                                                    <i class="fas fa-star"></i>
                                                <?php elseif($i> $reviewPoint ): ?>
                                                    <?php if($halfReview==true): ?>
                                                    <i class="fas fa-star-half-alt"></i>
                                                        <?php
                                                            $halfReview=false
                                                        ?>
                                                    <?php else: ?>
                                                    <i class="fal fa-star"></i>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                    <?php endif; ?>

                                    <?php if($reviewQty == 0): ?>
                                        <p class="wsus__pro_rating">
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                    <?php endif; ?>

                                    <a class="wsus__pro_name" href="<?php echo e(route('product-detail', $bestProduct->slug)); ?>"><?php echo e($bestProduct->short_name); ?></a>
                                    <?php if($isCampaign): ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f",$totalPrice)); ?></del></p>
                                    <?php else: ?>
                                        <?php if($bestProduct->offer_price == null): ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                        <?php else: ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $bestProduct->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <a class="add_cart" onclick="addToCartMainProduct('<?php echo e($bestProduct->id); ?>')" href="javascript:;"><?php echo e(__('user.add to cart')); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $reviewQty = $topProduct->reviews->where('status',1)->count();
                            $totalReview = $topProduct->reviews->where('status',1)->sum('rating');

                            if ($reviewQty > 0) {
                                $average = $totalReview / $reviewQty;

                                $intAverage = intval($average);

                                $nextValue = $intAverage + 1;
                                $reviewPoint = $intAverage;
                                $halfReview=false;
                                if($intAverage < $average && $average < $nextValue){
                                    $reviewPoint= $intAverage + 0.5;
                                    $halfReview=true;
                                }
                            }
                        ?>

                        <?php
                            $variantPrice = 0;
                            $variants = $topProduct->variants->where('status', 1);
                            if($variants->count() != 0){
                                foreach ($variants as $variants_key => $variant) {
                                    if($variant->variantItems->where('status',1)->count() != 0){
                                        $item = $variant->variantItems->where('is_default',1)->first();
                                        if($item){
                                            $variantPrice += $item->price;
                                        }
                                    }
                                }
                            }

                            $isCampaign = false;
                            $today = date('Y-m-d H:i:s');

                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $topProduct->id])->first();
                            if($campaign){
                                $campaign = $campaign->campaign;
                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                    $isCampaign = true;
                                }
                                $campaignOffer = $campaign->offer;
                                $productPrice = $topProduct->price;
                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                $totalPrice = $productPrice;
                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                            }

                            $totalPrice = $topProduct->price;
                            if($topProduct->offer_price != null){
                                $offerPrice = $topProduct->offer_price;
                                $offer = $totalPrice - $offerPrice;
                                $percentage = ($offer * 100) / $totalPrice;
                                $percentage = round($percentage);
                            }
                        ?>

                        <div class="col-xl-3 col-sm-6 col-md-6 col-lg-4 _top">
                            <div class="wsus__product_item ">
                                <?php if($topProduct->new_product == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.New')); ?></span>
                                <?php elseif($topProduct->is_featured == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Featured')); ?></span>
                                <?php elseif($topProduct->is_top == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Top')); ?></span>
                                <?php elseif($topProduct->is_best == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Best')); ?></span>
                                <?php endif; ?>

                                <?php if($isCampaign): ?>
                                    <span class="wsus__minus">-<?php echo e($campaignOffer); ?>%</span>
                                <?php else: ?>
                                    <?php if($topProduct->offer_price != null): ?>
                                        <span class="wsus__minus">-<?php echo e($percentage); ?>%</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <a class="wsus__pro_link" href="<?php echo e(route('product-detail', $topProduct->slug)); ?>">
                                    <img src="<?php echo e(asset($topProduct->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_1" />
                                    <img src="<?php echo e(asset($topProduct->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_2" />
                                </a>


                                <ul class="wsus__single_pro_icon">
                                    <li><a data-bs-toggle="modal" data-bs-target="#productModalView-<?php echo e($topProduct->id); ?>"><i class="fal fa-eye"></i></a></li>
                                    <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($topProduct->id); ?>')"><i class="far fa-heart"></i></a></li>
                                    <li><a href="javascript:;" onclick="addToCompare('<?php echo e($topProduct->id); ?>')"><i class="far fa-random"></i></a>
                                    </li>
                                </ul>
                                <div class="wsus__product_details">
                                    <a class="wsus__category" href="<?php echo e(route('product',['category' => $topProduct->category->slug])); ?>"><?php echo e($topProduct->category->name); ?> </a>

                                    <?php if($reviewQty > 0): ?>
                                        <p class="wsus__pro_rating">
                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                <?php if($i <= $reviewPoint): ?>
                                                    <i class="fas fa-star"></i>
                                                <?php elseif($i> $reviewPoint ): ?>
                                                    <?php if($halfReview==true): ?>
                                                    <i class="fas fa-star-half-alt"></i>
                                                        <?php
                                                            $halfReview=false
                                                        ?>
                                                    <?php else: ?>
                                                    <i class="fal fa-star"></i>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                    <?php endif; ?>

                                    <?php if($reviewQty == 0): ?>
                                        <p class="wsus__pro_rating">
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                    <?php endif; ?>

                                    <a class="wsus__pro_name" href="<?php echo e(route('product-detail', $topProduct->slug)); ?>"><?php echo e($topProduct->short_name); ?></a>
                                    <?php if($isCampaign): ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f",$totalPrice)); ?></del></p>
                                    <?php else: ?>
                                        <?php if($topProduct->offer_price == null): ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                        <?php else: ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $topProduct->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <a class="add_cart" onclick="addToCartMainProduct('<?php echo e($topProduct->id); ?>')" href="javascript:;"><?php echo e(__('user.add to cart')); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php $__currentLoopData = $newProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $newProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $reviewQty = $newProduct->reviews->where('status',1)->count();
                            $totalReview = $newProduct->reviews->where('status',1)->sum('rating');

                            if ($reviewQty > 0) {
                                $average = $totalReview / $reviewQty;

                                $intAverage = intval($average);

                                $nextValue = $intAverage + 1;
                                $reviewPoint = $intAverage;
                                $halfReview=false;
                                if($intAverage < $average && $average < $nextValue){
                                    $reviewPoint= $intAverage + 0.5;
                                    $halfReview=true;
                                }
                            }
                        ?>

                        <?php
                            $variantPrice = 0;
                            $variants = $newProduct->variants->where('status', 1);
                            if($variants->count() != 0){
                                foreach ($variants as $variants_key => $variant) {
                                    if($variant->variantItems->where('status',1)->count() != 0){
                                        $item = $variant->variantItems->where('is_default',1)->first();
                                        if($item){
                                            $variantPrice += $item->price;
                                        }
                                    }
                                }
                            }

                            $isCampaign = false;
                            $today = date('Y-m-d H:i:s');

                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $newProduct->id])->first();
                            if($campaign){
                                $campaign = $campaign->campaign;
                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                    $isCampaign = true;
                                }
                                $campaignOffer = $campaign->offer;
                                $productPrice = $newProduct->price;
                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                $totalPrice = $productPrice;
                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                            }

                            $totalPrice = $newProduct->price;
                            if($newProduct->offer_price != null){
                                $offerPrice = $newProduct->offer_price;
                                $offer = $totalPrice - $offerPrice;
                                $percentage = ($offer * 100) / $totalPrice;
                                $percentage = round($percentage);
                            }
                        ?>
                        <div class="col-xl-3 col-sm-6 col-md-6 col-lg-4 _new">
                            <div class="wsus__product_item wsus__after">
                                <?php if($newProduct->new_product == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.New')); ?></span>
                                <?php elseif($newProduct->is_featured == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Featured')); ?></span>
                                <?php elseif($newProduct->is_top == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Top')); ?></span>
                                <?php elseif($newProduct->is_best == 1): ?>
                                    <span class="wsus__new"><?php echo e(__('user.Best')); ?></span>
                                <?php endif; ?>

                                <?php if($isCampaign): ?>
                                    <span class="wsus__minus">-<?php echo e($campaignOffer); ?>%</span>
                                <?php else: ?>
                                    <?php if($newProduct->offer_price != null): ?>
                                        <span class="wsus__minus">-<?php echo e($percentage); ?>%</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <a class="wsus__pro_link" href="<?php echo e(route('product-detail', $newProduct->slug)); ?>">
                                    <img src="<?php echo e(asset($newProduct->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_1" />
                                    <img src="<?php echo e(asset($newProduct->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_2" />
                                </a>

                                <ul class="wsus__single_pro_icon">
                                    <li><a data-bs-toggle="modal" data-bs-target="#productModalView-<?php echo e($newProduct->id); ?>"><i class="fal fa-eye"></i></a></li>
                                    <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($newProduct->id); ?>')"><i class="far fa-heart"></i></a></li>
                                    <li><a href="javascript:;" onclick="addToCompare('<?php echo e($newProduct->id); ?>')"><i class="far fa-random"></i></a>
                                    </li>
                                </ul>
                                <div class="wsus__product_details">
                                    <a class="wsus__category" href="<?php echo e(route('product',['category' => $newProduct->category->slug])); ?>"><?php echo e($newProduct->category->name); ?> </a>

                                    <?php if($reviewQty > 0): ?>
                                        <p class="wsus__pro_rating">
                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                <?php if($i <= $reviewPoint): ?>
                                                    <i class="fas fa-star"></i>
                                                <?php elseif($i> $reviewPoint ): ?>
                                                    <?php if($halfReview==true): ?>
                                                    <i class="fas fa-star-half-alt"></i>
                                                        <?php
                                                            $halfReview=false
                                                        ?>
                                                    <?php else: ?>
                                                    <i class="fal fa-star"></i>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                    <?php endif; ?>

                                    <?php if($reviewQty == 0): ?>
                                        <p class="wsus__pro_rating">
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <i class="fal fa-star"></i>
                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                    <?php endif; ?>

                                    <a class="wsus__pro_name" href="<?php echo e(route('product-detail', $newProduct->slug)); ?>"><?php echo e($newProduct->short_name); ?></a>
                                    <?php if($isCampaign): ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f",$totalPrice)); ?></del></p>
                                    <?php else: ?>
                                        <?php if($newProduct->offer_price == null): ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                        <?php else: ?>
                                        <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $newProduct->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <a class="add_cart" onclick="addToCartMainProduct('<?php echo e($newProduct->id); ?>')" href="javascript:;"><?php echo e(__('user.add to cart')); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <?php $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featuredProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <section class="product_popup_modal">
                        <div class="modal fade" id="productModalView-<?php echo e($featuredProduct->id); ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                                class="far fa-times"></i></button>
                                        <div class="row">
                                            <div class="col-xl-6 col-12 col-sm-10 col-md-8 col-lg-6 m-auto display">
                                                <div class="wsus__quick_view_img">
                                                    <?php if($featuredProduct->video_link): ?>
                                                        <?php
                                                            $video_id=explode("=",$featuredProduct->video_link);
                                                        ?>
                                                        <a class="venobox wsus__pro_det_video" data-autoplay="true" data-vbtype="video"
                                                        href="https://youtu.be/<?php echo e($video_id[1]); ?>">
                                                        <i class="fas fa-play"></i>
                                                    </a>
                                                    <?php endif; ?>

                                                    <div class="row modal_slider">
                                                        <?php $__currentLoopData = $featuredProduct->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-xl-12">
                                                            <div class="modal_slider_img">
                                                                <img src="<?php echo e(asset($image->image)); ?>" alt="product" class="img-fluid w-100">
                                                            </div>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-12 col-sm-12 col-md-12 col-lg-6">
                                                <div class="wsus__pro_details_text">
                                                    <a class="title" href="<?php echo e(route('product-detail', $featuredProduct->slug)); ?>"><?php echo e($featuredProduct->name); ?></a>

                                                        <?php if($featuredProduct->qty == 0): ?>
                                                        <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.Out of Stock')); ?></span></p>
                                                        <?php else: ?>
                                                            <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.In stock')); ?>

                                                                <?php if($setting->show_product_qty == 1): ?>
                                                                    </span> (<?php echo e($featuredProduct->qty); ?> <?php echo e(__('user.item')); ?>)
                                                                <?php endif; ?>
                                                            </p>
                                                        <?php endif; ?>


                                                    <?php
                                                        $reviewQty = $featuredProduct->reviews->where('status',1)->count();
                                                        $totalReview = $featuredProduct->reviews->where('status',1)->sum('rating');

                                                        if ($reviewQty > 0) {
                                                            $average = $totalReview / $reviewQty;

                                                            $intAverage = intval($average);

                                                            $nextValue = $intAverage + 1;
                                                            $reviewPoint = $intAverage;
                                                            $halfReview=false;
                                                            if($intAverage < $average && $average < $nextValue){
                                                                $reviewPoint= $intAverage + 0.5;
                                                                $halfReview=true;
                                                            }
                                                        }
                                                    ?>

                                                    <?php
                                                        $variantPrice = 0;
                                                        $variants = $featuredProduct->variants->where('status', 1);
                                                        if($variants->count() != 0){
                                                            foreach ($variants as $variants_key => $variant) {
                                                                if($variant->variantItems->where('status',1)->count() != 0){
                                                                    $item = $variant->variantItems->where('is_default',1)->first();
                                                                    if($item){
                                                                        $variantPrice += $item->price;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        $isCampaign = false;
                                                        $today = date('Y-m-d H:i:s');
                                                        $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $featuredProduct->id])->first();
                                                        if($campaign){
                                                            $campaign = $campaign->campaign;
                                                            if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                                $isCampaign = true;
                                                            }
                                                            $campaignOffer = $campaign->offer;
                                                            $productPrice = $featuredProduct->price;
                                                            $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                            $totalPrice = $featuredProduct->price;
                                                            $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                                        }

                                                        $totalPrice = $featuredProduct->price;
                                                        if($featuredProduct->offer_price != null){
                                                            $offerPrice = $featuredProduct->offer_price;
                                                            $offer = $totalPrice - $offerPrice;
                                                            $percentage = ($offer * 100) / $totalPrice;
                                                            $percentage = round($percentage);
                                                        }


                                                    ?>

                                                    <?php if($isCampaign): ?>
                                                        <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductModalPrice-<?php echo e($featuredProduct->id); ?>"><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?></span>  <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                    <?php else: ?>
                                                        <?php if($featuredProduct->offer_price == null): ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($featuredProduct->id); ?>"><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></span></h4>
                                                        <?php else: ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($featuredProduct->id); ?>"><?php echo e(sprintf("%.2f", $featuredProduct->offer_price + $variantPrice)); ?></span> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty > 0): ?>
                                                        <p class="review">
                                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                                <?php if($i <= $reviewPoint): ?>
                                                                    <i class="fas fa-star"></i>
                                                                <?php elseif($i> $reviewPoint ): ?>
                                                                    <?php if($halfReview==true): ?>
                                                                    <i class="fas fa-star-half-alt"></i>
                                                                        <?php
                                                                            $halfReview=false
                                                                        ?>
                                                                    <?php else: ?>
                                                                    <i class="fal fa-star"></i>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php endfor; ?>
                                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty == 0): ?>
                                                        <p class="review">
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php
                                                        $productPrice = 0;
                                                        if($isCampaign){
                                                            $productPrice = $campaignOfferPrice + $variantPrice;
                                                        }else{
                                                            if ($featuredProduct->offer_price == null) {
                                                                $productPrice = $totalPrice + $variantPrice;
                                                            }else {
                                                                $productPrice = $featuredProduct->offer_price + $variantPrice;
                                                            }
                                                        }
                                                    ?>
                                                    <form id="productModalFormId-<?php echo e($featuredProduct->id); ?>">
                                                    <div class="wsus__quentity">
                                                        <h5><?php echo e(__('user.quantity')); ?> :</h5>
                                                        <div class="modal_btn">
                                                            <button onclick="productModalDecrement('<?php echo e($featuredProduct->id); ?>')" type="button" class="btn btn-danger btn-sm">-</button>
                                                            <input id="productModalQty-<?php echo e($featuredProduct->id); ?>" name="quantity"  readonly class="form-control" type="text" min="1" max="100" value="1" />
                                                            <button onclick="productModalIncrement('<?php echo e($featuredProduct->id); ?>','<?php echo e($featuredProduct->qty); ?>')" type="button" class="btn btn-success btn-sm">+</button>
                                                        </div>
                                                        <h3 class="d-none"><?php echo e($currencySetting->currency_icon); ?><span id="productModalPrice-<?php echo e($featuredProduct->id); ?>"><?php echo e(sprintf("%.2f",$productPrice)); ?></span></h3>

                                                        <input type="hidden" name="product_id" value="<?php echo e($featuredProduct->id); ?>">
                                                        <input type="hidden" name="image" value="<?php echo e($featuredProduct->thumb_image); ?>">
                                                        <input type="hidden" name="slug" value="<?php echo e($featuredProduct->slug); ?>">

                                                    </div>
                                                    <?php
                                                        $productVariants = App\Models\ProductVariant::where(['status' => 1, 'product_id'=> $featuredProduct->id])->get();
                                                    ?>
                                                    <?php if($productVariants->count() != 0): ?>
                                                        <div class="wsus__selectbox">
                                                            <div class="row">
                                                                <?php $__currentLoopData = $productVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productVariant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $items = App\Models\ProductVariantItem::orderBy('is_default','desc')->where(['product_variant_id' => $productVariant->id, 'product_id' => $featuredProduct->id])->get();
                                                                    ?>
                                                                    <?php if($items->count() != 0): ?>
                                                                        <div class="col-xl-6 col-sm-6 mb-3">
                                                                            <h5 class="mb-2"><?php echo e($productVariant->name); ?>:</h5>

                                                                            <input type="hidden" name="variants[]" value="<?php echo e($productVariant->id); ?>">
                                                                            <input type="hidden" name="variantNames[]" value="<?php echo e($productVariant->name); ?>">

                                                                            <select class="select_2 productModalVariant" name="items[]" data-product="<?php echo e($featuredProduct->id); ?>">
                                                                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <ul class="wsus__button_area">
                                                        <li><button type="button" onclick="addToCartInProductModal('<?php echo e($featuredProduct->id); ?>')" class="add_cart"><?php echo e(__('user.add to cart')); ?></button></li>
                                                        <li><a class="buy_now" href="javascript:;" onclick="addToBuyNow('<?php echo e($featuredProduct->id); ?>')"><?php echo e(__('user.buy now')); ?></a></li>
                                                        <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($featuredProduct->id); ?>')"><i class="fal fa-heart"></i></a></li>
                                                        <li><a href="javascript:;" onclick="addToCompare('<?php echo e($featuredProduct->id); ?>')"><i class="far fa-random"></i></a></li>
                                                    </ul>
                                                </form>
                                                <?php if($featuredProduct->sku): ?>
                                                <p class="brand_model"><span><?php echo e(__('user.Model')); ?> :</span> <?php echo e($featuredProduct->sku); ?></p>
                                                <?php endif; ?>

                                                <p class="brand_model"><span><?php echo e(__('user.Brand')); ?> :</span> <a href="<?php echo e(route('product',['brand' => $featuredProduct->brand->slug])); ?>"><?php echo e($featuredProduct->brand->name); ?></a></p>
                                                <p class="brand_model"><span><?php echo e(__('user.Category')); ?> :</span> <a href="<?php echo e(route('product',['category' => $featuredProduct->category->slug])); ?>"><?php echo e($featuredProduct->category->name); ?></a></p>
                                                <div class="wsus__pro_det_share d-none">
                                                    <h5><?php echo e(__('user.share')); ?> :</h5>
                                                    <ul class="d-flex">
                                                        <li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('product-detail', $featuredProduct->slug)); ?>&t=<?php echo e($featuredProduct->name); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                                        <li><a class="twitter" href="https://twitter.com/share?text=<?php echo e($featuredProduct->name); ?>&url=<?php echo e(route('product-detail', $featuredProduct->slug)); ?>"><i class="fab fa-twitter"></i></a></li>
                                                        <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('product-detail', $featuredProduct->slug)); ?>&title=<?php echo e($featuredProduct->name); ?>"><i class="fab fa-linkedin"></i></a></li>
                                                        <li><a class="pinterest" href="https://www.pinterest.com/pin/create/button/?description=<?php echo e($featuredProduct->name); ?>&media=&url=<?php echo e(route('product-detail', $featuredProduct->slug)); ?>"><i class="fab fa-pinterest-p"></i></a></li>
                                                    </ul>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php $__currentLoopData = $bestProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bestProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <section class="product_popup_modal">
                        <div class="modal fade" id="productModalView-<?php echo e($bestProduct->id); ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                                class="far fa-times"></i></button>
                                        <div class="row">
                                            <div class="col-xl-6 col-12 col-sm-10 col-md-8 col-lg-6 m-auto display">
                                                <div class="wsus__quick_view_img">
                                                    <?php if($bestProduct->video_link): ?>
                                                        <?php
                                                            $video_id=explode("=",$bestProduct->video_link);
                                                        ?>
                                                        <a class="venobox wsus__pro_det_video" data-autoplay="true" data-vbtype="video"
                                                        href="https://youtu.be/<?php echo e($video_id[1]); ?>">
                                                        <i class="fas fa-play"></i>
                                                    </a>
                                                    <?php endif; ?>

                                                    <div class="row modal_slider">
                                                        <?php $__currentLoopData = $bestProduct->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-xl-12">
                                                            <div class="modal_slider_img">
                                                                <img src="<?php echo e(asset($image->image)); ?>" alt="product" class="img-fluid w-100">
                                                            </div>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-12 col-sm-12 col-md-12 col-lg-6">
                                                <div class="wsus__pro_details_text">
                                                    <a class="title" href="<?php echo e(route('product-detail', $bestProduct->slug)); ?>"><?php echo e($bestProduct->name); ?></a>

                                                        <?php if($bestProduct->qty == 0): ?>
                                                        <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.Out of Stock')); ?></span></p>
                                                        <?php else: ?>
                                                            <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.In stock')); ?>

                                                                <?php if($setting->show_product_qty == 1): ?>
                                                                    </span> (<?php echo e($bestProduct->qty); ?> <?php echo e(__('user.item')); ?>)
                                                                <?php endif; ?>
                                                            </p>
                                                        <?php endif; ?>


                                                    <?php
                                                        $reviewQty = $bestProduct->reviews->where('status',1)->count();
                                                        $totalReview = $bestProduct->reviews->where('status',1)->sum('rating');

                                                        if ($reviewQty > 0) {
                                                            $average = $totalReview / $reviewQty;

                                                            $intAverage = intval($average);

                                                            $nextValue = $intAverage + 1;
                                                            $reviewPoint = $intAverage;
                                                            $halfReview=false;
                                                            if($intAverage < $average && $average < $nextValue){
                                                                $reviewPoint= $intAverage + 0.5;
                                                                $halfReview=true;
                                                            }
                                                        }
                                                    ?>

                                                    <?php
                                                        $variantPrice = 0;
                                                        $variants = $bestProduct->variants->where('status', 1);
                                                        if($variants->count() != 0){
                                                            foreach ($variants as $variants_key => $variant) {
                                                                if($variant->variantItems->where('status',1)->count() != 0){
                                                                    $item = $variant->variantItems->where('is_default',1)->first();
                                                                    if($item){
                                                                        $variantPrice += $item->price;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        $isCampaign = false;
                                                        $today = date('Y-m-d H:i:s');
                                                        $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $bestProduct->id])->first();
                                                        if($campaign){
                                                            $campaign = $campaign->campaign;
                                                            if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                                $isCampaign = true;
                                                            }
                                                            $campaignOffer = $campaign->offer;
                                                            $productPrice = $bestProduct->price;
                                                            $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                            $totalPrice = $bestProduct->price;
                                                            $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                                        }

                                                        $totalPrice = $bestProduct->price;
                                                        if($bestProduct->offer_price != null){
                                                            $offerPrice = $bestProduct->offer_price;
                                                            $offer = $totalPrice - $offerPrice;
                                                            $percentage = ($offer * 100) / $totalPrice;
                                                            $percentage = round($percentage);
                                                        }


                                                    ?>

                                                    <?php if($isCampaign): ?>
                                                        <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductModalPrice-<?php echo e($bestProduct->id); ?>"><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?></span>  <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                    <?php else: ?>
                                                        <?php if($bestProduct->offer_price == null): ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($bestProduct->id); ?>"><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></span></h4>
                                                        <?php else: ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($bestProduct->id); ?>"><?php echo e(sprintf("%.2f", $bestProduct->offer_price + $variantPrice)); ?></span> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty > 0): ?>
                                                        <p class="review">
                                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                                <?php if($i <= $reviewPoint): ?>
                                                                    <i class="fas fa-star"></i>
                                                                <?php elseif($i> $reviewPoint ): ?>
                                                                    <?php if($halfReview==true): ?>
                                                                    <i class="fas fa-star-half-alt"></i>
                                                                        <?php
                                                                            $halfReview=false
                                                                        ?>
                                                                    <?php else: ?>
                                                                    <i class="fal fa-star"></i>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php endfor; ?>
                                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty == 0): ?>
                                                        <p class="review">
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php
                                                        $productPrice = 0;
                                                        if($isCampaign){
                                                            $productPrice = $campaignOfferPrice + $variantPrice;
                                                        }else{
                                                            if ($bestProduct->offer_price == null) {
                                                                $productPrice = $totalPrice + $variantPrice;
                                                            }else {
                                                                $productPrice = $bestProduct->offer_price + $variantPrice;
                                                            }
                                                        }
                                                    ?>
                                                    <form id="productModalFormId-<?php echo e($bestProduct->id); ?>">
                                                    <div class="wsus__quentity">
                                                        <h5><?php echo e(__('user.quantity')); ?> :</h5>
                                                        <div class="modal_btn">
                                                            <button onclick="productModalDecrement('<?php echo e($bestProduct->id); ?>')" type="button" class="btn btn-danger btn-sm">-</button>
                                                            <input id="productModalQty-<?php echo e($bestProduct->id); ?>" name="quantity"  readonly class="form-control" type="text" min="1" max="100" value="1" />
                                                            <button onclick="productModalIncrement('<?php echo e($bestProduct->id); ?>','<?php echo e($bestProduct->qty); ?>')" type="button" class="btn btn-success btn-sm">+</button>
                                                        </div>
                                                        <h3 class="d-none"><?php echo e($currencySetting->currency_icon); ?><span id="productModalPrice-<?php echo e($bestProduct->id); ?>"><?php echo e(sprintf("%.2f",$productPrice)); ?></span></h3>

                                                        <input type="hidden" name="product_id" value="<?php echo e($bestProduct->id); ?>">
                                                        <input type="hidden" name="image" value="<?php echo e($bestProduct->thumb_image); ?>">
                                                        <input type="hidden" name="slug" value="<?php echo e($bestProduct->slug); ?>">

                                                    </div>
                                                    <?php
                                                        $productVariants = App\Models\ProductVariant::where(['status' => 1, 'product_id'=> $bestProduct->id])->get();
                                                    ?>
                                                    <?php if($productVariants->count() != 0): ?>
                                                        <div class="wsus__selectbox">
                                                            <div class="row">
                                                                <?php $__currentLoopData = $productVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productVariant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $items = App\Models\ProductVariantItem::orderBy('is_default','desc')->where(['product_variant_id' => $productVariant->id, 'product_id' => $bestProduct->id])->get();
                                                                    ?>
                                                                    <?php if($items->count() != 0): ?>
                                                                        <div class="col-xl-6 col-sm-6 mb-3">
                                                                            <h5 class="mb-2"><?php echo e($productVariant->name); ?>:</h5>

                                                                            <input type="hidden" name="variants[]" value="<?php echo e($productVariant->id); ?>">
                                                                            <input type="hidden" name="variantNames[]" value="<?php echo e($productVariant->name); ?>">

                                                                            <select class="select_2 productModalVariant" name="items[]" data-product="<?php echo e($bestProduct->id); ?>">
                                                                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <ul class="wsus__button_area">
                                                        <li><button type="button" onclick="addToCartInProductModal('<?php echo e($bestProduct->id); ?>')" class="add_cart"><?php echo e(__('user.add to cart')); ?></button></li>
                                                        <li><a class="buy_now" href="javascript:;" onclick="addToBuyNow('<?php echo e($bestProduct->id); ?>')"><?php echo e(__('user.buy now')); ?></a></li>
                                                        <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($bestProduct->id); ?>')"><i class="fal fa-heart"></i></a></li>
                                                        <li><a href="javascript:;" onclick="addToCompare('<?php echo e($bestProduct->id); ?>')"><i class="far fa-random"></i></a></li>
                                                    </ul>
                                                </form>
                                                <?php if($bestProduct->sku): ?>
                                                <p class="brand_model"><span><?php echo e(__('user.Model')); ?> :</span> <?php echo e($bestProduct->sku); ?></p>
                                                <?php endif; ?>

                                                <p class="brand_model"><span><?php echo e(__('user.Brand')); ?> :</span> <a href="<?php echo e(route('product',['brand' => $bestProduct->brand->slug])); ?>"><?php echo e($bestProduct->brand->name); ?></a></p>
                                                <p class="brand_model"><span><?php echo e(__('user.Category')); ?> :</span> <a href="<?php echo e(route('product',['category' => $bestProduct->category->slug])); ?>"><?php echo e($bestProduct->category->name); ?></a></p>
                                                <div class="wsus__pro_det_share d-none">
                                                    <h5><?php echo e(__('user.share')); ?> :</h5>
                                                    <ul class="d-flex">
                                                        <li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('product-detail', $bestProduct->slug)); ?>&t=<?php echo e($bestProduct->name); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                                        <li><a class="twitter" href="https://twitter.com/share?text=<?php echo e($bestProduct->name); ?>&url=<?php echo e(route('product-detail', $bestProduct->slug)); ?>"><i class="fab fa-twitter"></i></a></li>
                                                        <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('product-detail', $bestProduct->slug)); ?>&title=<?php echo e($bestProduct->name); ?>"><i class="fab fa-linkedin"></i></a></li>
                                                        <li><a class="pinterest" href="https://www.pinterest.com/pin/create/button/?description=<?php echo e($bestProduct->name); ?>&media=&url=<?php echo e(route('product-detail', $bestProduct->slug)); ?>"><i class="fab fa-pinterest-p"></i></a></li>
                                                    </ul>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <section class="product_popup_modal">
                        <div class="modal fade" id="productModalView-<?php echo e($topProduct->id); ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                                class="far fa-times"></i></button>
                                        <div class="row">
                                            <div class="col-xl-6 col-12 col-sm-10 col-md-8 col-lg-6 m-auto display">
                                                <div class="wsus__quick_view_img">
                                                    <?php if($topProduct->video_link): ?>
                                                        <?php
                                                            $video_id=explode("=",$topProduct->video_link);
                                                        ?>
                                                        <a class="venobox wsus__pro_det_video" data-autoplay="true" data-vbtype="video"
                                                        href="https://youtu.be/<?php echo e($video_id[1]); ?>">
                                                        <i class="fas fa-play"></i>
                                                    </a>
                                                    <?php endif; ?>

                                                    <div class="row modal_slider">
                                                        <?php $__currentLoopData = $topProduct->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-xl-12">
                                                            <div class="modal_slider_img">
                                                                <img src="<?php echo e(asset($image->image)); ?>" alt="product" class="img-fluid w-100">
                                                            </div>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-12 col-sm-12 col-md-12 col-lg-6">
                                                <div class="wsus__pro_details_text">
                                                    <a class="title" href="<?php echo e(route('product-detail', $topProduct->slug)); ?>"><?php echo e($topProduct->name); ?></a>

                                                        <?php if($topProduct->qty == 0): ?>
                                                        <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.Out of Stock')); ?></span></p>
                                                        <?php else: ?>
                                                            <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.In stock')); ?>

                                                                <?php if($setting->show_product_qty == 1): ?>
                                                                    </span> (<?php echo e($topProduct->qty); ?> <?php echo e(__('user.item')); ?>)
                                                                <?php endif; ?>
                                                            </p>
                                                        <?php endif; ?>


                                                    <?php
                                                        $reviewQty = $topProduct->reviews->where('status',1)->count();
                                                        $totalReview = $topProduct->reviews->where('status',1)->sum('rating');

                                                        if ($reviewQty > 0) {
                                                            $average = $totalReview / $reviewQty;

                                                            $intAverage = intval($average);

                                                            $nextValue = $intAverage + 1;
                                                            $reviewPoint = $intAverage;
                                                            $halfReview=false;
                                                            if($intAverage < $average && $average < $nextValue){
                                                                $reviewPoint= $intAverage + 0.5;
                                                                $halfReview=true;
                                                            }
                                                        }
                                                    ?>

                                                    <?php
                                                        $variantPrice = 0;
                                                        $variants = $topProduct->variants->where('status', 1);
                                                        if($variants->count() != 0){
                                                            foreach ($variants as $variants_key => $variant) {
                                                                if($variant->variantItems->where('status',1)->count() != 0){
                                                                    $item = $variant->variantItems->where('is_default',1)->first();
                                                                    if($item){
                                                                        $variantPrice += $item->price;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        $isCampaign = false;
                                                        $today = date('Y-m-d H:i:s');
                                                        $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $topProduct->id])->first();
                                                        if($campaign){
                                                            $campaign = $campaign->campaign;
                                                            if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                                $isCampaign = true;
                                                            }
                                                            $campaignOffer = $campaign->offer;
                                                            $productPrice = $topProduct->price;
                                                            $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                            $totalPrice = $topProduct->price;
                                                            $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                                        }

                                                        $totalPrice = $topProduct->price;
                                                        if($topProduct->offer_price != null){
                                                            $offerPrice = $topProduct->offer_price;
                                                            $offer = $totalPrice - $offerPrice;
                                                            $percentage = ($offer * 100) / $totalPrice;
                                                            $percentage = round($percentage);
                                                        }


                                                    ?>

                                                    <?php if($isCampaign): ?>
                                                        <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductModalPrice-<?php echo e($topProduct->id); ?>"><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?></span>  <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                    <?php else: ?>
                                                        <?php if($topProduct->offer_price == null): ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($topProduct->id); ?>"><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></span></h4>
                                                        <?php else: ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($topProduct->id); ?>"><?php echo e(sprintf("%.2f", $topProduct->offer_price + $variantPrice)); ?></span> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty > 0): ?>
                                                        <p class="review">
                                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                                <?php if($i <= $reviewPoint): ?>
                                                                    <i class="fas fa-star"></i>
                                                                <?php elseif($i> $reviewPoint ): ?>
                                                                    <?php if($halfReview==true): ?>
                                                                    <i class="fas fa-star-half-alt"></i>
                                                                        <?php
                                                                            $halfReview=false
                                                                        ?>
                                                                    <?php else: ?>
                                                                    <i class="fal fa-star"></i>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php endfor; ?>
                                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty == 0): ?>
                                                        <p class="review">
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php
                                                        $productPrice = 0;
                                                        if($isCampaign){
                                                            $productPrice = $campaignOfferPrice + $variantPrice;
                                                        }else{
                                                            if ($topProduct->offer_price == null) {
                                                                $productPrice = $totalPrice + $variantPrice;
                                                            }else {
                                                                $productPrice = $topProduct->offer_price + $variantPrice;
                                                            }
                                                        }
                                                    ?>
                                                    <form id="productModalFormId-<?php echo e($topProduct->id); ?>">
                                                    <div class="wsus__quentity">
                                                        <h5><?php echo e(__('user.quantity')); ?> :</h5>
                                                        <div class="modal_btn">
                                                            <button onclick="productModalDecrement('<?php echo e($topProduct->id); ?>')" type="button" class="btn btn-danger btn-sm">-</button>
                                                            <input id="productModalQty-<?php echo e($topProduct->id); ?>" name="quantity"  readonly class="form-control" type="text" min="1" max="100" value="1" />
                                                            <button onclick="productModalIncrement('<?php echo e($topProduct->id); ?>','<?php echo e($topProduct->qty); ?>')" type="button" class="btn btn-success btn-sm">+</button>
                                                        </div>
                                                        <h3 class="d-none"><?php echo e($currencySetting->currency_icon); ?><span id="productModalPrice-<?php echo e($topProduct->id); ?>"><?php echo e(sprintf("%.2f",$productPrice)); ?></span></h3>

                                                        <input type="hidden" name="product_id" value="<?php echo e($topProduct->id); ?>">
                                                        <input type="hidden" name="image" value="<?php echo e($topProduct->thumb_image); ?>">
                                                        <input type="hidden" name="slug" value="<?php echo e($topProduct->slug); ?>">

                                                    </div>
                                                    <?php
                                                        $productVariants = App\Models\ProductVariant::where(['status' => 1, 'product_id'=> $topProduct->id])->get();
                                                    ?>
                                                    <?php if($productVariants->count() != 0): ?>
                                                        <div class="wsus__selectbox">
                                                            <div class="row">
                                                                <?php $__currentLoopData = $productVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productVariant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $items = App\Models\ProductVariantItem::orderBy('is_default','desc')->where(['product_variant_id' => $productVariant->id, 'product_id' => $topProduct->id])->get();
                                                                    ?>
                                                                    <?php if($items->count() != 0): ?>
                                                                        <div class="col-xl-6 col-sm-6 mb-3">
                                                                            <h5 class="mb-2"><?php echo e($productVariant->name); ?>:</h5>

                                                                            <input type="hidden" name="variants[]" value="<?php echo e($productVariant->id); ?>">
                                                                            <input type="hidden" name="variantNames[]" value="<?php echo e($productVariant->name); ?>">

                                                                            <select class="select_2 productModalVariant" name="items[]" data-product="<?php echo e($topProduct->id); ?>">
                                                                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <ul class="wsus__button_area">
                                                        <li><button type="button" onclick="addToCartInProductModal('<?php echo e($topProduct->id); ?>')" class="add_cart"><?php echo e(__('user.add to cart')); ?></button></li>
                                                        <li><a class="buy_now" href="javascript:;" onclick="addToBuyNow('<?php echo e($topProduct->id); ?>')"><?php echo e(__('user.buy now')); ?></a></li>
                                                        <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($topProduct->id); ?>')"><i class="fal fa-heart"></i></a></li>
                                                        <li><a href="javascript:;" onclick="addToCompare('<?php echo e($topProduct->id); ?>')"><i class="far fa-random"></i></a></li>
                                                    </ul>
                                                </form>
                                                <?php if($topProduct->sku): ?>
                                                <p class="brand_model"><span><?php echo e(__('user.Model')); ?> :</span> <?php echo e($topProduct->sku); ?></p>
                                                <?php endif; ?>

                                                <p class="brand_model"><span><?php echo e(__('user.Brand')); ?> :</span> <a href="<?php echo e(route('product',['brand' => $topProduct->brand->slug])); ?>"><?php echo e($topProduct->brand->name); ?></a></p>
                                                <p class="brand_model"><span><?php echo e(__('user.Category')); ?> :</span> <a href="<?php echo e(route('product',['category' => $topProduct->category->slug])); ?>"><?php echo e($topProduct->category->name); ?></a></p>
                                                <div class="wsus__pro_det_share d-none">
                                                    <h5><?php echo e(__('user.share')); ?> :</h5>
                                                    <ul class="d-flex">
                                                        <li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('product-detail', $topProduct->slug)); ?>&t=<?php echo e($topProduct->name); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                                        <li><a class="twitter" href="https://twitter.com/share?text=<?php echo e($topProduct->name); ?>&url=<?php echo e(route('product-detail', $topProduct->slug)); ?>"><i class="fab fa-twitter"></i></a></li>
                                                        <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('product-detail', $topProduct->slug)); ?>&title=<?php echo e($topProduct->name); ?>"><i class="fab fa-linkedin"></i></a></li>
                                                        <li><a class="pinterest" href="https://www.pinterest.com/pin/create/button/?description=<?php echo e($topProduct->name); ?>&media=&url=<?php echo e(route('product-detail', $topProduct->slug)); ?>"><i class="fab fa-pinterest-p"></i></a></li>
                                                    </ul>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php $__currentLoopData = $newProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $newProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <section class="product_popup_modal">
                        <div class="modal fade" id="productModalView-<?php echo e($newProduct->id); ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                                class="far fa-times"></i></button>
                                        <div class="row">
                                            <div class="col-xl-6 col-12 col-sm-10 col-md-8 col-lg-6 m-auto display">
                                                <div class="wsus__quick_view_img">
                                                    <?php if($newProduct->video_link): ?>
                                                        <?php
                                                            $video_id=explode("=",$newProduct->video_link);
                                                        ?>
                                                        <a class="venobox wsus__pro_det_video" data-autoplay="true" data-vbtype="video"
                                                        href="https://youtu.be/<?php echo e($video_id[1]); ?>">
                                                        <i class="fas fa-play"></i>
                                                    </a>
                                                    <?php endif; ?>

                                                    <div class="row modal_slider">
                                                        <?php $__currentLoopData = $newProduct->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-xl-12">
                                                            <div class="modal_slider_img">
                                                                <img src="<?php echo e(asset($image->image)); ?>" alt="product" class="img-fluid w-100">
                                                            </div>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-12 col-sm-12 col-md-12 col-lg-6">
                                                <div class="wsus__pro_details_text">
                                                    <a class="title" href="<?php echo e(route('product-detail', $newProduct->slug)); ?>"><?php echo e($newProduct->name); ?></a>

                                                        <?php if($newProduct->qty == 0): ?>
                                                        <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.Out of Stock')); ?></span></p>
                                                        <?php else: ?>
                                                            <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.In stock')); ?>

                                                                <?php if($setting->show_product_qty == 1): ?>
                                                                    </span> (<?php echo e($newProduct->qty); ?> <?php echo e(__('user.item')); ?>)
                                                                <?php endif; ?>
                                                            </p>
                                                        <?php endif; ?>


                                                    <?php
                                                        $reviewQty = $newProduct->reviews->where('status',1)->count();
                                                        $totalReview = $newProduct->reviews->where('status',1)->sum('rating');

                                                        if ($reviewQty > 0) {
                                                            $average = $totalReview / $reviewQty;

                                                            $intAverage = intval($average);

                                                            $nextValue = $intAverage + 1;
                                                            $reviewPoint = $intAverage;
                                                            $halfReview=false;
                                                            if($intAverage < $average && $average < $nextValue){
                                                                $reviewPoint= $intAverage + 0.5;
                                                                $halfReview=true;
                                                            }
                                                        }
                                                    ?>

                                                    <?php
                                                        $variantPrice = 0;
                                                        $variants = $newProduct->variants->where('status', 1);
                                                        if($variants->count() != 0){
                                                            foreach ($variants as $variants_key => $variant) {
                                                                if($variant->variantItems->where('status',1)->count() != 0){
                                                                    $item = $variant->variantItems->where('is_default',1)->first();
                                                                    if($item){
                                                                        $variantPrice += $item->price;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        $isCampaign = false;
                                                        $today = date('Y-m-d H:i:s');
                                                        $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $newProduct->id])->first();
                                                        if($campaign){
                                                            $campaign = $campaign->campaign;
                                                            if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                                $isCampaign = true;
                                                            }
                                                            $campaignOffer = $campaign->offer;
                                                            $productPrice = $newProduct->price;
                                                            $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                            $totalPrice = $newProduct->price;
                                                            $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                                        }

                                                        $totalPrice = $newProduct->price;
                                                        if($newProduct->offer_price != null){
                                                            $offerPrice = $newProduct->offer_price;
                                                            $offer = $totalPrice - $offerPrice;
                                                            $percentage = ($offer * 100) / $totalPrice;
                                                            $percentage = round($percentage);
                                                        }


                                                    ?>

                                                    <?php if($isCampaign): ?>
                                                        <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductModalPrice-<?php echo e($newProduct->id); ?>"><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?></span>  <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                    <?php else: ?>
                                                        <?php if($newProduct->offer_price == null): ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($newProduct->id); ?>"><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></span></h4>
                                                        <?php else: ?>
                                                            <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($newProduct->id); ?>"><?php echo e(sprintf("%.2f", $newProduct->offer_price + $variantPrice)); ?></span> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty > 0): ?>
                                                        <p class="review">
                                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                                <?php if($i <= $reviewPoint): ?>
                                                                    <i class="fas fa-star"></i>
                                                                <?php elseif($i> $reviewPoint ): ?>
                                                                    <?php if($halfReview==true): ?>
                                                                    <i class="fas fa-star-half-alt"></i>
                                                                        <?php
                                                                            $halfReview=false
                                                                        ?>
                                                                    <?php else: ?>
                                                                    <i class="fal fa-star"></i>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php endfor; ?>
                                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php if($reviewQty == 0): ?>
                                                        <p class="review">
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <i class="fal fa-star"></i>
                                                            <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                                        </p>
                                                    <?php endif; ?>

                                                    <?php
                                                        $productPrice = 0;
                                                        if($isCampaign){
                                                            $productPrice = $campaignOfferPrice + $variantPrice;
                                                        }else{
                                                            if ($newProduct->offer_price == null) {
                                                                $productPrice = $totalPrice + $variantPrice;
                                                            }else {
                                                                $productPrice = $newProduct->offer_price + $variantPrice;
                                                            }
                                                        }
                                                    ?>
                                                    <form id="productModalFormId-<?php echo e($newProduct->id); ?>">
                                                    <div class="wsus__quentity">
                                                        <h5><?php echo e(__('user.quantity')); ?> :</h5>
                                                        <div class="modal_btn">
                                                            <button onclick="productModalDecrement('<?php echo e($newProduct->id); ?>')" type="button" class="btn btn-danger btn-sm">-</button>
                                                            <input id="productModalQty-<?php echo e($newProduct->id); ?>" name="quantity"  readonly class="form-control" type="text" min="1" max="100" value="1" />
                                                            <button onclick="productModalIncrement('<?php echo e($newProduct->id); ?>','<?php echo e($newProduct->qty); ?>')" type="button" class="btn btn-success btn-sm">+</button>
                                                        </div>
                                                        <h3 class="d-none"><?php echo e($currencySetting->currency_icon); ?><span id="productModalPrice-<?php echo e($newProduct->id); ?>"><?php echo e(sprintf("%.2f",$productPrice)); ?></span></h3>

                                                        <input type="hidden" name="product_id" value="<?php echo e($newProduct->id); ?>">
                                                        <input type="hidden" name="image" value="<?php echo e($newProduct->thumb_image); ?>">
                                                        <input type="hidden" name="slug" value="<?php echo e($newProduct->slug); ?>">

                                                    </div>
                                                    <?php
                                                        $productVariants = App\Models\ProductVariant::where(['status' => 1, 'product_id'=> $newProduct->id])->get();
                                                    ?>
                                                    <?php if($productVariants->count() != 0): ?>
                                                        <div class="wsus__selectbox">
                                                            <div class="row">
                                                                <?php $__currentLoopData = $productVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productVariant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $items = App\Models\ProductVariantItem::orderBy('is_default','desc')->where(['product_variant_id' => $productVariant->id, 'product_id' => $newProduct->id])->get();
                                                                    ?>
                                                                    <?php if($items->count() != 0): ?>
                                                                        <div class="col-xl-6 col-sm-6 mb-3">
                                                                            <h5 class="mb-2"><?php echo e($productVariant->name); ?>:</h5>

                                                                            <input type="hidden" name="variants[]" value="<?php echo e($productVariant->id); ?>">
                                                                            <input type="hidden" name="variantNames[]" value="<?php echo e($productVariant->name); ?>">

                                                                            <select class="select_2 productModalVariant" name="items[]" data-product="<?php echo e($newProduct->id); ?>">
                                                                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <ul class="wsus__button_area">
                                                        <li><button type="button" onclick="addToCartInProductModal('<?php echo e($newProduct->id); ?>')" class="add_cart"><?php echo e(__('user.add to cart')); ?></button></li>
                                                        <li><a class="buy_now" href="javascript:;" onclick="addToBuyNow('<?php echo e($newProduct->id); ?>')"><?php echo e(__('user.buy now')); ?></a></li>
                                                        <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($newProduct->id); ?>')"><i class="fal fa-heart"></i></a></li>
                                                        <li><a href="javascript:;" onclick="addToCompare('<?php echo e($newProduct->id); ?>')"><i class="far fa-random"></i></a></li>
                                                    </ul>
                                                </form>
                                                <?php if($newProduct->sku): ?>
                                                <p class="brand_model"><span><?php echo e(__('user.Model')); ?> :</span> <?php echo e($newProduct->sku); ?></p>
                                                <?php endif; ?>

                                                <p class="brand_model"><span><?php echo e(__('user.Brand')); ?> :</span> <a href="<?php echo e(route('product',['brand' => $newProduct->brand->slug])); ?>"><?php echo e($newProduct->brand->name); ?></a></p>
                                                <p class="brand_model"><span><?php echo e(__('user.Category')); ?> :</span> <a href="<?php echo e(route('product',['category' => $newProduct->category->slug])); ?>"><?php echo e($newProduct->category->name); ?></a></p>
                                                <div class="wsus__pro_det_share d-none">
                                                    <h5><?php echo e(__('user.share')); ?> :</h5>
                                                    <ul class="d-flex">
                                                        <li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('product-detail', $newProduct->slug)); ?>&t=<?php echo e($newProduct->name); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                                        <li><a class="twitter" href="https://twitter.com/share?text=<?php echo e($newProduct->name); ?>&url=<?php echo e(route('product-detail', $newProduct->slug)); ?>"><i class="fab fa-twitter"></i></a></li>
                                                        <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('product-detail', $newProduct->slug)); ?>&title=<?php echo e($newProduct->name); ?>"><i class="fab fa-linkedin"></i></a></li>
                                                        <li><a class="pinterest" href="https://www.pinterest.com/pin/create/button/?description=<?php echo e($newProduct->name); ?>&media=&url=<?php echo e(route('product-detail', $newProduct->slug)); ?>"><i class="fab fa-pinterest-p"></i></a></li>
                                                    </ul>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
            </div>
            <?php endif; ?>


            <?php
                $bannerVisiblity = $visibilities->where('id',8)->first();
            ?>
            <?php if($bannerVisiblity->status == 1): ?>
                <section id="wsus__single_banner">
                    <div class="">
                        <div class="row">
                            <?php
                                $bannerOne = $banners->where('id',5)->first();
                                $bannerTwo = $banners->where('id',6)->first();
                            ?>
                            <div class="col-xl-6 col-lg-6">
                                <div class="wsus__single_banner_content">
                                    <div class="wsus__single_banner_img">
                                        <img src="<?php echo e($bannerOne->image); ?>" alt="banner" class="img-fluid w-100">
                                    </div>
                                    <div class="wsus__single_banner_text">
                                        <h6><?php echo e($bannerOne->description); ?></h6>
                                        <h3><?php echo e($bannerOne->title); ?></h3>
                                        <a class="shop_btn" href="<?php echo e($bannerOne->link); ?>"><?php echo e(__('user.shop now')); ?></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6">
                                <div class="wsus__single_banner_content">
                                    <div class="wsus__single_banner_img">
                                        <img src="<?php echo e($bannerTwo->image); ?>" alt="banner" class="img-fluid w-100">
                                    </div>
                                    <div class="wsus__single_banner_text">
                                        <h6><?php echo e($bannerTwo->description); ?></h6>
                                        <h3><?php echo e($bannerTwo->title); ?></h3>
                                        <a class="shop_btn" href="<?php echo e($bannerTwo->link); ?>"><?php echo e(__('user.shop now')); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            <?php endif; ?>
        </div>
    </section>

    <!--============================
           HOT DEALS END
    ==============================-->



    <!--============================
        WEEKLY BEST ITEM START
    ==============================-->
<?php
    $threeColVisible = $visibilities->where('id',9)->first();
?>
<?php if($threeColVisible->status == 1): ?>
    <section id="wsus__weekly_best">
        <div class="container">
            <div class="row">
                <div class="col-xl-4 col-sm-6 col-md-6 col-lg-4">
                    <div class="wsus__section_header">
                        <?php
                            $firstCategory = $columnCategories->where('id',$threeColumnCategory->category_id_one)->first();
                        ?>
                        <h3><?php echo e($firstCategory ? $firstCategory->name : ''); ?></h3>
                    </div>
                    <div class="row weekly_best">
                        <?php $__currentLoopData = $threeColumnFirstCategoryProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $threeColfirstCatProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-12">
                                <a class="wsus__hot_deals__single" href="<?php echo e(route('product-detail', $threeColfirstCatProduct->slug)); ?>">
                                    <div class="wsus__hot_deals__single_img">
                                        <img src="<?php echo e(asset($threeColfirstCatProduct->thumb_image)); ?>" alt="bag" class="img-fluid w-100">
                                    </div>
                                    <div class="wsus__hot_deals__single_text">
                                        <h5><?php echo e($threeColfirstCatProduct->short_name); ?></h5>
                                        <?php
                                            $reviewQty = $threeColfirstCatProduct->reviews->where('status',1)->count();
                                            $totalReview = $threeColfirstCatProduct->reviews->where('status',1)->sum('rating');
                                            if ($reviewQty > 0) {
                                                $average = $totalReview / $reviewQty;
                                                $intAverage = intval($average);
                                                $nextValue = $intAverage + 1;
                                                $reviewPoint = $intAverage;
                                                $halfReview=false;
                                                if($intAverage < $average && $average < $nextValue){
                                                    $reviewPoint= $intAverage + 0.5;
                                                    $halfReview=true;
                                                }
                                            }
                                        ?>

                                        <?php if($reviewQty > 0): ?>
                                            <p class="wsus__rating">
                                                <?php for($i = 1; $i <=5; $i++): ?>
                                                    <?php if($i <= $reviewPoint): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php elseif($i> $reviewPoint ): ?>
                                                        <?php if($halfReview==true): ?>
                                                        <i class="fas fa-star-half-alt"></i>
                                                            <?php
                                                                $halfReview=false
                                                            ?>
                                                        <?php else: ?>
                                                        <i class="fal fa-star"></i>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                                <span>(<?php echo e($reviewQty); ?>)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php if($reviewQty == 0): ?>
                                            <p class="wsus__rating">
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <span>(0)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php
                                            $variantPrice = 0;
                                            $variants = $threeColfirstCatProduct->variants->where('status', 1);
                                            if($variants->count() != 0){
                                                foreach ($variants as $variants_key => $variant) {
                                                    if($variant->variantItems->where('status',1)->count() != 0){
                                                        $item = $variant->variantItems->where('is_default',1)->first();
                                                        if($item){
                                                            $variantPrice += $item->price;
                                                        }
                                                    }
                                                }
                                            }

                                            $isCampaign = false;
                                            $today = date('Y-m-d H:i:s');
                                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $threeColfirstCatProduct->id])->first();
                                            if($campaign){
                                                $campaign = $campaign->campaign;
                                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                    $isCampaign = true;
                                                }
                                                $campaignOffer = $campaign->offer;
                                                $productPrice = $threeColfirstCatProduct->price;
                                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                $totalPrice = $productPrice;
                                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                            }

                                            $totalPrice = $threeColfirstCatProduct->price;
                                            if($threeColfirstCatProduct->offer_price != null){
                                                $offerPrice = $threeColfirstCatProduct->offer_price;
                                                $offer = $totalPrice - $offerPrice;
                                                $percentage = ($offer * 100) / $totalPrice;
                                                $percentage = round($percentage);
                                            }
                                        ?>

                                        <?php if($isCampaign): ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php else: ?>
                                            <?php if($threeColfirstCatProduct->offer_price == null): ?>
                                                <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                            <?php else: ?>
                                                <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $threeColfirstCatProduct->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
                <div class="col-xl-4 col-sm-6 col-md-6 col-lg-4">
                    <div class="wsus__section_header">
                        <?php
                            $secondCategory = $columnCategories->where('id',$threeColumnCategory->category_id_two)->first();
                        ?>
                        <h3><?php echo e($secondCategory ? $secondCategory->name : ''); ?></h3>
                    </div>
                    <div class="row weekly_best">
                        <?php $__currentLoopData = $threeColumnSecondCategoryProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $threeColsecondCatProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-12">
                                <a class="wsus__hot_deals__single" href="<?php echo e(route('product-detail', $threeColsecondCatProduct->slug)); ?>">
                                    <div class="wsus__hot_deals__single_img">
                                        <img src="<?php echo e(asset($threeColsecondCatProduct->thumb_image)); ?>" alt="bag" class="img-fluid w-100">
                                    </div>
                                    <div class="wsus__hot_deals__single_text">
                                        <h5><?php echo e($threeColsecondCatProduct->short_name); ?></h5>
                                        <?php
                                            $reviewQty = $threeColsecondCatProduct->reviews->where('status',1)->count();
                                            $totalReview = $threeColsecondCatProduct->reviews->where('status',1)->sum('rating');
                                            if ($reviewQty > 0) {
                                                $average = $totalReview / $reviewQty;
                                                $intAverage = intval($average);
                                                $nextValue = $intAverage + 1;
                                                $reviewPoint = $intAverage;
                                                $halfReview=false;
                                                if($intAverage < $average && $average < $nextValue){
                                                    $reviewPoint= $intAverage + 0.5;
                                                    $halfReview=true;
                                                }
                                            }
                                        ?>

                                        <?php if($reviewQty > 0): ?>
                                            <p class="wsus__rating">
                                                <?php for($i = 1; $i <=5; $i++): ?>
                                                    <?php if($i <= $reviewPoint): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php elseif($i> $reviewPoint ): ?>
                                                        <?php if($halfReview==true): ?>
                                                        <i class="fas fa-star-half-alt"></i>
                                                            <?php
                                                                $halfReview=false
                                                            ?>
                                                        <?php else: ?>
                                                        <i class="fal fa-star"></i>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                                <span>(<?php echo e($reviewQty); ?>)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php if($reviewQty == 0): ?>
                                            <p class="wsus__rating">
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <span>(0)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php
                                            $variantPrice = 0;
                                            $variants = $threeColsecondCatProduct->variants->where('status', 1);
                                            if($variants->count() != 0){
                                                foreach ($variants as $variants_key => $variant) {
                                                    if($variant->variantItems->where('status',1)->count() != 0){
                                                        $item = $variant->variantItems->where('is_default',1)->first();
                                                        if($item){
                                                            $variantPrice += $item->price;
                                                        }
                                                    }
                                                }
                                            }

                                            $isCampaign = false;
                                            $today = date('Y-m-d H:i:s');
                                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $threeColsecondCatProduct->id])->first();
                                            if($campaign){
                                                $campaign = $campaign->campaign;
                                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                    $isCampaign = true;
                                                }
                                                $campaignOffer = $campaign->offer;
                                                $productPrice = $threeColsecondCatProduct->price;
                                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                $totalPrice = $productPrice;
                                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                            }

                                            $totalPrice = $threeColsecondCatProduct->price;
                                            if($threeColsecondCatProduct->offer_price != null){
                                                $offerPrice = $threeColsecondCatProduct->offer_price;
                                                $offer = $totalPrice - $offerPrice;
                                                $percentage = ($offer * 100) / $totalPrice;
                                                $percentage = round($percentage);
                                            }
                                        ?>

                                        <?php if($isCampaign): ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php else: ?>
                                            <?php if($threeColsecondCatProduct->offer_price == null): ?>
                                                <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                            <?php else: ?>
                                                <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $threeColsecondCatProduct->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </div>
                </div>
                <div class="col-xl-4 col-sm-6 col-md-6 col-lg-4">
                    <div class="wsus__section_header">
                        <?php
                            $threeCategory = $columnCategories->where('id',$threeColumnCategory->category_id_three)->first();
                        ?>
                        <h3><?php echo e($threeCategory ? $threeCategory->name : ''); ?></h3>
                    </div>
                    <div class="row weekly_best">
                        <?php $__currentLoopData = $threeColumnThirdCategoryProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $threeColCatProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-12">
                                <a class="wsus__hot_deals__single" href="<?php echo e(route('product-detail', $threeColCatProduct->slug)); ?>">
                                    <div class="wsus__hot_deals__single_img">
                                        <img src="<?php echo e(asset($threeColCatProduct->thumb_image)); ?>" alt="bag" class="img-fluid w-100">
                                    </div>
                                    <div class="wsus__hot_deals__single_text">
                                        <h5><?php echo e($threeColCatProduct->short_name); ?></h5>
                                        <?php
                                            $reviewQty = $threeColCatProduct->reviews->where('status',1)->count();
                                            $totalReview = $threeColCatProduct->reviews->where('status',1)->sum('rating');
                                            if ($reviewQty > 0) {
                                                $average = $totalReview / $reviewQty;
                                                $intAverage = intval($average);
                                                $nextValue = $intAverage + 1;
                                                $reviewPoint = $intAverage;
                                                $halfReview=false;
                                                if($intAverage < $average && $average < $nextValue){
                                                    $reviewPoint= $intAverage + 0.5;
                                                    $halfReview=true;
                                                }
                                            }
                                        ?>

                                        <?php if($reviewQty > 0): ?>
                                            <p class="wsus__rating">
                                                <?php for($i = 1; $i <=5; $i++): ?>
                                                    <?php if($i <= $reviewPoint): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php elseif($i> $reviewPoint ): ?>
                                                        <?php if($halfReview==true): ?>
                                                        <i class="fas fa-star-half-alt"></i>
                                                            <?php
                                                                $halfReview=false
                                                            ?>
                                                        <?php else: ?>
                                                        <i class="fal fa-star"></i>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                                <span>(<?php echo e($reviewQty); ?>)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php if($reviewQty == 0): ?>
                                            <p class="wsus__rating">
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <span>(0)</span>
                                            </p>
                                        <?php endif; ?>

                                        <?php
                                            $variantPrice = 0;
                                            $variants = $threeColCatProduct->variants->where('status', 1);
                                            if($variants->count() != 0){
                                                foreach ($variants as $variants_key => $variant) {
                                                    if($variant->variantItems->where('status',1)->count() != 0){
                                                        $item = $variant->variantItems->where('is_default',1)->first();
                                                        if($item){
                                                            $variantPrice += $item->price;
                                                        }
                                                    }
                                                }
                                            }

                                            $isCampaign = false;
                                            $today = date('Y-m-d H:i:s');
                                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $threeColCatProduct->id])->first();
                                            if($campaign){
                                                $campaign = $campaign->campaign;
                                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                    $isCampaign = true;
                                                }
                                                $campaignOffer = $campaign->offer;
                                                $productPrice = $threeColCatProduct->price;
                                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                $totalPrice = $productPrice;
                                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                            }

                                            $totalPrice = $threeColCatProduct->price;
                                            if($threeColCatProduct->offer_price != null){
                                                $offerPrice = $threeColCatProduct->offer_price;
                                                $offer = $totalPrice - $offerPrice;
                                                $percentage = ($offer * 100) / $totalPrice;
                                                $percentage = round($percentage);
                                            }
                                        ?>

                                        <?php if($isCampaign): ?>
                                            <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                        <?php else: ?>
                                            <?php if($threeColCatProduct->offer_price == null): ?>
                                                <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                            <?php else: ?>
                                                <p class="wsus__tk"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $threeColCatProduct->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
    <!--============================
        WEEKLY BEST ITEM END
    ==============================-->

        <!--============================
        LARGE BANNER  START
    ==============================-->

    <?php
        $bannerVisibility = $visibilities->where('id',10)->first();
    ?>
    <?php if($bannerVisibility->status == 1): ?>
    <section id="wsus__single_banner">
        <div class="container">
            <div class="row">
                <?php
                    $bannerOne = $banners->where('id',7)->first();
                    $bannerTwo = $banners->where('id',8)->first();
                ?>
                <div class="col-xl-6 col-lg-6">
                    <div class="wsus__single_banner_content">
                        <div class="wsus__single_banner_img">
                            <img src="<?php echo e(asset($bannerOne->image)); ?>" alt="banner" class="img-fluid w-100">
                        </div>
                        <div class="wsus__single_banner_text">
                            <h6><?php echo e($bannerOne->description); ?></h6>
                            <h3><?php echo e($bannerOne->title); ?></h3>
                            <a class="shop_btn" href="<?php echo e($bannerOne->link); ?>"><?php echo e(__('user.shop now')); ?></a>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="wsus__single_banner_content">
                        <div class="wsus__single_banner_img">
                            <img src="<?php echo e(asset($bannerTwo->image)); ?>" alt="banner" class="img-fluid w-100">
                        </div>
                        <div class="wsus__single_banner_text">
                            <h6><?php echo e($bannerTwo->description); ?></h6>
                            <h3><?php echo e($bannerTwo->title); ?></h3>
                            <a class="shop_btn" href="<?php echo e($bannerTwo->link); ?>"><?php echo e(__('user.shop now')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>
    <!--============================
        LARGE BANNER  END
    ==============================-->

    <!--============================
      HOME SERVOCES START
    ==============================-->
    <?php
        $serviceVisibility = $visibilities->where('id',11)->first();
    ?>
    <?php if($serviceVisibility->status == 1): ?>
    <section id="wsus__home_services">
        <div class="container">
            <div class="row">
                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-sm-6 col-lg-3">
                    <div class="wsus__home_services_single">
                        <i class="<?php echo e($service->icon); ?>"></i>
                        <h5><?php echo e($service->title); ?></h5>
                        <p><?php echo e($service->description); ?></p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
    <!--============================
        HOME SERVOCES END
    ==============================-->


    <!--============================
        HOME BLOGS START
    ==============================-->
<?php
    $blogVisibilty = $visibilities->where('id',12)->first();
?>
<?php if($blogVisibilty->status == 1): ?>
    <section id="wsus__blogs" class="home_blogs">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="wsus__section_header">
                        <h3><?php echo e(__('user.recent blogs')); ?></h3>
                        <a class="see_btn" href="<?php echo e(route('blog')); ?>"><?php echo e(__('user.see more')); ?> <i class="fas fa-caret-right"></i></a>
                    </div>
                </div>
            </div>
            <div class="row home_blog_slider">
                <?php
                    $colorId=1;
                ?>
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    if($index %4 ==0){
                        $colorId=1;
                    }

                    $color="";
                    if($colorId==1){
                        $color="blue";
                    }else if($colorId==2){
                        $color="red";
                    }else if($colorId==3){
                        $color="orange";
                    }else if($colorId==4){
                        $color="green";
                    }
                ?>
                <div class="col-xl-4">
                    <div class="wsus__single_blog">
                        <a class="wsus__blog_img" href="<?php echo e(route('blog-detail', $blog->slug)); ?>">
                            <img src="<?php echo e(asset($blog->image)); ?>" alt="blog" class="img-fluid w-100">
                        </a>
                        <a class="blog_top <?php echo e($color); ?>" href="<?php echo e(route('blog-by-category',$blog->category->slug)); ?>"><?php echo e($blog->category->name); ?></a>
                        <div class="wsus__blog_text">
                            <div class="wsus__blog_text_center">
                                <a href="<?php echo e(route('blog-detail', $blog->slug)); ?>"><?php echo e($blog->title); ?></a>
                                <p class="date"><span><?php echo e($blog->created_at->format('d F, Y')); ?></span> <?php echo e(__('user.Hosted by')); ?> <?php echo e($blog->admin->name); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                    $colorId ++;
                ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
    <!--============================
        HOME BLOGS END
    ==============================-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/index.blade.php ENDPATH**/ ?>